/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.waitermateproperty.screenlayouts;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import java.text.Format;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.textformat.DisplayableListFormat;
import officemate.screens.setup.configuration.waitermateproperty.screenlayouts.ScreenLayoutSearch;
import officemate.screens.setup.configuration.waitermateproperty.screenlayouts.ScreenLayoutStateEditor;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ScreenLayoutState
extends AbstractEditableTableState<GuiConfigSet>
implements StrategySaveCancelListener {
    private ScreenLayoutSearch screenLayoutSearch;
    private List<Terminal> allTerminals;
    ScreenLayoutStateEditor editor;

    public ScreenLayoutState() {
        super("Screen Layouts", AllPermissions.ACCESS_QUICK_SALE_NAV_INFO, "Change the Screen Layout in various parts of waitermate.");
        DeferredSaveStrategy saveStrat = SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this);
        saveStrat.addSaveCancelListener(this);
        this.setSaveStrategy(saveStrat);
        this.screenLayoutSearch = new ScreenLayoutSearch(GuiConfigSet.class);
    }

    @Override
    protected ObjectEditor<GuiConfigSet> createObjectEditor() {
        this.allTerminals = Terminal.getAllTerminals();
        this.editor = new ScreenLayoutStateEditor(this.allTerminals);
        return this.editor;
    }

    @Override
    public String getTypeName() {
        return "Screen Layouts Buttons";
    }

    @Override
    protected OfficeMateObjectSearch<GuiConfigSet> createSearchPanelFactory() {
        return this.screenLayoutSearch;
    }

    @Override
    protected TableStateCentralArea<GuiConfigSet> createCentralArea() {
        PersistentObjectTable<GuiConfigSet> table = new PersistentObjectTable<GuiConfigSet>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(GuiConfigSet.Properties.LABEL), new PropertyColumnFormat(GuiConfigSet.Properties.TERMINALS, (Format)new DisplayableListFormat())}));
        final Action deleteAction = this.getDeleteAction();
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GuiConfigSet set = (GuiConfigSet)ScreenLayoutState.this.getCentralArea().getSelectedObject();
                if (set != null) {
                    deleteAction.setEnabled(!set.equals((Object)GuiConfigSet.getDefaultSet((TerminalTypes)set.getTerminalType())));
                }
            }
        };
        table.addSelectionChangeListener(listener);
        return table;
    }

    @Override
    protected Class<GuiConfigSet> getDisplayingType() {
        return GuiConfigSet.class;
    }

    @Override
    protected GuiConfigSet createNewObject() {
        GuiConfigSet toEdit = (GuiConfigSet)super.createNewObject();
        toEdit.setTerminalType((TerminalTypes)this.screenLayoutSearch.getTerminalTypeSearchField().getSelectedObject());
        return toEdit;
    }

    @Override
    protected void doDelete(List<GuiConfigSet> toDelete) {
        if (toDelete.contains(GuiConfigSet.getDefaultSet((TerminalTypes)((TerminalTypes)this.screenLayoutSearch.getTerminalTypeSearchField().getSelectedObject())))) {
            Dialogs.showWarningDialog("Error!", "Can Not Delete the Default Screen Layout: Delete Aborted");
            return;
        }
        super.doDelete(toDelete);
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
        for (Terminal term : this.allTerminals) {
            term.save();
        }
    }
}

