/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.webpayment;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.ImageFormat;
import au.com.ordermate.util.image.ImageHelper;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.components.controls.NullableIntegerFormatter;
import officemate.components.controls.NullableNumberFormatter;
import officemate.screens.setup.menu.menuitemsetup.ImagePreviewChooser;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.converter.NullableBigDecimalToStringConverter;
import ordermate.gui.binding.converter.NullableLongToStringConverter;
import ordermate.gui.binding.validators.NumericalValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import ordermate.integration.jaxb.paypal.PayPalAddress;
import ordermate.integration.paypal.PayPalOAuth;
import ordermate.integration.paypal.PayPalTool;
import ordermate.misc.GeocodeLocation;
import ordermate.misc.GeocodingHelper;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;

public class WebPaymentIntegrationEditor
extends AbstractObjectEditor<WebPaymentIntegration> {
    private static final String EXT_PREFIX = "https://redback.ordermatecentral.com:8181/tom80/payattable/";
    private static final String EXT_SUFFIX = "/PayPal/";
    private static final String ISO_AU = "AU";
    private JLabel typeLabel;
    private BindingHelper<WebPaymentLocation> locationBindingsHelper;
    private JTextField lineOne;
    private JTextField lineTwo;
    private JTextField city;
    private JTextField state;
    private JTextField postcode;
    private JComboBox country;
    private JComboBox categoryComboBox;
    private Action imgChooser;
    private Action autoComplete;
    private Map<WebPaymentLocation, byte[]> imagesToUpload = new HashMap<WebPaymentLocation, byte[]>();
    private List<Component> restrictedComponents = new ArrayList<Component>();
    private JFormattedTextField intervalTextField;
    private JLabel intervalTextFieldLabel;
    private PayPalAddress payPalAddress;

    public WebPaymentIntegrationEditor() {
        this.imgChooser = new ImageAction();
        this.autoComplete = new AutoFillAction();
        this.setupBindings();
    }

    private void setupBindings() {
        this.lineOne = new JTextField(20);
        this.lineTwo = new JTextField(20);
        this.city = new JTextField(20);
        this.state = new JTextField(20);
        this.postcode = new JTextField(12);
        this.country = new JComboBox(new EventComboBoxModel(GlazedLists.eventList(Arrays.asList(Locale.getISOCountries()))));
        this.country.setSelectedItem(ISO_AU);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.typeLabel = new JLabel();
        builder.addRow("Type", (Component)this.typeLabel);
        builder.addRow("Label", (Component)this.setupTextField(WebPaymentIntegration.Properties.LABEL, 20));
        JTextField appID = this.setupTextField(WebPaymentIntegration.Properties.APP_ID, 20);
        appID.setEnabled(false);
        builder.addRow("App ID", (Component)appID);
        builder.addRow("Merchant Email", (Component)this.setupTextField(WebPaymentIntegration.Properties.MERCHANT_EMAIL, 20), "Your PayPal merchant email account to receive finance transactions to");
        builder.addRow("System State", (Component)this.setupComboBox(WebPaymentIntegration.Properties.SYSTEM_STATE, GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE})));
        BasicEventList categories = new BasicEventList();
        categories.addAll((Collection)CustomerCategory.getAllCategories());
        this.categoryComboBox = this.setupNullableComboBox(WebPaymentIntegration.Properties.DEFAULT_CUSTOMER_CATEGORY, (EventList)categories, "System Default");
        builder.addRow("Default Customer Category", (Component)this.categoryComboBox);
        builder.addSeparator("Location");
        this.locationBindingsHelper = new BindingHelper();
        this.locationBindingsHelper.bridgePropertyValid((JComponent)this);
        JButton autoFillButton = new JButton(this.autoComplete);
        builder.addRow("", this.addRestrictedComp(autoFillButton), "Fill in the details below with your Business Information");
        JTextField extIdField = this.setupTextFieldGivenBindings(WebPaymentLocation.Properties.EXT_ID, 20, null, this.locationBindingsHelper);
        extIdField.setEnabled(false);
        builder.addRow("PayPal ID", (Component)extIdField, "The Id generated by PayPal for your business location");
        JCheckBox statusField = this.setupCheckBoxGivenBindings(WebPaymentLocation.Properties.AVAILABLE, this.locationBindingsHelper);
        statusField.setEnabled(false);
        builder.addRow("Open?", (Component)statusField, "Shows if you business can be checked in to through PayPal applications");
        builder.addRow("Public Location Name", this.addRestrictedComp(this.setupTextFieldGivenBindings(WebPaymentLocation.Properties.LABEL, 20, null, this.locationBindingsHelper)), "The name to display to the public though PayPal applications");
        builder.addRow("Internal Location Name", this.addRestrictedComp(this.setupTextFieldGivenBindings(WebPaymentLocation.Properties.INTERNAL_LABEL, 20, null, this.locationBindingsHelper)), "The internal business name to identify your unique site");
        builder.addRow("Phone No.", this.addRestrictedComp(this.setupTextFieldGivenBindings(WebPaymentLocation.Properties.PHONE, 20, null, this.locationBindingsHelper)), "The contact phone number for your business");
        builder.addRow("Message", this.addRestrictedComp(this.setupTextFieldGivenBindings(WebPaymentLocation.Properties.MESSAGE, 20, null, this.locationBindingsHelper)), "A message to be displayed on PayPal applications");
        builder.addRow("Latitude", this.addRestrictedComp(this.setupNumberFieldGivenBindings(WebPaymentLocation.Properties.LATITUDE, 12, -90.0, 90.0, null, this.locationBindingsHelper)), "Your geographical co-ordinates in the latitudinal direction");
        builder.addRow("Longitude", this.addRestrictedComp(this.setupNumberFieldGivenBindings(WebPaymentLocation.Properties.LONGITUDE, 12, -180.0, 180.0, null, this.locationBindingsHelper)), "Your geographical co-ordinates in the longitudinal direction");
        JButton button = new JButton(this.imgChooser);
        DefaultComboBoxModel<WebPaymentLocation.ExtensionType> extensionModel = new DefaultComboBoxModel<WebPaymentLocation.ExtensionType>(WebPaymentLocation.ExtensionType.values());
        JComboBox box = this.setupComboBoxGivenBindings(WebPaymentLocation.Properties.EXTENSION_TYPE, extensionModel, null, this.locationBindingsHelper);
        box.setEditable(false);
        box.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(StringUtils.camelCaseToDisplayable((String)String.valueOf(value)));
                return comp;
            }
        });
        builder.addRow("Payment Methods Accepted", this.addRestrictedComp(box), "Pay@Table, Check In or Both");
        builder.addRow("Store ID", this.addRestrictedComp(this.setupLongFieldGivenBindings(WebPaymentLocation.Properties.OM_STORE_ID, 10, 0L, Long.MAX_VALUE, this.locationBindingsHelper)));
        builder.addRow("Logo", this.addRestrictedComp(button), "The image to be displayed to represent your business in PayPal applications");
        this.intervalTextFieldLabel = new JLabel("Update Interval (ms)");
        this.intervalTextField = this.setupLongFieldGivenBindings(WebPaymentLocation.Properties.UPDATE_INTERVAL, 6, 10000L, 300000L, this.locationBindingsHelper);
        this.intervalTextFieldLabel.setLabelFor(this.intervalTextField);
        builder.addRow(this.intervalTextFieldLabel, this.addRestrictedComp(this.intervalTextField), "The interval to which the webservice will be requested for updated information in milliseconds");
        builder.addSeparator("Address");
        builder.addRow("Line 1", this.addRestrictedComp(this.lineOne));
        builder.addRow("Line 2", this.addRestrictedComp(this.lineTwo));
        builder.addRow("City", this.addRestrictedComp(this.city));
        builder.addRow("State", this.addRestrictedComp(this.state));
        builder.addRow("Postcode", this.addRestrictedComp(this.postcode));
        builder.addRow("Country", this.addRestrictedComp(this.country));
        this.add((Component)builder.getPanel(), "Center");
    }

    private Component addRestrictedComp(Component comp) {
        this.restrictedComponents.add(comp);
        return comp;
    }

    @Override
    public void setObject(WebPaymentIntegration value) {
        super.setObject(value);
        this.typeLabel.setText(value.getType().name());
        WebPaymentLocation location = null;
        if (!value.getLocations().isEmpty()) {
            location = (WebPaymentLocation)value.getLocations().get(0);
        } else {
            location = new WebPaymentLocation((WebPaymentIntegration)this.getObject());
            ((WebPaymentIntegration)this.getObject()).addLocation(location);
        }
        this.locationBindingsHelper.setObject((Object)location);
        this.setupWebPaymentLocation(location);
        boolean toEnabled = new PayPalOAuth((WebPaymentIntegration)this.getObject()).hasValidToken();
        for (Component comp : this.restrictedComponents) {
            comp.setEnabled(toEnabled);
        }
        User loggedIn = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        if (loggedIn != null && User.getSystemAdministrator().equals((Object)loggedIn)) {
            this.intervalTextField.setVisible(true);
            this.intervalTextFieldLabel.setVisible(true);
        } else {
            this.intervalTextField.setVisible(false);
            this.intervalTextFieldLabel.setVisible(false);
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        ((WebPaymentLocation)this.locationBindingsHelper.getObject()).setIntegration((WebPaymentIntegration)this.getObject());
        WebPaymentLocation location = (WebPaymentLocation)this.locationBindingsHelper.getObject();
        this.saveWebPaymentLocation(this.payPalAddress, location);
        this.locationBindingsHelper.saveObject();
        Long value = location.getOmStoreId();
        if (value != null) {
            location.setExtensionUrl(EXT_PREFIX + value + EXT_SUFFIX);
        }
    }

    private void setupWebPaymentLocation(WebPaymentLocation location) {
        PayPalTool tool = new PayPalTool();
        PayPalAddress address = (PayPalAddress)tool.unmarshal(location.getAddress(), PayPalAddress.class);
        if (address == null) {
            address = this.createNewPayPalAddress();
        }
        this.payPalAddress = address;
        this.lineOne.setText(this.payPalAddress.getLine1());
        this.lineTwo.setText(this.payPalAddress.getLine2());
        this.city.setText(this.payPalAddress.getCity());
        this.state.setText(this.payPalAddress.getState());
        this.postcode.setText(this.payPalAddress.getPostalCode());
        this.country.setSelectedItem(this.payPalAddress.getCountry());
    }

    private PayPalAddress createNewPayPalAddress() {
        PayPalAddress address = new PayPalAddress();
        address.setCountry(ISO_AU);
        return address;
    }

    private void saveWebPaymentLocation(PayPalAddress toSet, WebPaymentLocation location) {
        PayPalTool tool = new PayPalTool();
        toSet.setLine1(this.lineOne.getText());
        toSet.setLine2(this.lineTwo.getText());
        toSet.setCity(this.city.getText());
        toSet.setState(this.state.getText());
        toSet.setPostalCode(this.postcode.getText());
        toSet.setCountry((String)this.country.getSelectedItem());
        String address = tool.marshal((Object)toSet);
        if (address == null) {
            // empty if block
        }
        location.setAddress(address);
    }

    public byte[] getCachedLogo(WebPaymentLocation location) {
        return this.imagesToUpload.get(location);
    }

    private JTextField setupTextFieldGivenBindings(PropertiedObject.Property propToBind, int numCols, Validator validator, BindingHelper helper) {
        JTextField field = new JTextField(numCols);
        field.setName(propToBind.getName());
        Binding binding = helper.createBinding(propToBind, (Object)field, "text");
        binding.addBindingListener((BindingListener)this.getListener());
        binding.setValidator(validator);
        return field;
    }

    private JCheckBox setupCheckBoxGivenBindings(PropertiedObject.Property propToBind, BindingHelper helper) {
        JCheckBox field = new JCheckBox();
        field.setName(propToBind.getName());
        Binding binding = helper.createBinding(propToBind, (Object)field, "selected");
        binding.addBindingListener((BindingListener)this.getListener());
        return field;
    }

    public JFormattedTextField setupLongFieldGivenBindings(PropertiedObject.Property toBind, int columns, long min, long max, BindingHelper helper) {
        JFormattedTextField field = new JFormattedTextField(new NullableIntegerFormatter());
        field.setName(toBind.getName());
        Binding binding = helper.createBinding(toBind, (Object)field, "text");
        if (columns >= 1) {
            field.setColumns(columns);
        }
        binding.setConverter((Converter)new NullableLongToStringConverter());
        binding.setValidator((Validator)new NumericalValidator((Number)min, (Number)max, Long.class));
        return field;
    }

    private JFormattedTextField setupNumberFieldGivenBindings(PropertiedObject.Property propToBind, int columns, double min, double max, String format, BindingHelper helper) {
        JFormattedTextField field = new JFormattedTextField(new NullableNumberFormatter());
        Binding binding = helper.createBinding(propToBind, (Object)field, "value");
        binding.addBindingListener((BindingListener)this.getListener());
        if (columns > 0) {
            field.setColumns(columns);
        }
        binding.setValidator((Validator)new NumericalValidator((Number)min, (Number)max, Double.class));
        binding.setConverter((Converter)new NullableBigDecimalToStringConverter());
        return field;
    }

    private JComboBox setupComboBoxGivenBindings(PropertiedObject.Property optionPropToBind, ComboBoxModel modelToUse, Validator validator, BindingHelper helper) {
        JComboBox box = new JComboBox(modelToUse);
        box.setName(optionPropToBind.getName());
        Binding binding = helper.createBinding(optionPropToBind, box, "selectedItem");
        if (validator != null) {
            binding.setValidator(validator);
        }
        box.addActionListener(this.getListener());
        return box;
    }

    private boolean loadImage(String pathName) {
        try {
            String[] result = pathName.split("\\.");
            String extension = result[1];
            File toLoad = new File(pathName);
            byte[] rawBytes = new ImageHelper().shrinkToByteSize((Image)ImageIO.read(toLoad), 65536, ImageFormat.parseString((String)extension));
            this.imagesToUpload.put((WebPaymentLocation)this.locationBindingsHelper.getObject(), rawBytes);
            return true;
        }
        catch (IOException e1) {
            OrderMate.LOG.warn("Could not load image into buffer!", (Throwable)e1);
            return false;
        }
    }

    @Override
    public void refresh() {
        BasicEventList categories = new BasicEventList();
        categories.addAll((Collection)CustomerCategory.getAllCategories());
        this.categoryComboBox.setModel(new NullableEventComboBoxModel((EventList)categories, (Object)"System Default"));
    }

    class AutoFillAction
    extends AbstractAction {
        public AutoFillAction() {
            super("Auto-Fill");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebPaymentIntegration obj = (WebPaymentIntegration)WebPaymentIntegrationEditor.this.getObject();
            ArrayList<WebPaymentLocation> changedLocations = new ArrayList<WebPaymentLocation>();
            for (WebPaymentLocation loc : obj.getLocations()) {
                GeocodingHelper geodude;
                GeocodeLocation location;
                BusinessInfo info = BusinessInfo.getInstance();
                loc.setLabel(info.getName());
                loc.setInternalLabel(info.getName() + " " + info.getLocation());
                loc.setPhone(info.getPhone());
                if (WebPaymentIntegrationEditor.this.loadImage(info.getLogo())) {
                    WebPaymentIntegrationEditor.this.imgChooser.putValue("Name", info.getLogo());
                }
                PayPalAddress ppAddr = new PayPalAddress();
                ppAddr.setCountry(WebPaymentIntegrationEditor.ISO_AU);
                ppAddr.setLine1(info.getAddress1());
                String crap = info.getAddress2();
                ArrayList<String> results = new ArrayList<String>(Arrays.asList(crap.trim().split(" ")));
                Collections.reverse(results);
                if (results.size() >= 3) {
                    String postcodeName = (String)results.get(0);
                    ppAddr.setPostalCode(postcodeName);
                    results.remove(0);
                    String stateName = (String)results.get(0);
                    ppAddr.setState(stateName);
                    results.remove(0);
                    StringBuilder cityName = new StringBuilder();
                    Collections.reverse(results);
                    for (String cityNamePart : results) {
                        cityName.append(cityNamePart).append(" ");
                    }
                    cityName.deleteCharAt(cityName.length() - 1);
                    ppAddr.setCity(cityName.toString());
                }
                if (info.getAddress1() != null && info.getAddress2() != null && (location = (geodude = new GeocodingHelper()).getGeocodeLocationForAddress(info.getAddress1() + " " + info.getAddress2())) != null) {
                    loc.setLatitude(location.getLat());
                    loc.setLongitude(location.getLng());
                }
                PayPalTool tool = new PayPalTool();
                String address = tool.marshal((Object)ppAddr);
                loc.setAddress(address);
                WebPaymentIntegrationEditor.this.payPalAddress = ppAddr;
                changedLocations.add(loc);
            }
            obj.setLocations(changedLocations);
            WebPaymentIntegrationEditor.this.setObject(obj);
        }
    }

    class ImageAction
    extends AbstractAction {
        public ImageAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImagePreviewChooser chooser = new ImagePreviewChooser();
            int returnVal = chooser.showOpenDialog(WebPaymentIntegrationEditor.this.getParent());
            if (returnVal == 0 && WebPaymentIntegrationEditor.this.loadImage(chooser.getSelectedFile().getAbsolutePath())) {
                this.putValue("Name", chooser.getSelectedFile().getName());
            }
        }
    }
}

