/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.webpayment;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditablePropertyColumnFormat;
import officemate.components.tableformat.PropertyAccessorListColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.configuration.webpayment.WebPaymentIntegrationEditor;
import officemate.screens.setup.configuration.webservice.WebserviceConfigSetupEditor;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.integration.webpayment.WebPaymentType;
import ordermate.integration.jaxb.paypal.PayPalError;
import ordermate.integration.paypal.PayPalComms;
import ordermate.integration.paypal.PayPalOAuth;
import ordermate.integration.paypal.remote.PayPalServiceRemoteClient;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WebPaymentState
extends AbstractEditableTableState<WebPaymentIntegration> {
    WebPaymentIntegrationEditor editor;

    public WebPaymentState() {
        this.addSelectionDependentAction(new AuthoriseAction());
        this.addSelectionDependentAction(new ToggleOpenCloseAction());
        this.addSelectionDependentAction(new CleanAllPayPalLocations());
    }

    @Override
    protected ObjectEditor<WebPaymentIntegration> createObjectEditor() {
        return this.getEditor();
    }

    @Override
    protected boolean doEdit(WebPaymentIntegration toEdit) {
        PayPalServiceRemoteClient.getInstance().updateIntegration();
        return super.doEdit((WebPaymentIntegration)PersistenceManager.reacquire((PersistentObjectI)toEdit));
    }

    private WebPaymentIntegrationEditor getEditor() {
        if (this.editor == null) {
            this.editor = new WebPaymentIntegrationEditor();
        }
        return this.editor;
    }

    @Override
    public String getTypeName() {
        return "Web Payment Integration";
    }

    @Override
    protected TableStateCentralArea<WebPaymentIntegration> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(WebPaymentIntegration.Properties.LABEL), new PropertyColumnFormat(WebPaymentIntegration.Properties.MERCHANT_EMAIL), new PropertyAccessorListColumnFormat("Availability", new PropertiedObject.Property[]{WebPaymentIntegration.Properties.LOCATIONS, WebPaymentLocation.Properties.AVAILABLE, WebPaymentLocation.Properties.LABEL}, null){

            public Object resolveColumnValue(Object baseObject) {
                List weblocs;
                if (baseObject instanceof WebPaymentIntegration && (weblocs = ((WebPaymentIntegration)baseObject).getLocations()) != null && !weblocs.isEmpty()) {
                    boolean isOpen = ((WebPaymentLocation)weblocs.get(0)).isAvailable();
                    return isOpen ? "Open" : "Closed";
                }
                return "";
            }
        }, new EditablePropertyColumnFormat(WebPaymentIntegration.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE})))), new PopupEditablePropertyColumnFormat(WebPaymentIntegration.Properties.WEBSERVICE_CONFIG, new WebserviceConfigSetupEditor(), this)});
        PersistentObjectTable<WebPaymentIntegration> table = new PersistentObjectTable<WebPaymentIntegration>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<WebPaymentIntegration> getDisplayingType() {
        return WebPaymentIntegration.class;
    }

    @Override
    public WebPaymentIntegration createNewObject() {
        WebPaymentIntegration integration = new WebPaymentIntegration(WebPaymentType.PayPal);
        return integration;
    }

    @Override
    public void gotObjectDeleted(WebPaymentIntegration deletedObject) {
        boolean allDeleted = true;
        for (WebPaymentLocation location : deletedObject.getLocations()) {
            allDeleted &= PayPalServiceRemoteClient.getInstance().tryDeleteLocation(location);
        }
        if (allDeleted) {
            super.gotObjectDeleted(deletedObject);
        } else {
            OrderMate.LOG.warn("Web Payment Integration was not deleted - one or more Locations could not be deleted!");
        }
    }

    @Override
    public void gotObjectEdited(WebPaymentIntegration editedObject) {
        super.gotObjectEdited(editedObject);
        if (new PayPalOAuth(editedObject).hasValidToken()) {
            this.checkLocations(editedObject);
        }
    }

    private void checkLocations(WebPaymentIntegration editedObject) {
        ArrayList<WebPaymentLocation> updatedLocations = new ArrayList<WebPaymentLocation>();
        for (WebPaymentLocation location : editedObject.getLocations()) {
            PayPalError result = PayPalServiceRemoteClient.getInstance().trySyncLocation(location);
            if (result == null) {
                Dialogs.showErrorDialog("Communications Error", "Our sent request did not get a response");
                continue;
            }
            if (!"Success".equals(result.getMessage())) {
                Dialogs.showErrorDialog("Web Service Error", result.getMessage());
                OrderMate.LOG.error("Web Service Error, " + result.getDeveloperMessage());
                updatedLocations.add(location);
                continue;
            }
            Dialogs.showInfoDialog("Location Changed", "The Location has been successfully created/updated");
            OrderMate.LOG.info("Successfully synced WebPaymentLocation with PayPal web service, ID=" + location.getID() + " , ExtID=" + location.getExtId());
            updatedLocations.add((WebPaymentLocation)PersistenceManager.reacquire((PersistentObjectI)location));
        }
        editedObject.setLocations(updatedLocations);
        for (WebPaymentLocation location : editedObject.getLocations()) {
            byte[] image = this.getEditor().getCachedLogo(location);
            if (image == null || image.length == 0) continue;
            WebPaymentLocation localLocation = (WebPaymentLocation)PersistenceManager.reacquire((PersistentObjectI)location);
            PayPalServiceRemoteClient.getInstance().syncLogo(localLocation, image);
        }
    }

    class CleanAllPayPalLocations
    extends AbstractAction {
        public CleanAllPayPalLocations() {
            super("Clear", IconLoader.get((String)"/officemate/images/resync.png", (double)1.0, (Color)Color.ORANGE, (float)0.3f));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Dialogs.showChoiceDialog("Are You Sure?", "This will delete all Location Information")) {
                Dialogs.showProgressDialog(new AbstractTask(){

                    protected int getTotalSubTasks() {
                        return 3;
                    }

                    protected void performTask() throws Exception {
                        if (PayPalServiceRemoteClient.getInstance().tryDeleteAllLocations()) {
                            this.emitProgress();
                            for (WebPaymentLocation location : PersistenceManager.getObjectList(WebPaymentLocation.class, (String)new ObjectQuery().select(WebPaymentLocation.class).toString())) {
                                location.deleteChild();
                            }
                            this.emitProgress();
                            WebPaymentState.this.refresh();
                            this.emitProgress();
                            Dialogs.showInfoDialog("Locations cleared", "Locations have been cleared.");
                        } else {
                            Dialogs.showWarningDialog("Error Deleting", "Some locations could not be deleted");
                        }
                    }

                    public String getName() {
                        return "CleanAllPayPalLocations";
                    }
                });
            }
        }
    }

    class ToggleOpenCloseAction
    extends AbstractAction {
        public ToggleOpenCloseAction() {
            super("Open/Close Location", IconLoader.get((String)"/ordermate/images/connectionOn.png", (double)1.45f, null, (float)1.0f));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selected = WebPaymentState.this.getCentralArea().getAllSelectedObjects();
            for (WebPaymentIntegration integration : selected) {
                ArrayList<WebPaymentLocation> updatedLocations = new ArrayList<WebPaymentLocation>();
                for (WebPaymentLocation location : integration.getLocations()) {
                    PayPalError result = PayPalServiceRemoteClient.getInstance().changeLocationAvailability(location, !location.isAvailable());
                    if (result == null) {
                        Dialogs.showErrorDialog("Communications Error", "Our sent request did not get a response");
                        continue;
                    }
                    if (!"Success".equals(result.getMessage())) {
                        Dialogs.showErrorDialog("Web Service Error", result.getMessage());
                        OrderMate.LOG.error("Web Service Error, " + result.getDeveloperMessage());
                        updatedLocations.add(location);
                        continue;
                    }
                    Dialogs.showInfoDialog("Location Changed", "The Location has been successfully changed");
                    OrderMate.LOG.info("Successfully synced WebPaymentLocation with PayPal web service, ID=" + location.getID() + " , ExtID=" + location.getExtId());
                    updatedLocations.add((WebPaymentLocation)PersistenceManager.reacquire((PersistentObjectI)location));
                }
                integration.setLocations(updatedLocations);
                integration.save();
            }
        }
    }

    class AuthoriseAction
    extends AbstractAction {
        AuthoriseAction() {
            super("Authorise", IconLoader.get((String)"/officemate/images/sendSelected.png", (double)1.0, (Color)Color.ORANGE, (float)0.3f));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebPaymentIntegration integration = (WebPaymentIntegration)WebPaymentState.this.getCentralArea().getSelectedObject();
            if (integration != null && WebPaymentType.PayPal.equals((Object)integration.getType())) {
                PayPalComms comms = new PayPalComms(integration);
                comms.doRequestToTakePayments();
            }
        }
    }
}

