/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.webservice;

import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ordermate.database.integration.accounting.settings.XeroConfiguration;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class TrackingCategoryEditor
extends JPanel
implements ActionListener,
DocumentListener {
    private JCheckBox chk_TrackingCategory;
    private JLabel lbl_TrackingCategoryName;
    private JLabel lbl_TrackingCategoryOption;
    private JTextField txt_TrackingCategoryName;
    private JTextField txt_TrackingCategoryOption;
    private JPanel contentPane;
    private JPanel componentsPanel = new JPanel();
    private HashMap<String, String> tempValues = new HashMap();
    public final Signal changeSignal = Signals.createSignal();

    public TrackingCategoryEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.componentsPanel.setLayout(new SpringLayout());
        this.chk_TrackingCategory = new JCheckBox("");
        this.chk_TrackingCategory.addActionListener(this);
        this.lbl_TrackingCategoryName = this.createLabel("Xero Category Name");
        this.lbl_TrackingCategoryOption = this.createLabel("Xero Category Option");
        this.txt_TrackingCategoryName = this.createTextField();
        this.txt_TrackingCategoryOption = this.createTextField();
        this.componentsPanel.add(new JLabel("Use Tracking Category"));
        this.componentsPanel.add(this.chk_TrackingCategory);
        this.addLabel(this.lbl_TrackingCategoryName);
        this.addTextField(this.txt_TrackingCategoryName, this.lbl_TrackingCategoryName);
        this.addLabel(this.lbl_TrackingCategoryOption);
        this.addTextField(this.txt_TrackingCategoryOption, this.lbl_TrackingCategoryOption);
        this.add(this.contentPane);
        this.contentPane.add((Component)this.componentsPanel, "Center");
        TrackingCategoryEditor.makeCompactGrid(this.componentsPanel, 3, 2, 5, 5, 5, 5);
        this.setValues();
    }

    private void setValues() {
        XeroConfiguration configuration = XeroConfiguration.getInstance();
        String tn = configuration.getTrackingCategoryName();
        String to = configuration.getTrackingCategoryOption();
        if (StringUtils.isEmpty((String)tn) && StringUtils.isEmpty((String)to)) {
            this.chk_TrackingCategory.setSelected(false);
            this.txt_TrackingCategoryName.setText("");
            this.txt_TrackingCategoryOption.setText("");
        } else {
            this.chk_TrackingCategory.setSelected(true);
            this.txt_TrackingCategoryName.setText(tn);
            this.txt_TrackingCategoryOption.setText(to);
        }
    }

    private void addTextField(JTextField textField, JLabel label) {
        label.setLabelFor(textField);
        this.componentsPanel.add(textField);
    }

    private void addLabel(JLabel label) {
        this.componentsPanel.add(label);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField(25);
        textField.addActionListener(this);
        textField.getDocument().addDocumentListener(this);
        return textField;
    }

    private JLabel createLabel(String caption) {
        return new JLabel(caption, 11);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chk_TrackingCategory) {
            this.changeGuiValues();
        }
    }

    @Override
    public void setEnabled(boolean en) {
        this.chk_TrackingCategory.setEnabled(en);
        this.txt_TrackingCategoryName.setEnabled(en);
        this.txt_TrackingCategoryOption.setEnabled(en);
    }

    private void changeGuiValues() {
        if (!this.chk_TrackingCategory.isSelected()) {
            this.tempValues.put("tn", this.txt_TrackingCategoryName.getText());
            this.tempValues.put("to", this.txt_TrackingCategoryOption.getText());
            this.txt_TrackingCategoryName.setText("");
            this.txt_TrackingCategoryOption.setText("");
        } else if (this.tempValues.size() > 0) {
            this.txt_TrackingCategoryName.setText(this.tempValues.get("tn"));
            this.txt_TrackingCategoryOption.setText(this.tempValues.get("to"));
        }
        this.changeSignal.emit();
    }

    public void save() {
        XeroConfiguration configuration = XeroConfiguration.getInstance();
        if (this.chk_TrackingCategory.isSelected()) {
            configuration.setTrackingCategoryName(this.txt_TrackingCategoryName.getText());
            configuration.setTrackingCategoryOption(this.txt_TrackingCategoryOption.getText());
        } else {
            configuration.setTrackingCategoryName("");
            configuration.setTrackingCategoryOption("");
        }
        configuration.save();
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, TrackingCategoryEditor.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = TrackingCategoryEditor.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, TrackingCategoryEditor.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = TrackingCategoryEditor.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changeSignal.emit();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changeSignal.emit();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changeSignal.emit();
    }
}

