/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.webservice;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.converter.OrganisationConverter;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.integration.oauth.OAuth2Client;
import ordermate.internationalization.Internationalization;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Converter;

public class WebserviceConfigSetupEditor
extends AbstractObjectEditor
implements ActionListener {
    private static final String XERO_CONNECT = "xero-connect.png";
    private static final String XERO_DISCONNECT = "xero-disconnect.png";
    private OAuth2Client oauth2Client = null;
    private JPanel holder;
    private JPanel basicPanel;
    private JPanel oauthPanel;
    private JPanel oauth2Panel;
    protected JComboBox typeCombo;
    protected JComponent[] oAuthComps;
    protected JComponent[] allComps;
    protected JButton authButton;
    protected JButton disconnectButton;
    protected JButton validateButton;
    protected JButton tenantsButton;
    protected JTextField organisationField;
    protected JTextField urlTextField;
    protected JTextField usernameTextField;
    protected JTextField passwordTextField;
    protected JTextField privateKeyTextField;
    protected JTextField consumerKeyTextField;
    protected JTextField secretKeyTextField;
    protected JTextField endPointKeyTextField;
    protected JLabel instructionLabel;
    private final String NOT_SETUP = Internationalization.getLiteralFor((String)"NOT_SETUP");

    public WebserviceConfigSetupEditor() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.buildFields(builder);
        this.add(builder.getPanel());
    }

    public WebserviceConfigSetupEditor(FieldPanelBuilder builder, BindingGuiSupportPanel.ObjectEditedListener objectEditedListener, BindingHelper helper, PropertiedObject.Property<WebserviceIntegrationConfig> prop) {
        super(null, objectEditedListener);
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ);
        this.setLayout(new FlowLayout(0));
        this.buildFields(builder);
        helper.addLinkedObjectEditors((ObjectEditor)this);
        helper.createBinding(prop, (Object)this, "object");
    }

    protected void buildFields(FieldPanelBuilder builder) {
        this.typeCombo = this.setupComboBox(WebserviceIntegrationConfig.Properties.WEBSERVICE_TYPE, new DefaultComboBoxModel<Object>(WebserviceIntegrationType.getRegister().values().toArray()), null);
        this.typeCombo.addActionListener(this);
        builder.addRow("Webservice Type:", (Component)this.typeCombo);
        this.urlTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.URL, 30);
        builder.addRow("URL:", (Component)this.urlTextField);
        this.holder = new JPanel(new BorderLayout());
        FieldPanelBuilder oauth2Builder = new FieldPanelBuilder();
        this.organisationField = new JTextField(30);
        Binding organisationBinding = this.getBindings().createBinding(WebserviceIntegrationConfig.Properties.ORGANISATION, (Object)this.organisationField, "text");
        organisationBinding.setConverter((Converter)new OrganisationConverter(organisationBinding));
        builder.addRow(Internationalization.getLiteralFor((String)"ORGANISATION"), (Component)this.organisationField);
        this.authButton = new JButton(Internationalization.getLiteralFor((String)"CONNECT_TO_XERO"));
        this.authButton.addActionListener(this);
        oauth2Builder.addRow("", (Component)this.authButton);
        this.disconnectButton = new JButton(Internationalization.getLiteralFor((String)"DISCONNECT_FROM_XERO"));
        this.disconnectButton.addActionListener(this);
        oauth2Builder.addRow("", (Component)this.disconnectButton);
        this.validateButton = new JButton("Validate");
        this.validateButton.addActionListener(this);
        oauth2Builder.addRow("", (Component)this.validateButton);
        this.tenantsButton = new JButton("Tenants");
        this.tenantsButton.addActionListener(this);
        this.oauth2Panel = oauth2Builder.getPanel();
        this.usernameTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.USERNAME, 20);
        this.passwordTextField = this.setupPasswordField(WebserviceIntegrationConfig.Properties.PASSWORD, 20);
        this.privateKeyTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.PRIVATE_KEY, 50);
        this.consumerKeyTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.CONSUMER_KEY, 30);
        this.secretKeyTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.SECRET_KEY, 30);
        this.endPointKeyTextField = this.setupTextField(WebserviceIntegrationConfig.Properties.ENDPOINT_URL, 30);
        this.instructionLabel = new JLabel();
        FieldPanelBuilder basicBuilder = new FieldPanelBuilder();
        basicBuilder.addRow("Username:", (Component)this.usernameTextField);
        basicBuilder.addRow("Password:", (Component)this.passwordTextField);
        this.basicPanel = basicBuilder.getPanel();
        FieldPanelBuilder oauthBuilder = new FieldPanelBuilder();
        oauthBuilder.addRow("Private Key:", (Component)this.privateKeyTextField);
        oauthBuilder.addRow("Consumer Key:", (Component)this.consumerKeyTextField);
        oauthBuilder.addRow("Secret Key:", (Component)this.secretKeyTextField);
        oauthBuilder.addRow("Endpoint URL:", (Component)this.endPointKeyTextField);
        oauthBuilder.addRow("", (Component)this.instructionLabel);
        this.oauthPanel = oauthBuilder.getPanel();
        this.oAuthComps = new JComponent[]{this.privateKeyTextField, this.consumerKeyTextField, this.secretKeyTextField, this.endPointKeyTextField};
        this.allComps = new JComponent[]{this.typeCombo, this.urlTextField, this.usernameTextField, this.passwordTextField, this.privateKeyTextField, this.consumerKeyTextField, this.secretKeyTextField, this.endPointKeyTextField};
        builder.addRow("Security", (Component)this.holder);
    }

    private boolean isAuthorized() {
        return !StringUtils.isEmpty((String)((WebserviceIntegrationConfig)this.getObject()).getAccessToken()) && !StringUtils.isEmpty((String)((WebserviceIntegrationConfig)this.getObject()).getTenantId());
    }

    private void flipType() {
        WebserviceIntegrationConfig config = (WebserviceIntegrationConfig)this.getObject();
        WebserviceIntegrationType type = (WebserviceIntegrationType)this.typeCombo.getSelectedItem();
        if (WebserviceIntegrationType.OAuth.equals((Object)type)) {
            this.holder.removeAll();
            this.holder.add(this.oauthPanel);
        } else if (WebserviceIntegrationType.Basic.equals((Object)type)) {
            this.holder.removeAll();
            this.holder.add(this.basicPanel);
        } else if (WebserviceIntegrationType.OAuth2.equals((Object)type)) {
            this.holder.removeAll();
            this.holder.add(this.oauth2Panel);
            this.statusChanged(config, this.isAuthorized());
        }
        this.holder.validate();
        this.holder.getParent().validate();
        this.holder.getParent().getParent().validate();
        this.holder.getParent().getParent().repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.typeCombo) {
            this.flipType();
        } else if (e.getSource() == this.authButton) {
            if (this.oauth2Client != null) {
                this.oauth2Client.initiateAuthorization();
                this.flipType();
            }
        } else if (e.getSource() == this.disconnectButton) {
            if (this.oauth2Client != null) {
                this.oauth2Client.initiateDisconnect();
                this.flipType();
            }
        } else if (e.getSource() == this.validateButton) {
            if (this.oauth2Client != null) {
                if (this.oauth2Client.validate()) {
                    Dialogs.showInfoDialog("Validation succeeded", "The Connection is valid");
                } else if (!StringUtils.isEmpty((String)((WebserviceIntegrationConfig)this.getObject()).getAccessToken())) {
                    Dialogs.showWarningDialog("Validation Failed", "Could not validate the connection. Please check logs, network or try to reconnect.");
                }
                this.flipType();
            }
        } else if (e.getSource() == this.tenantsButton && this.oauth2Client != null) {
            this.oauth2Client.initiateTenants();
        }
    }

    @Override
    public void setEnabled(boolean value) {
        this.setAllCompsEnabled(value);
    }

    public void setAllCompsEnabled(boolean enabled) {
        for (JComponent comp : this.allComps) {
            ((Component)comp).setEnabled(enabled);
            if (!enabled) continue;
            this.flipType();
        }
    }

    @Override
    public void saveObject() {
        if (this.getObject() != null) {
            super.saveObject();
        }
    }

    public void statusChanged(WebserviceIntegrationConfig config, Boolean status) {
        if (status.booleanValue()) {
            if (StringUtils.isEmpty((String)config.getOrganisation()) && !StringUtils.isEmpty((String)config.getTenantId())) {
                this.organisationField.setText(Internationalization.getLiteralFor((String)"AUTHORISED"));
            } else if (!StringUtils.isEmpty((String)config.getOrganisation()) && !StringUtils.isEmpty((String)config.getTenantId())) {
                this.organisationField.setText(config.getOrganisation() + " (" + config.getTenantId() + ")");
            }
            this.organisationField.setForeground(Color.GREEN.darker());
        } else {
            this.organisationField.setText(this.NOT_SETUP);
            this.organisationField.setForeground(Color.ORANGE);
        }
        this.refresh();
    }

    public void setOAuth2Client(OAuth2Client client) {
        this.oauth2Client = client;
        client.statusSignal.connect((Object)this, "statusChanged");
        this.disconnectButton.setVisible(client.canDisconnect());
    }

    public void setType(FinanceExportStyle type) {
        if (FinanceExportStyle.Xero.equals((Object)type)) {
            this.authButton.setText(null);
            this.authButton.setIcon(IconLoader.get((String)"/officemate/images/xero-connect.png"));
            this.disconnectButton.setText(null);
            this.disconnectButton.setIcon(IconLoader.get((String)"/officemate/images/xero-disconnect.png"));
        } else {
            this.authButton.setText(Internationalization.getLiteralFor((String)"CONNECT_TO_XERO"));
            this.authButton.setIcon(null);
            this.disconnectButton.setText(Internationalization.getLiteralFor((String)"DISCONNECT_FROM_XERO"));
            this.disconnectButton.setIcon(null);
        }
    }
}

