/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.AbstractObjectEditor;
import officemate.components.EditorDialog;
import officemate.screens.setup.configuration.workflow.action.WorkflowActionTable;
import officemate.screens.setup.configuration.workflow.condition.WorkflowConditionTable;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.gui.FieldPanelBuilder;

class WorkflowActionSetEditor
extends AbstractObjectEditor<WorkflowActionSet>
implements ActionListener {
    private JEditorPane descriptionArea;
    private JButton setupConditionsButton;
    private JButton setupActionsButton;
    private JTextComponent labelComp;
    private JCheckBox optionalCheck;
    private BasicOfficeMateState state;

    WorkflowActionSetEditor(BasicOfficeMateState yourState) {
        this.setName("WorkflowActionSetEditor");
        this.state = yourState;
        this.objectEdited.connect((Object)this, "gotObjectEdited");
        this.setupComponents();
    }

    private void setupComponents() {
        this.labelComp = this.setupTextField(WorkflowActionSet.Properties.LABEL, 20);
        this.labelComp.setName("labelComp");
        this.optionalCheck = this.setupCheckBox(WorkflowActionSet.Properties.OPTIONAL);
        this.optionalCheck.setName("optionalCheck");
        this.descriptionArea = new JEditorPane();
        this.descriptionArea.setName("descriptionArea");
        this.descriptionArea.setBackground(null);
        this.descriptionArea.setEditorKit(new HTMLEditorKit());
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setPreferredSize(new Dimension(300, 180));
        this.setupConditionsButton = new JButton("Edit Conditions");
        this.setupConditionsButton.setName("setupConditionsButton");
        this.setupConditionsButton.addActionListener(this);
        this.setupActionsButton = new JButton("Edit Actions");
        this.setupActionsButton.setName("setupActionsButton");
        this.setupActionsButton.addActionListener(this);
        this.setMainCompsEnabled(false);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Label", (Component)this.labelComp, "The name of this Action Set, eg: 'Print to Staging'");
        builder.addRow("Optional", (Component)this.optionalCheck, "If unchecked, the workflow will not terminate until this action set is performed.");
        builder.addRow("If...", (Component)this.setupConditionsButton, "Starts a dialog to help the user set up conditions");
        builder.addRow("Then...", (Component)this.setupActionsButton, "Starts a dialog to help the user set up actions");
        builder.addRow("", (Component)new JScrollPane(this.descriptionArea), "A verbal description of this Action Set");
        this.add(builder.getPanel());
    }

    private void setMainCompsEnabled(boolean enabled) {
        this.setupActionsButton.setEnabled(enabled);
        this.setupConditionsButton.setEnabled(enabled);
        this.labelComp.setEnabled(enabled);
        this.optionalCheck.setEnabled(enabled);
    }

    @Override
    public void setObject(WorkflowActionSet toEdit) {
        super.setObject(toEdit);
        boolean isNull = toEdit == null;
        this.setMainCompsEnabled(!isNull);
        this.updateDescription();
    }

    private void setupConditions() {
        WorkflowConditionTable editor = new WorkflowConditionTable();
        editor.setObject(this.getObject());
        EditorDialog dialog = new EditorDialog(editor);
        if (dialog.doModal() && dialog.getOkClicked()) {
            editor.saveObject();
            this.gotObjectEdited();
        }
    }

    private void setupActions() {
        WorkflowActionTable editor = new WorkflowActionTable();
        editor.setObject(this.getObject());
        EditorDialog dialog = new EditorDialog(editor);
        if (dialog.doModal() && dialog.getOkClicked()) {
            editor.saveObject();
            this.gotObjectEdited();
        }
    }

    public void gotObjectEdited() {
        this.saveObject();
        ((WorkflowActionSet)this.getObject()).saveChild();
        this.updateDescription();
    }

    private void updateDescription() {
        WorkflowActionSet object = (WorkflowActionSet)this.getObject();
        if (object != null) {
            object = (WorkflowActionSet)PersistenceManager.reacquire((PersistentObjectI)object);
        }
        this.descriptionArea.setText(object == null ? "" : object.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.setupConditionsButton) {
            this.setupConditions();
        } else if (source == this.setupActionsButton) {
            this.setupActions();
        }
    }
}

