/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow;

import ca.odell.glazedlists.BasicEventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.screens.setup.configuration.workflow.WorkflowActionSetEditor;
import officemate.screens.setup.configuration.workflow.WorkflowActionSetTableModel;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;

class WorkflowActionSetTable
extends TableListObjectEditor<Workflow, WorkflowActionSet>
implements ListSelectionListener {
    private WorkflowActionSetEditor editor;

    WorkflowActionSetTable(BasicOfficeMateState state) {
        super(new PersistentObjectTable(new BasicEventList(), new WorkflowActionSetTableModel()), true);
        this.setName("WorkflowActionSetTable");
        this.getPersistentObjectTable().setPreferredSize(new Dimension(250, 200));
        JPanel holder = new JPanel(new BorderLayout());
        this.editor = new WorkflowActionSetEditor(state);
        holder.add(this.editor);
        this.add((Component)holder, "East");
        holder.setPreferredSize(new Dimension(400, 300));
        for (Component comp : this.getToolBar().getComponents()) {
            if (!(comp instanceof JButton)) continue;
            ((JButton)comp).setToolTipText(((JButton)comp).getToolTipText() + " Action Set");
            comp.setName(((JButton)comp).getToolTipText());
        }
        this.getPersistentObjectTable().addSelectionChangeListener(this);
    }

    @Override
    public void addObjectToParent(WorkflowActionSet toAdd) {
        Workflow workflow = (Workflow)this.getObject();
        if (workflow != null) {
            workflow.addActionSet(toAdd);
            workflow.save();
        }
    }

    @Override
    public void removeObjectFromParent(WorkflowActionSet toRemove) {
        Workflow workflow = (Workflow)this.getObject();
        if (workflow != null) {
            workflow.removeActionSet(toRemove);
            toRemove.deleteChild();
            workflow.save();
        }
    }

    @Override
    public void removeSelectedElement() {
        for (WorkflowActionSet actionSet : this.getPersistentObjectTable().getAllSelectedObjects()) {
            this.removeObjectFromParent(actionSet);
        }
        super.removeSelectedElement();
    }

    @Override
    public Collection<WorkflowActionSet> getParentList() {
        Workflow workflow = (Workflow)this.getObject();
        return workflow == null ? new ArrayList() : workflow.getActionSets();
    }

    @Override
    public WorkflowActionSet createNewObject() {
        Workflow workflow = (Workflow)this.getObject();
        WorkflowActionSet set = new WorkflowActionSet(workflow);
        workflow.addActionSet(set);
        workflow.save();
        return set;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.editor.setObject((WorkflowActionSet)this.getPersistentObjectTable().getSelectedObject());
        }
    }
}

