/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.PositiveIntValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class DeviceEditor<T extends Device>
extends AbstractObjectEditor<T> {
    protected FieldPanelBuilder builder;
    protected FieldPanelBuilder rightBuilder;
    private List<Terminal> hosts;
    private TerminalSelector terminalField;
    private Binding portBinding;
    private boolean includeTerminalAccess;
    protected JComboBox speedCombo;
    protected JTextField portField;
    protected JComboBox typeField;
    protected JComboBox flowField;
    protected JTextField nameField;
    private List<JComponent> mainCompsList = new ArrayList<JComponent>();

    public DeviceEditor(boolean includeTerminalAccess) {
        this.setLayout(new BorderLayout());
        this.builder = new FieldPanelBuilder();
        this.rightBuilder = new FieldPanelBuilder();
        this.includeTerminalAccess = includeTerminalAccess;
        this.buildComponentSections();
        this.setupComponents();
    }

    private void buildComponentSections() {
        this.addHeaderComponents();
        this.addMainComponents();
        this.addFooterComponents();
    }

    protected void setupComponents() {
        Box gui = new Box(0);
        gui.add(this.builder.getPanel());
        if (this.includeTerminalAccess) {
            this.addTerminalSelector();
            gui.add(Box.createHorizontalStrut(20));
            gui.add(this.rightBuilder.getPanel());
        }
        this.add((Component)gui, "Center");
    }

    protected void addFooterComponents() {
    }

    protected void addHeaderComponents() {
        this.nameField = new JTextField(20);
        this.nameField.setName("nameField");
        Binding nameBinding = this.getBindings().createBinding(Device.Properties.LABEL, (Object)this.nameField, "text");
        nameBinding.setValidator((Validator)new NotEmptyValidator());
        this.builder.addRow("Name", (Component)this.nameField);
    }

    protected void addMainComponents() {
        JComboBox hostField = new JComboBox();
        hostField.setName("hostField");
        ComponentUtils.setupComboBox(hostField);
        this.hosts = new ArrayList<Terminal>();
        this.getBindings().createJComboBoxBinding(Device.Properties.HOST, hostField, this.hosts);
        this.builder.addRow("Host", hostField);
        this.portField = new JTextField(20);
        this.portField.setName("portField");
        this.portBinding = this.getBindings().createBinding(Device.Properties.PORT, (Object)this.portField, "text");
        this.builder.addRow("Port", (Component)this.portField);
        this.typeField = new JComboBox();
        this.typeField.setName("typeField");
        ComponentUtils.setupComboBox((JComboBox)this.typeField);
        this.getBindings().createJComboBoxBinding(Device.Properties.PORT_TYPE, this.typeField, this.getPortTypes());
        this.builder.addRow("Port Type", (Component)this.typeField);
        this.speedCombo = new JComboBox<Integer>(Device.getDefaultSpeeds());
        this.speedCombo.setName("speedField");
        this.speedCombo.setEditable(true);
        this.speedCombo.setSelectedIndex(0);
        ComponentUtils.setupComboBox((JComboBox)this.speedCombo);
        Binding binding = this.getBindings().createBinding(Device.Properties.PORT_SPEED, (Object)this.speedCombo, "selectedItem");
        binding.setValidator((Validator)new PositiveIntValidator(false, false));
        this.builder.addRow("Port Speed", (Component)this.speedCombo);
        this.flowField = new JComboBox();
        this.flowField.setName("flowField");
        ComponentUtils.setupComboBox((JComboBox)this.flowField);
        this.getBindings().createJComboBoxBinding(Device.Properties.FLOW_CONTROL, this.flowField, Device.getFlowControlTypes());
        this.builder.addRow("Flow Control", (Component)this.flowField);
        this.mainCompsList.add(hostField);
        this.mainCompsList.add(this.portField);
        this.mainCompsList.add(this.typeField);
        this.mainCompsList.add(this.speedCombo);
        this.mainCompsList.add(this.flowField);
    }

    protected Binding getPortBinding() {
        return this.portBinding;
    }

    protected List getPortTypes() {
        return Device.getPortTypes();
    }

    protected void addTerminalSelector() {
        this.terminalField = new TerminalSelector(true);
        JScrollPane scrollPane = new JScrollPane(this.terminalField);
        scrollPane.setPreferredSize(new Dimension(220, 280));
        scrollPane.setBorder(null);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.rightBuilder.addSeparator("Terminal Access");
        this.rightBuilder.addRow(" ", (Component)scrollPane);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void saveObject() {
        Device device = (Device)super.getObject();
        if (this.terminalField != null) {
            device.setTerminals(this.terminalField.getSelectedTerminals());
        }
        super.saveObject();
    }

    @Override
    public void setObject(T toEdit) {
        this.hosts.clear();
        this.hosts.add(Terminal.getServerMateTerminal());
        this.hosts.addAll(Terminal.getAllWaiterMateTerminals());
        if (this.terminalField != null) {
            this.terminalField.setTerminals(toEdit.getTerminals());
        }
        super.setObject(toEdit);
    }

    protected void setMainComponentsEnabled(boolean enable) {
        this.setCompsEnabled(this.mainCompsList, enable);
    }

    protected void setCompsEnabled(List<JComponent> compList, boolean enable) {
        for (JComponent comp : compList) {
            comp.setEnabled(enable);
        }
    }

    protected static class TerminalSelector
    extends Box {
        private Map<Terminal, JCheckBox> terminalMap = new HashMap<Terminal, JCheckBox>();
        private boolean smTerminal;

        public TerminalSelector(boolean includeSMterm) {
            super(1);
            this.smTerminal = includeSMterm;
        }

        public void setTerminals(List selectedTerminals) {
            this.removeAll();
            this.terminalMap = new HashMap<Terminal, JCheckBox>();
            ArrayList<Terminal> allTerminals = new ArrayList<Terminal>();
            if (this.smTerminal) {
                allTerminals.add(Terminal.getServerMateTerminal());
            }
            allTerminals.addAll(Terminal.getAllWaiterMateTerminals());
            for (Terminal t : allTerminals) {
                JCheckBox checkBox = new JCheckBox(t.getName(), selectedTerminals.contains(t));
                this.add(checkBox);
                this.terminalMap.put(t, checkBox);
            }
        }

        public List<Terminal> getSelectedTerminals() {
            ArrayList<Terminal> selected = new ArrayList<Terminal>();
            for (Terminal term : this.terminalMap.keySet()) {
                JCheckBox checkBox = this.terminalMap.get(term);
                if (!checkBox.isSelected()) continue;
                selected.add(term);
            }
            return selected;
        }
    }
}

