/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.GlazedLists;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DeviceTableFormat
extends ColumnTableFormat {
    public DeviceTableFormat() {
        this(false);
    }

    public DeviceTableFormat(boolean editable) {
        super(new ColumnFormat[]{DeviceTableFormat.createFormat(editable, Device.Properties.LABEL), DeviceTableFormat.createFormat(editable, Device.Properties.HOST), DeviceTableFormat.createFormat(editable, Device.Properties.PORT), DeviceTableFormat.createFormat(editable, Device.Properties.PORT_TYPE), DeviceTableFormat.createFormat(editable, Device.Properties.PORT_SPEED), DeviceTableFormat.createFormat(editable, Device.Properties.FLOW_CONTROL)});
        if (editable) {
            for (ColumnFormat columnFormat : this.getColumns()) {
                if (!(columnFormat instanceof EditablePropertyColumnFormat)) continue;
                EditablePropertyColumnFormat format = (EditablePropertyColumnFormat)columnFormat;
                if (format.getProperty().equals((Object)Device.Properties.HOST)) {
                    format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(Terminal.getAllTerminals())));
                    continue;
                }
                if (format.getProperty().equals((Object)Device.Properties.PORT_TYPE)) {
                    format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(Device.getPortTypes())));
                    continue;
                }
                if (format.getProperty().equals((Object)Device.Properties.PORT_SPEED)) {
                    format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(Arrays.asList(Device.getDefaultSpeeds()))));
                    continue;
                }
                if (!format.getProperty().equals((Object)Device.Properties.FLOW_CONTROL)) continue;
                format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(Device.getFlowControlTypes())));
            }
        }
    }

    private static PropertyColumnFormat createFormat(boolean editable, PropertiedObject.Property<?> prop) {
        return editable ? new EditablePropertyColumnFormat(prop) : new PropertyColumnFormat(prop);
    }

    private AutoCompleteComboCellEditor createAutoCompleteEditor(Collection<?> list) {
        return new AutoCompleteComboCellEditor(GlazedLists.eventList(list), false);
    }
}

