/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.cashdrawer;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import officemate.adminkit.CRUDValidator;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;

public class CashDrawerCRUDValidator
implements CRUDValidator {
    private final CashDrawer cashdrawer;

    public CashDrawerCRUDValidator(CashDrawer drawer) {
        this.cashdrawer = drawer;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canEdit() {
        return this.disallowUnlinkOfServerMateCashDrawer();
    }

    @Override
    public boolean canDelete() {
        return this.disallowDeletionOfOnlyServerMateCashDrawer();
    }

    private final boolean disallowUnlinkOfServerMateCashDrawer() {
        Terminal serverMate = this.getServerMateTerminal();
        return !serverMate.getConnectedCashDrawers().contains(this.cashdrawer) || serverMate.getConnectedCashDrawers().size() != 1 || this.cashdrawer.getHost().equals((Object)serverMate);
    }

    private final boolean disallowDeletionOfOnlyServerMateCashDrawer() {
        Terminal serverMate = this.getServerMateTerminal();
        return !serverMate.getConnectedCashDrawers().contains(this.cashdrawer) || serverMate.getConnectedCashDrawers().size() > 1;
    }

    private final Terminal getServerMateTerminal() {
        Terminal serverMate = Terminal.getServerMateTerminal();
        serverMate = (Terminal)PersistenceManager.reacquire((PersistentObjectI)serverMate);
        return serverMate;
    }
}

