/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.cashdrawer;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.setup.devices.DeviceEditor;
import officemate.screens.setup.devices.cashdrawer.CashDrawerCRUDValidator;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CashdrawerEditor
extends DeviceEditor<CashDrawer> {
    public final Signal<?, ?, ?, ?, ?> gotRefresh = Signals.createSignal();
    JCheckBox userPayable;

    public CashdrawerEditor() {
        super(true);
    }

    @Override
    protected void addFooterComponents() {
        JComboBox kickerField = new JComboBox();
        this.getBindings().createJComboBoxBinding(CashDrawer.Properties.KICKER_TYPE, kickerField, CashDrawer.getKickerTypes());
        this.builder.addRow("Kicker Type", kickerField);
        ComponentUtils.setupComboBox(kickerField);
        JTextField ipPortField = new JTextField(7);
        this.getBindings().createBinding(CashDrawer.Properties.IP_PORT, (Object)ipPortField, "text");
        this.builder.addRow("IP Port", (Component)ipPortField);
        this.userPayable = this.setupCheckBox(CashDrawer.Properties.USER_PAYABLE);
        this.builder.addRow("Allow WaiterMate Payments", (Component)this.userPayable);
        this.userPayable.setToolTipText("A Waitermate Terminal may pay to this cashdrawer only if this is ticked.");
    }

    @Override
    public void setObject(CashDrawer drawer) {
        super.setObject(drawer);
        this.nameField.setEnabled(true);
        this.userPayable.setEnabled(true);
        if ("Officedrawer".equals(drawer.getLabel())) {
            this.nameField.setEnabled(false);
        } else if ("Online Cashdrawer".equals(drawer.getLabel())) {
            this.nameField.setEnabled(false);
            this.userPayable.setEnabled(false);
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        CashDrawer toSave = (CashDrawer)this.getObject();
        if (!new CashDrawerCRUDValidator(toSave).canEdit()) {
            Dialogs.showErrorDialog("Cannot save cash drawer!", "ServerMate requires at least one cash drawer to be linked. Your changes to this cash drawer have not been saved.");
            this.revertObject();
        }
    }

    @Override
    public void revertObject() {
        super.revertObject();
        this.setObject((CashDrawer)PersistenceManager.reacquire((PersistentObjectI)((PersistentObjectI)this.getObject())));
        this.gotRefresh.emit();
    }
}

