/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.customerdisplay;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.QAndACustomerDisplay;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import org.jdesktop.beansbinding.AutoBinding;

class CustomerDisplayGeneralEditor
extends AbstractObjectEditor<AbstractCustomerDisplay> {
    private JLabel nameLabel;
    private JComboBox questionBox;
    private JLabel questionLabel;
    private EventComboBoxModel<FeedbackQuestion> model;
    private EventList<FeedbackQuestion> questions = new BasicEventList();

    CustomerDisplayGeneralEditor(BindingHelper bindings, BindingGuiSupportPanel.ObjectEditedListener listener) {
        super(bindings, listener);
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.nameLabel = new JLabel();
        builder.addRow("Customer Display For", (Component)this.nameLabel);
        builder.addRow("Order Width", (Component)this.setupIntSpinner(AbstractCustomerDisplay.Properties.ORDER_WIDTH, 5, 20, 1024, 500, 4));
        builder.addRow("Message Height", (Component)this.setupIntSpinner(AbstractCustomerDisplay.Properties.MESSAGE_HEIGHT, 5, 20, 800, 60, 4));
        builder.addRow("Banner Height", (Component)this.setupIntSpinner(AbstractCustomerDisplay.Properties.BANNER_HEIGHT, 5, 20, 800, 60, 4));
        builder.addRow("Active?", (Component)this.setupComboBox(AbstractCustomerDisplay.Properties.SYSTEM_STATE, GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE})));
        builder.addRow("Default Device", (Component)this.setupIntSpinner(AbstractCustomerDisplay.Properties.DEFAULT_DEVICE, 1, 0, 10, 1, 3));
        this.questionLabel = new JLabel("Question");
        this.model = new EventComboBoxModel(this.questions);
        this.questionBox = new JComboBox<FeedbackQuestion>((ComboBoxModel<FeedbackQuestion>)this.model);
        builder.addRow(this.questionLabel, (Component)this.questionBox);
        this.add(builder.getPanel());
    }

    @Override
    public void saveObject() {
        if (this.getObject() instanceof QAndACustomerDisplay) {
            ((QAndACustomerDisplay)this.getObject()).setMainQuestion((FeedbackQuestion)this.questionBox.getSelectedItem());
        }
        super.saveObject();
    }

    @Override
    public void setObject(AbstractCustomerDisplay display) {
        if (display != null) {
            this.nameLabel.setText(display.getLabel());
            if (display instanceof QAndACustomerDisplay) {
                this.questions.getReadWriteLock().writeLock().lock();
                this.questions.clear();
                this.questions.addAll((Collection)PersistenceManager.getObjectList(FeedbackQuestion.class, (String)Query.select(FeedbackQuestion.class).active(FeedbackQuestion.class).toString()));
                this.questions.getReadWriteLock().writeLock().unlock();
                this.questionLabel.setVisible(true);
                this.questionBox.setVisible(true);
            } else {
                this.questionLabel.setVisible(false);
                this.questionBox.setVisible(false);
            }
        }
        super.setObject(display);
    }
}

