/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.eftpos;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.xmlintegration.adyen.AdyenMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageHeader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.setup.configuration.adyen.AdyenTerminalSettingsScreen;
import officemate.screens.setup.devices.eftpos.EftposTable;
import officemate.screens.setup.devices.eftpos.EftposTerminalEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposRequest;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.users.User;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;
import ordermate.integration.eftpos.adyen.AdyenUtils;
import ordermate.integration.eftpos.assembly.AssemblyEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposContext;
import ordermate.integration.eftpos.assembly.AssemblyEftposFactory;
import ordermate.integration.eftpos.assembly.AssemblyEftposHelper;
import ordermate.integration.eftpos.assembly.AssemblyEftposSpiHelper;
import ordermate.integration.eftpos.assembly.pairing.AssemblyEftposPairingScreen;
import ordermate.integration.eftpos.linklycloud.LinklyCloudEftposPairingScreen;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.mx51.SpiceIntegrationProcessor;
import ordermate.integration.eftpos.mx51.response.SpicePingResponse;
import ordermate.integration.eftpos.smartpay.pairing.SmartpayEftposPairingScreen;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebContext;
import ordermate.integration.eftpos.tyro.webservice.actions.TyroWebPairing;

public class EftposState
extends AbstractEditableTableState {
    private EftposTable gui;
    private Action pairEftpos = new AbstractAction("Pair Eftpos", IconLoader.get((String)"/officemate/images/resync.png")){

        @Override
        public void setEnabled(boolean newValue) {
            VirtualEftpos eftpos = (VirtualEftpos)EftposState.this.getCentralArea().getSelectedObject();
            super.setEnabled(eftpos != null && eftpos.getEftposType().isPairingRequired());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EftposState.this.performPairing();
        }
    };
    private Action resetRemote;
    private Action pingEftpos;
    private Action terminalSettingsEftpos;

    public EftposState() {
        super("EFTPOS", null, "View, add and configure EFTPOS terminals.");
        this.addSelectionDependentAction(this.pairEftpos);
        this.pingEftpos = new AbstractAction("Ping Eftpos", IconLoader.get((String)"/officemate/images/resync.png")){

            @Override
            public void setEnabled(boolean newValue) {
                VirtualEftpos eftpos = (VirtualEftpos)EftposState.this.getCentralArea().getSelectedObject();
                super.setEnabled(eftpos != null && eftpos.getEftposType().isPingRequired());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EftposState.this.performPing();
            }
        };
        this.addSelectionDependentAction(this.pingEftpos);
        this.resetRemote = new AbstractAction("Reset Remote", IconLoader.get((String)"/officemate/images/restart.png")){

            @Override
            public void setEnabled(boolean newValue) {
                VirtualEftpos eftpos = (VirtualEftpos)EftposState.this.getCentralArea().getSelectedObject();
                super.setEnabled(eftpos != null && eftpos.getEftposType().equals((Object)EftposType.ASSEMBLY));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EftposState.this.resetRemote();
            }
        };
        this.terminalSettingsEftpos = new AbstractAction("Diagnostics", IconLoader.get((String)"/officemate/images/restart.png")){

            @Override
            public void setEnabled(boolean newValue) {
                VirtualEftpos eftpos = (VirtualEftpos)EftposState.this.getCentralArea().getSelectedObject();
                super.setEnabled(eftpos != null && eftpos.getEftposType().isSettingsAdjustable() && AdyenUtils.isTerminalSettingsEditAllowed((User)EftposState.this.getUser()));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                EftposState.this.TerminalSettings();
            }
        };
        this.addSelectionDependentAction(this.resetRemote);
    }

    public ObjectEditor createObjectEditor() {
        return new EftposTerminalEditor();
    }

    @Override
    public String getTypeName() {
        return "EFTPOS Terminal";
    }

    @Override
    public TableStateCentralArea createCentralArea() {
        this.gui = new EftposTable(this.getObjectList());
        this.gui.add((Component)this.getSearchFactory().getSearchPanel(), "North");
        return this.gui;
    }

    @Override
    protected OfficeMateObjectSearch<VirtualEftpos> createSearchPanelFactory() {
        ObjectPropertySearch<VirtualEftpos> search = new ObjectPropertySearch<VirtualEftpos>(this.getDisplayingType());
        search.addFilterSystemState(SystemState.ACTIVE_STATE);
        search.addFilterSystemState(SystemState.INACTIVE_STATE);
        search.setSystemStateFilterActive(true);
        return search;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (!this.actionExists(this.terminalSettingsEftpos) && AdyenUtils.isTerminalSettingsEditAllowed((User)this.getUser())) {
            this.addSelectionDependentAction(this.terminalSettingsEftpos);
        }
    }

    @Override
    public Class getDisplayingType() {
        return VirtualEftpos.class;
    }

    protected Object createNewObject() {
        return new VirtualEftpos();
    }

    private void performPing() {
        VirtualEftpos eftpos = (VirtualEftpos)this.getCentralArea().getSelectedObject();
        if (eftpos == null || !eftpos.getEftposType().isPingRequired()) {
            Dialogs.showWarningDialog("Cannot Ping Terminal", "Pinging can only be performed on Spice/Oolio Terminals.");
            return;
        }
        if (eftpos.getEftposType().equals((Object)EftposType.MX51SPICE)) {
            SpicePingResponse resp = SpiceIntegrationProcessor.performPing((String)eftpos.getIpAddress(), (int)eftpos.getPort());
            if (resp == null) {
                Dialogs.showWarningDialog("Terminal Ping Failed", "Please check terminal is connected to Spice");
            } else {
                Dialogs.showInfoDialog("Ping Successful", "Terminal Status: " + resp.getStatus());
            }
        } else if (eftpos.getEftposType().equals((Object)EftposType.ADYEN)) {
            AdyenMessageHeader header = AdyenUtils.createHeader((String)"3.0", (String)"Service", (String)"Diagnosis", (String)"Request", (String)eftpos.getMerchantId(), (String)AdyenUtils.createAdyenTransactionId(), (String)eftpos.getTerminalId());
            AdyenMessage adyenReq = new AdyenMessage();
            adyenReq.setSaleToPOIRequest(AdyenUtils.createDiagnosisPOIRequest((AdyenMessageHeader)header));
            AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP((boolean)eftpos.isTesting()));
            if (r == null || r.getSaleToPOIResponse() == null || r.getSaleToPOIResponse().getDiagnosisResponse() == null) {
                Dialogs.showWarningDialog("Terminal Ping Failed", "Unable to get response from Oolio, please confirm settings are correct");
            } else {
                Dialogs.showWarningDialog("Terminal Status", r.getSaleToPOIResponse().getDiagnosisResponse().getPoiStatus().getGlobalStatus());
            }
        }
    }

    private final Terminal selectTerminal() {
        ArrayList<Terminal> terminals = new ArrayList<Terminal>(Terminal.getAllWaiterMateTerminals());
        terminals.add(Terminal.getServerMateTerminal());
        if (terminals.isEmpty()) {
            Dialogs.showInfoDialog("No Waitermate Terminals", "There are no Waitermate Terminals to pair");
            return null;
        }
        return (Terminal)Dialogs.showOptionDialog("Which Terminal?", "Please select a Waitermate terminal to pair.", terminals);
    }

    private void performPairing() {
        final VirtualEftpos eftpos = (VirtualEftpos)this.getCentralArea().getSelectedObject();
        if (eftpos == null || !eftpos.getEftposType().isPairingRequired()) {
            Dialogs.showWarningDialog("Cannot Pair Terminal", "Pairing can only be performed on Assembly / Tyro terminals.");
            return;
        }
        final EftposToolkit toolkit = new EftposToolkit((GuiHandler)new OfficeMateGuiHandler(), null, null);
        Runnable pairingRunnable = null;
        if (eftpos.getEftposType().equals((Object)EftposType.TYROWEB)) {
            final Terminal selection = this.selectTerminal();
            if (selection == null) {
                return;
            }
            pairingRunnable = new Runnable(){

                @Override
                public void run() {
                    TyroWebContext context = new TyroWebContext(toolkit, (EftposRequest)null, eftpos.getIpAddress(), eftpos.getMerchantId(), eftpos.getTerminalId(), null, false);
                    TyroWebPairing pairing = new TyroWebPairing(context, eftpos, selection);
                    pairing.performPairing();
                    eftpos.save();
                    EftposState.this.pairEftpos.setEnabled(true);
                }
            };
        } else if (eftpos.getEftposType().equals((Object)EftposType.ASSEMBLY)) {
            AssemblyEftposHelper helper = new AssemblyEftposHelper();
            if (!helper.validate(toolkit, eftpos)) {
                return;
            }
            pairingRunnable = new Runnable(){

                @Override
                public void run() {
                    AssemblyEftposFactory.dropContext();
                    AssemblyEftpos assEftpos = AssemblyEftposFactory.getAssemblyEftpos((EftposToolkit)toolkit, (VirtualEftpos)eftpos);
                    AssemblyEftposContext assemblyEftposContext = assEftpos.getContext();
                    AssemblyEftposPairingScreen assemblyEftposPairingScreen = new AssemblyEftposPairingScreen(assemblyEftposContext);
                    assemblyEftposPairingScreen.initialize();
                }
            };
        } else if (eftpos.getEftposType().equals((Object)EftposType.SMARTPAY)) {
            final Terminal selection = this.selectTerminal();
            if (selection == null) {
                return;
            }
            pairingRunnable = new Runnable(){

                @Override
                public void run() {
                    new SmartpayEftposPairingScreen((GuiHandler)new OfficeMateGuiHandler(), eftpos, selection);
                }
            };
        } else if (eftpos.getEftposType().equals((Object)EftposType.LINKLYCLOUD)) {
            pairingRunnable = new Runnable(){

                @Override
                public void run() {
                    new LinklyCloudEftposPairingScreen((GuiHandler)new OfficeMateGuiHandler(), eftpos);
                }
            };
        }
        if (pairingRunnable != null) {
            new Thread(pairingRunnable).start();
        }
    }

    private void resetRemote() {
        VirtualEftpos eftpos = (VirtualEftpos)this.getCentralArea().getSelectedObject();
        if (!eftpos.getEftposType().equals((Object)EftposType.ASSEMBLY)) {
            Dialogs.showInfoDialog("Cannot Reset Remote Terminal", "Remote Reset can only be performed on Assembly terminals.");
            return;
        }
        if (Dialogs.showChoiceDialog("Are you sure?", "Ensure that no transactions are being conducted at the terminal")) {
            EftposToolkit toolkit = new EftposToolkit((GuiHandler)new OfficeMateGuiHandler(), null, null);
            AssemblyEftpos assEftpos = AssemblyEftposFactory.getAssemblyEftpos((EftposToolkit)toolkit, (VirtualEftpos)eftpos);
            new AssemblyEftposSpiHelper(assEftpos.getContext().getAssemblyEftposSpi()).resetRemoteEftpos();
        }
    }

    private void TerminalSettings() {
        Runnable pairingRunnable = null;
        final EftposToolkit toolkit = new EftposToolkit((GuiHandler)new OfficeMateGuiHandler(), null, null);
        final VirtualEftpos eftpos = (VirtualEftpos)this.getCentralArea().getSelectedObject();
        pairingRunnable = new Runnable(){

            @Override
            public void run() {
                AdyenTerminalSettingsScreen adyenGui = new AdyenTerminalSettingsScreen(eftpos, toolkit);
                adyenGui.initialize();
            }
        };
        new Thread(pairingRunnable).start();
    }
}

