/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.eftpos;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintReceiptType;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.AlphaNumericValidator;
import ordermate.gui.binding.validators.InetAddressValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import ordermate.integration.eftpos.EftposUtil;
import ordermate.integration.onlinepayment.OnlinePaymentRequest;
import ordermate.integration.onlinepayment.OnlinePaymentRequestor;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class EftposTerminalEditor
extends AbstractObjectEditor<VirtualEftpos>
implements ActionListener {
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private static final int DEFAULT_TIMEOUT = 90000;
    private static final String DEFAULT_IP = "127.0.0.1";
    private static final String TYROWEB_DEFAULT_IP = "integration.tyro.com";
    private JComboBox eftposTypeCombo;
    private JTextField labelField;
    private JTextField ipField;
    private JTextField terminalIDField;
    private JTextField merchantIdField;
    private JButton fetchTerminalsButton;
    private JComboBox systemStateCombo;
    private JCheckBox isIntegratedCheck;
    private JCheckBox enableTipCheck;
    private JCheckBox printReceiptsCheck;
    private JCheckBox allowSurchargeCheck;
    private JLabel testingCheck;
    private JSpinner portSpinner;
    private JSpinner timeoutSpinner;
    private JTextField fileSwapField;
    private JComboBox cashdrawerCombo;
    private JTextField pairingUsernameField;
    private JTextField pairingPasswordField;
    private JComboBox printReceiptTypeCombo;
    private JComboBox preferredTerminalCombo;
    private EventList<CashDrawer> cashdrawerList = new BasicEventList();
    private EventList<Terminal> terminalList = new BasicEventList();

    public EftposTerminalEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        int cols = 30;
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.labelField = this.setupTextField(VirtualEftpos.Properties.LABEL, 30, (Validator)new NotEmptyValidator());
        this.labelField.setName("labelField");
        builder.addRow("Label", (Component)this.labelField);
        this.eftposTypeCombo = this.setupComboBox(VirtualEftpos.Properties.EFTPOS_TYPE, GlazedLists.eventList(EftposType.register.values()));
        this.eftposTypeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                JLabel label = (JLabel)super.getListCellRendererComponent(arg0, arg1, arg2, arg3, arg4);
                label.setText(((EftposType)arg1).getLabel());
                return label;
            }
        });
        this.eftposTypeCombo.setName("typeCombo");
        builder.addRow("Eftpos Type", (Component)this.eftposTypeCombo);
        this.cashdrawerCombo = this.setupNullableComboBox(VirtualEftpos.Properties.CASH_DRAWER, this.cashdrawerList, "<No Cashdrawer>");
        this.cashdrawerCombo.setName("cashdrawerCombo");
        builder.addRow("Cashdrawer", (Component)this.cashdrawerCombo);
        this.preferredTerminalCombo = this.setupNullableComboBox(VirtualEftpos.Properties.PREFERRED_TERMINAL, this.terminalList, "<No Preferred Terminal>");
        this.preferredTerminalCombo.setName("preferredTerminalCombo");
        builder.addRow("Preferred Terminal", (Component)this.preferredTerminalCombo);
        this.timeoutSpinner = new JSpinner();
        this.timeoutSpinner.setName("timeoutSpin");
        this.getBindings().createIntegerBinding(VirtualEftpos.Properties.TIMEOUT_MILLIS, this.timeoutSpinner, 0, Integer.MAX_VALUE, 90000);
        builder.addRow("Timeout (ms)", (Component)this.timeoutSpinner, "The timeout in milliseconds. 0 implies no timeout.");
        this.fetchTerminalsButton = new JButton("Fetch Terminals");
        this.fetchTerminalsButton.setVisible(false);
        this.fetchTerminalsButton.addActionListener(this);
        this.merchantIdField = this.setupTextField(VirtualEftpos.Properties.MERCHANT_ID, 30);
        this.merchantIdField.setName("merchantField");
        builder.addRow("Merchant ID", (Component)this.merchantIdField, "The asigned Eftpos Merchant ID if applicable");
        JPanel terminalIdPanel = new JPanel();
        terminalIdPanel.setLayout(new BoxLayout(terminalIdPanel, 0));
        this.terminalIDField = this.setupTextField(VirtualEftpos.Properties.TERMINAL_ID, 30);
        this.terminalIDField.setName("idField");
        terminalIdPanel.add(this.terminalIDField);
        terminalIdPanel.add(this.fetchTerminalsButton);
        builder.addRow("Terminal ID", (Component)terminalIdPanel, "The assigned Eftpos Terminal ID.");
        this.systemStateCombo = this.setupComboBox(VirtualEftpos.Properties.SYSTEM_STATE, GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE}));
        this.systemStateCombo.setName("systemStateCombo");
        builder.addRow("System State", (Component)this.systemStateCombo, "If Inactive, will not let this eftpos to be used.");
        this.isIntegratedCheck = this.setupCheckBox(VirtualEftpos.Properties.ONLINE);
        this.isIntegratedCheck.setName("onlineCheck");
        builder.addRow("Is Integrated?", (Component)this.isIntegratedCheck, "Sets whether this Eftpos machine is online and integrated.");
        this.enableTipCheck = this.setupCheckBox(VirtualEftpos.Properties.ENABLE_TIP);
        this.enableTipCheck.setName("enableTipCheck");
        builder.addRow("Enable Tip", (Component)this.enableTipCheck, "Sets whether this Eftpos will prompt for a tip for a transaction.");
        this.allowSurchargeCheck = this.setupCheckBox(VirtualEftpos.Properties.AUTO_SURCHARGE);
        this.allowSurchargeCheck.setName("allowSurchargeCheck");
        builder.addRow("Allow Surcharge", (Component)this.allowSurchargeCheck, "Sets whether this Eftpos allows auto surcharge or not, only for Tyro.");
        this.printReceiptsCheck = this.setupCheckBox(VirtualEftpos.Properties.PRINT_RECEIPTS);
        this.printReceiptsCheck.setName("printReceiptsCheck");
        builder.addRow("Print Receipts", (Component)this.printReceiptsCheck, "Checked if the POS prints eftpos receipts, otherwise eftpos machine prints the receipts.");
        this.printReceiptTypeCombo = this.setupComboBox(VirtualEftpos.Properties.PRINT_RECEIPT_TYPE, GlazedLists.eventList(EftposPrintReceiptType.register.values()));
        this.printReceiptTypeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                JLabel label = (JLabel)super.getListCellRendererComponent(arg0, arg1, arg2, arg3, arg4);
                label.setText(((EftposPrintReceiptType)arg1).getLabel());
                return label;
            }
        });
        this.printReceiptTypeCombo.setName("printReceiptTypeCombo");
        builder.addRow("Receipt Printing Strategy", (Component)this.printReceiptTypeCombo);
        this.testingCheck = new JLabel("TESTING MODE: ENABLED");
        builder.addRow("", (Component)this.testingCheck, "Checked if the eftpos is to be pointing to testing endpoints");
        this.testingCheck.setForeground(Color.ORANGE);
        builder.addSeparator("Setup Parameters");
        this.ipField = this.setupTextField(VirtualEftpos.Properties.IP_ADDRESS, 30, (Validator)new InetAddressValidator(true, true));
        this.ipField.setName("ipField");
        builder.addRow("IP Address", (Component)this.ipField);
        this.portSpinner = new JSpinner();
        this.portSpinner.setName("portSpin");
        this.getBindings().createIntegerBinding(VirtualEftpos.Properties.PORT, this.portSpinner, 0, 65535, 2011);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.portSpinner, "####");
        this.portSpinner.setEditor(editor);
        builder.addRow("Port", (Component)this.portSpinner);
        this.fileSwapField = this.setupTextField(VirtualEftpos.Properties.FILE_SWAP_DIRECTORY, 30, null);
        this.fileSwapField.setName("fileField");
        builder.addRow("File Swap Directory", (Component)this.fileSwapField);
        this.pairingUsernameField = this.setupTextField(VirtualEftpos.Properties.PAIR_USERNAME, 30);
        this.pairingUsernameField.setName("pairingUsernameField");
        builder.addRow("Username", (Component)this.pairingUsernameField, "The asigned Eftpos Merchant ID if applicable");
        this.pairingPasswordField = this.setupTextField(VirtualEftpos.Properties.PAIR_PASSWORD, 30);
        this.pairingPasswordField.setName("pairingPasswordField");
        builder.addRow("Password", (Component)this.pairingPasswordField, "The asigned Eftpos Merchant ID if applicable");
        this.add((Component)builder.getPanel(), "Center");
        this.eftposTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EftposTerminalEditor.this.enableParameters();
            }
        });
    }

    private void enableParameters() {
        String item = String.valueOf(this.eftposTypeCombo.getSelectedItem());
        boolean ipEnabled = false;
        boolean portEnabled = false;
        boolean fileDir = false;
        boolean pairingCredsEnabled = false;
        this.fiddleBindings(item);
        this.printReceiptTypeCombo.setEnabled(false);
        if (EftposUtil.isIngenicoType((String)item)) {
            ipEnabled = true;
            portEnabled = true;
            if (this.isShowing()) {
                this.ipField.setText(DEFAULT_IP);
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(true);
            this.merchantIdField.setEnabled(false);
            this.printReceiptsCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(false);
        } else if (item.equals(EftposType.MX51SPICE.toString())) {
            ipEnabled = true;
            portEnabled = true;
            if (this.isShowing()) {
                this.ipField.setText("http://localhost");
                this.portSpinner.setValue(8282);
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(false);
            this.merchantIdField.setEnabled(true);
            this.printReceiptsCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(false);
        } else if (item.equals(EftposType.SMARTPAY.toString())) {
            ipEnabled = true;
            portEnabled = false;
            if (this.isShowing()) {
                this.ipField.setText("https://api.smart-connect.cloud/POS");
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(false);
            this.merchantIdField.setEnabled(true);
            this.printReceiptsCheck.setEnabled(true);
            this.allowSurchargeCheck.setEnabled(false);
        } else if (item.equals(EftposType.ADYEN.toString())) {
            ipEnabled = false;
            portEnabled = false;
            if (this.isShowing()) {
                this.ipField.setText("https://terminal-api-live-au.adyen.com/sync");
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(true);
            this.merchantIdField.setEnabled(true);
            this.printReceiptsCheck.setEnabled(true);
            this.allowSurchargeCheck.setEnabled(false);
        } else if (item.equals(EftposType.LINKLYCLOUD.toString())) {
            ipEnabled = false;
            portEnabled = false;
            pairingCredsEnabled = true;
            if (this.isShowing()) {
                this.ipField.setText(DEFAULT_IP);
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(true);
            this.merchantIdField.setEnabled(false);
            this.terminalIDField.setEnabled(true);
            this.terminalIDField.setEditable(true);
            this.printReceiptsCheck.setEnabled(true);
            this.allowSurchargeCheck.setEnabled(false);
            this.printReceiptTypeCombo.setEnabled(true);
        } else if (item.equals(EftposType.TYRO.toString())) {
            ipEnabled = false;
            portEnabled = false;
            if (this.isShowing()) {
                this.ipField.setText(DEFAULT_IP);
                this.allowSurchargeCheck.setSelected(true);
            }
            fileDir = true;
            this.enableTipCheck.setEnabled(false);
            this.merchantIdField.setEnabled(false);
            this.printReceiptsCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(true);
        } else if (item.equals(EftposType.TYROWEB.toString())) {
            ipEnabled = true;
            portEnabled = true;
            if (this.isShowing()) {
                this.ipField.setText(TYROWEB_DEFAULT_IP);
                this.allowSurchargeCheck.setSelected(true);
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(true);
            this.merchantIdField.setEnabled(true);
            this.printReceiptsCheck.setEnabled(true);
            this.allowSurchargeCheck.setEnabled(true);
        } else if (item.equals(EftposType.TYROMOBILE.toString())) {
            ipEnabled = false;
            portEnabled = false;
            if (this.isShowing()) {
                this.ipField.setText(DEFAULT_IP);
                this.allowSurchargeCheck.setSelected(true);
            }
            fileDir = false;
            this.enableTipCheck.setEnabled(true);
            this.merchantIdField.setEnabled(true);
            this.printReceiptsCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(true);
        } else if (item.equals(EftposType.ASSEMBLY.toString())) {
            ipEnabled = true;
            portEnabled = false;
            fileDir = false;
            this.merchantIdField.setEditable(false);
            this.terminalIDField.setEditable(false);
            this.isIntegratedCheck.setEnabled(false);
            this.enableTipCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(false);
            this.printReceiptsCheck.setEnabled(true);
            this.fileSwapField.setEditable(false);
            this.portSpinner.setEnabled(false);
            this.fileSwapField.setEditable(false);
        } else if (item.equals(EftposType.ONLINE.toString())) {
            ipEnabled = false;
            portEnabled = false;
            fileDir = false;
            this.merchantIdField.setEditable(false);
            this.terminalIDField.setEditable(true);
            this.isIntegratedCheck.setEnabled(false);
            this.enableTipCheck.setEnabled(false);
            this.allowSurchargeCheck.setEnabled(false);
            this.printReceiptsCheck.setEnabled(true);
            this.fileSwapField.setEditable(false);
            this.portSpinner.setEnabled(false);
        }
        this.pairingUsernameField.setEnabled(pairingCredsEnabled);
        this.pairingPasswordField.setEnabled(pairingCredsEnabled);
        this.fetchTerminalsButton.setVisible(item.equals(EftposType.ONLINE.toString()));
        this.portSpinner.setEnabled(portEnabled);
        this.ipField.setEnabled(ipEnabled);
        this.testingCheck.setVisible(((VirtualEftpos)this.getObject()).isTesting());
        this.fileSwapField.setEnabled(fileDir);
        String text = this.fileSwapField.getText();
        this.fileSwapField.setText("");
        this.fileSwapField.setText(text);
    }

    private void fiddleBindings(String comboType) {
        Binding ipAddressBinding = this.getBindings().findBinding(VirtualEftpos.Properties.IP_ADDRESS);
        Binding labelBinding = this.getBindings().findBinding(VirtualEftpos.Properties.LABEL);
        if (ipAddressBinding.isBound() && labelBinding.isBound()) {
            if (comboType.equals(EftposType.ASSEMBLY.toString())) {
                ipAddressBinding.unbind();
                ipAddressBinding.setValidator((Validator)new InetAddressValidator(true, true));
                ipAddressBinding.bind();
                labelBinding.unbind();
                labelBinding.setValidator((Validator)new AlphaNumericValidator());
                labelBinding.bind();
            } else {
                ipAddressBinding.unbind();
                ipAddressBinding.setValidator(null);
                ipAddressBinding.bind();
                labelBinding.unbind();
                labelBinding.setValidator((Validator)new NotEmptyValidator());
                labelBinding.bind();
            }
            ipAddressBinding.refreshAndNotify();
            labelBinding.refreshAndNotify();
            this.getBindings().isGuiValid();
        }
    }

    @Override
    public void setObject(VirtualEftpos toEdit) {
        super.setObject(toEdit);
        this.cashdrawerCombo.getModel().setSelectedItem(toEdit.getCashDrawer());
        this.preferredTerminalCombo.getModel().setSelectedItem(toEdit.getPreferredTerminal());
    }

    @Override
    public void refresh() {
        super.refresh();
        try {
            this.cashdrawerList.getReadWriteLock().writeLock().lock();
            this.cashdrawerList.clear();
            this.cashdrawerList.addAll((Collection)PersistenceManager.getObjectList(CashDrawer.class, (String)Query.select(CashDrawer.class).active(CashDrawer.class).toString()));
            ((NullableEventComboBoxModel)this.cashdrawerCombo.getModel()).prependNullPlaceholder(this.cashdrawerList);
            this.terminalList.getReadWriteLock().writeLock().lock();
            this.terminalList.clear();
            this.terminalList.addAll((Collection)PersistenceManager.getObjectList(Terminal.class, (String)Query.select(Terminal.class).active(Terminal.class).toString()));
            ((NullableEventComboBoxModel)this.preferredTerminalCombo.getModel()).prependNullPlaceholder(this.terminalList);
        }
        finally {
            this.cashdrawerList.getReadWriteLock().writeLock().unlock();
        }
        this.enableParameters();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.fetchTerminalsButton == e.getSource()) {
            this.doFetchDetails();
        }
    }

    private void doFetchDetails() {
        OnlinePaymentRequestor requestor = null;
        try {
            requestor = (OnlinePaymentRequestor)SimpleRMI.getObject((InetAddress)Terminal.getServerMateTerminal().getAddress(), (String)"Online Payment Requestor", (int)11100);
            List requests = requestor.getPaymentRequests();
            if (requests.isEmpty()) {
                Dialogs.showWarningDialog("No Online Payment Processors", "You don't have any current online payment processors configured");
                return;
            }
            OnlinePaymentRequest request = null;
            request = requests.size() == 1 ? (OnlinePaymentRequest)requests.get(0) : (OnlinePaymentRequest)Dialogs.showOptionDialog("Which Payment Provider", "Select the possible payment provider", requests);
            if (request != null) {
                this.terminalIDField.setText(request.getAppId());
                Dialogs.showInfoDialog("Setting Eftpos for " + request.getLabel(), "Terminal ID = " + request.getAppId());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot get Online Payment Requestor", (Throwable)ex);
        }
    }
}

