/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.kiosk.Kiosk;
import ordermate.database.kiosk.KioskIntegratedPaymentType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.InetAddressValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

@Deprecated
class KioskEditor
extends AbstractObjectEditor<Kiosk> {
    private EventList<VirtualPrinter> printers;
    private JLabel typeLabel;
    private JComboBox cashdrawerCombo;
    private JComboBox integratedPaymentCombo;
    private JTextField maxPaymentAllowed;
    private EventList<CashDrawer> cashdrawerList = new BasicEventList();

    KioskEditor() {
        this.setLayout(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.printers = GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        builder.addRow("Label", (Component)this.setupTextField(Kiosk.Properties.LABEL, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("IP", (Component)this.setupTextField(Kiosk.Properties.IP, 20, (Validator)new InetAddressValidator(true)));
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ);
        this.typeLabel = new JLabel();
        builder.addRow("Type", (Component)this.typeLabel);
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        builder.addRow("Receipt Printer", (Component)this.setupNullableComboBox(Kiosk.Properties.VIRTUAL_PRINTER, this.printers, "<None>"));
        builder.addRow("Welcome Title", (Component)this.setupTextField(Kiosk.Properties.WELCOME_TITLE, 40));
        builder.addRow("Welcome Text", (Component)this.setupTextArea(Kiosk.Properties.WELCOME_TEXT, 40, 5, null));
        builder.addRow("Theme name", (Component)this.setupTextField(Kiosk.Properties.THEME, 20));
        this.integratedPaymentCombo = this.setupComboBox(Kiosk.Properties.INTEGRATED_PAYMENT_TYPE, GlazedLists.eventList(KioskIntegratedPaymentType.getRegister().values()));
        builder.addRow("Integrated Payments", (Component)this.integratedPaymentCombo);
        this.integratedPaymentCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KioskEditor.this.enableAdditionalPaymentOptions();
            }
        });
        this.maxPaymentAllowed = this.setupPriceField((PropertiedObject.Property<Price>)Kiosk.Properties.MAX_INTEGRATED_PAYMENT_AMOUNT, 6);
        builder.addRow("Max Inegrated Payment", (Component)this.maxPaymentAllowed);
        this.cashdrawerCombo = this.setupNullableComboBox(Kiosk.Properties.PAYMENT_CASHDRAWER, this.cashdrawerList, "<No Cashdrawer>");
        this.cashdrawerCombo.setName("cashdrawerCombo");
        builder.addRow("Cashdrawer", (Component)this.cashdrawerCombo);
        this.add((Component)builder.getPanel(), "North");
    }

    @Override
    public void setObject(Kiosk toEdit) {
        super.setObject(toEdit);
        this.typeLabel.setText(toEdit.getKioskType().name());
    }

    @Override
    public void refresh() {
        this.printers.getReadWriteLock().writeLock().lock();
        this.printers.clear();
        this.printers.addAll((Collection)VirtualPrinter.getAllPrinters());
        this.printers.getReadWriteLock().writeLock().unlock();
        try {
            this.cashdrawerList.getReadWriteLock().writeLock().lock();
            this.cashdrawerList.clear();
            this.cashdrawerList.addAll((Collection)PersistenceManager.getObjectList(CashDrawer.class, (String)Query.select(CashDrawer.class).toString()));
            ((NullableEventComboBoxModel)this.cashdrawerCombo.getModel()).prependNullPlaceholder(this.cashdrawerList);
        }
        finally {
            this.cashdrawerList.getReadWriteLock().writeLock().unlock();
        }
        super.refresh();
    }

    private void enableAdditionalPaymentOptions() {
        boolean optionsEnabled = !KioskIntegratedPaymentType.None.equals(this.integratedPaymentCombo.getSelectedItem());
        this.cashdrawerCombo.setEnabled(optionsEnabled);
        this.maxPaymentAllowed.setEnabled(optionsEnabled);
    }
}

