/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.menu;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuCombo;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

@Deprecated
class ComboSelectionTableModel
extends AbstractTableModel {
    Signal<InventoryCombo, ?, ?, ?, ?> comboChanged = Signals.createSignal(InventoryCombo.class, (String)"combo");
    private static final String[] COLUMN_NAMES = new String[]{"Combo Name", "Show On Kiosk", "Alias", "Icon"};
    private static final int COL_IDX_SHOW_ON_KIOSK = 1;
    private static final int COL_IDX_ALIAS = 2;
    private static final int COL_IDX_ICON = 3;
    private InventoryProfile profile;
    private KioskMenu currentMenu;
    private List<InventoryCombo> comboList = new ArrayList<InventoryCombo>();
    private Map<InventoryCombo, KioskMenuCombo> includedMap = new HashMap<InventoryCombo, KioskMenuCombo>();

    public void setKioskMenu(KioskMenu menu) {
        this.currentMenu = menu;
    }

    @Override
    public int getRowCount() {
        return this.comboList.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    void setProfileAndMenu(InventoryProfile theProfile, KioskMenu theMenu) {
        if (this.profile != theProfile || this.currentMenu != theMenu) {
            this.profile = theProfile;
            this.currentMenu = theMenu;
            this.rebuildComboList();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object toReturn = this.comboList.get(rowIndex);
        if (columnIndex == 0) {
            toReturn = toReturn.getLabel();
        } else if (columnIndex == 1) {
            toReturn = this.includedMap.containsKey(toReturn) && SystemState.ACTIVE_STATE.equals((Object)this.includedMap.get(toReturn).getSystemState());
        } else if (columnIndex == 2) {
            KioskMenuCombo kioskCombo = this.includedMap.get(toReturn);
            toReturn = kioskCombo != null ? kioskCombo.getComboAlias() : "";
        } else if (columnIndex == 3) {
            KioskMenuCombo kioskCombo = this.includedMap.get(toReturn);
            toReturn = kioskCombo != null ? kioskCombo.getComboIcon() : "";
        }
        return toReturn;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        InventoryCombo combo = this.comboList.get(rowIndex);
        KioskMenuCombo kioskCombo = this.includedMap.get(combo);
        if (columnIndex == 1) {
            if (Boolean.TRUE.equals(value)) {
                this.includedMap.put(combo, this.currentMenu.addCombo(combo));
            } else {
                this.includedMap.put(combo, this.currentMenu.removeCombo(combo));
            }
            this.comboChanged.emit((Object)combo);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 2) {
            if (kioskCombo == null) {
                kioskCombo = this.currentMenu.addCombo(combo);
                this.includedMap.put(combo, kioskCombo);
            }
            kioskCombo.setComboAlias(value == null ? null : String.valueOf(value));
            this.comboChanged.emit((Object)combo);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 3) {
            if (kioskCombo == null) {
                kioskCombo = this.currentMenu.addCombo(combo);
                this.includedMap.put(combo, kioskCombo);
            }
            kioskCombo.setComboIcon(value == null ? null : String.valueOf(value));
            this.comboChanged.emit((Object)combo);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Class getColumnClass(int col) {
        return col == 1 ? Boolean.class : Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 2 || col == 3;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    private void rebuildComboList() {
        if (this.profile == null) {
            return;
        }
        ObjectQuery query = Query.select(InventoryCombo.class).equals(InventoryCombo.Properties.PROFILE, (Object)this.profile).active(InventoryCombo.class);
        this.comboList.clear();
        this.includedMap.clear();
        this.comboList.addAll(PersistenceManager.getObjectList(InventoryCombo.class, (String)query.toString()));
        for (KioskMenuCombo nextLink : this.currentMenu.getCombos()) {
            if (!this.comboList.contains(nextLink.getCombo())) continue;
            this.includedMap.put(nextLink.getCombo(), nextLink);
        }
        this.fireTableDataChanged();
    }
}

