/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.menu;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import officemate.screens.setup.devices.kiosk.menu.KioskMenuGroupTableModel;
import officemate.screens.setup.devices.kiosk.menu.UnitSelectionTableModel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

@Deprecated
class KioskMenuUnitSelectionPanel
extends JPanel
implements ObjectEditor<KioskMenu>,
ListSelectionListener {
    Signal<KioskMenu, ?, ?, ?, ?> menuChanged = Signals.createSignal(KioskMenu.class, (String)"menu");
    private JTable menuSectionTable;
    private KioskMenuGroupTableModel menuGroupTableModel;
    private JTable unitSelectionTable;
    private UnitSelectionTableModel unitModel;
    private InventoryProfile currentProfile;
    private PriceLevel currentPriceLevel;
    private KioskMenu currentMenu;

    KioskMenuUnitSelectionPanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.menuGroupTableModel = new KioskMenuGroupTableModel();
        this.menuSectionTable = new JTable(this.menuGroupTableModel);
        this.menuSectionTable.setSelectionMode(0);
        this.menuSectionTable.setAutoResizeMode(3);
        this.menuSectionTable.getSelectionModel().addListSelectionListener(this);
        TableColumn column = this.menuSectionTable.getColumnModel().getColumn(0);
        column.setCellEditor(this.menuGroupTableModel.createContainmentEditor());
        column.setCellRenderer(this.menuGroupTableModel.createContainmentRenderer());
        column.setPreferredWidth(30);
        column.setMaxWidth(30);
        column.setResizable(false);
        this.menuSectionTable.getColumnModel().getColumn(1).setCellRenderer(this.menuGroupTableModel.createRenderer());
        this.menuGroupTableModel.menuChanged.connect((Object)this, "gotMenuChanged");
        JScrollPane scrolly = new JScrollPane(this.menuSectionTable);
        scrolly.getViewport().setPreferredSize(new Dimension(180, 300));
        this.add((Component)scrolly, "West");
        this.unitModel = new UnitSelectionTableModel();
        this.unitSelectionTable = new JTable(this.unitModel);
        this.unitModel.unitChanged.connect((Object)this, "gotUnitChanged");
        this.unitSelectionTable.setSelectionMode(0);
        scrolly = new JScrollPane(this.unitSelectionTable);
        this.add((Component)scrolly, "Center");
    }

    public void setProfile(InventoryProfile theProfile, boolean shouldUpdate) {
        if (this.currentProfile != theProfile) {
            this.currentProfile = theProfile;
            if (shouldUpdate) {
                this.updateTreeAndTable();
            }
        }
    }

    public void setPriceLevel(PriceLevel thePriceLevel, boolean shouldUpdate) {
        if (this.currentPriceLevel != thePriceLevel) {
            this.currentPriceLevel = thePriceLevel;
            if (shouldUpdate) {
                this.updateTreeAndTable();
            }
        }
    }

    public void saveObject() {
        this.currentMenu.save();
    }

    public void setObject(KioskMenu toEdit) {
        if (this.currentMenu != toEdit) {
            this.currentMenu = toEdit;
            this.unitModel.setKioskMenu(toEdit);
            this.updateTreeAndTable();
        }
    }

    public KioskMenu getObject() {
        return this.currentMenu;
    }

    public boolean isGuiValid() {
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public void revertObject() {
        this.currentMenu = (KioskMenu)PersistenceManager.reacquire((PersistentObjectI)this.currentMenu);
        this.updateTreeAndTable();
    }

    private void updateTreeAndTable() {
        this.menuGroupTableModel.setProfilePriceLevelAndMenu(this.currentProfile, this.currentPriceLevel, this.currentMenu);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            InventoryGroup group = this.menuGroupTableModel.getGroupAt(this.menuSectionTable.getSelectedRow());
            if (group != null) {
                this.unitModel.updateValues(this.menuGroupTableModel.getGroupUnitMap().get(group));
            } else {
                this.unitModel.updateValues(null);
            }
        }
    }

    public void gotMenuChanged() {
        this.menuChanged.emit((Object)this.getObject());
    }

    public void gotUnitChanged(UnitPriceLevel altered) {
        this.menuSectionTable.validate();
        this.menuSectionTable.repaint();
        this.menuChanged.emit((Object)this.getObject());
    }
}

