/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

@Deprecated
class UnitSelectionTableModel
extends AbstractTableModel {
    Signal<UnitPriceLevel, ?, ?, ?, ?> unitChanged = Signals.createSignal(UnitPriceLevel.class, (String)"unit");
    private static final String[] names = new String[]{"Item Name", "Size", "Portion", "Show On Kiosk", "Alias", "Icon"};
    private static final int SHOW_ON_KIOSK = 3;
    private static final int ALIAS = 4;
    private static final int ICON = 5;
    private List<UnitPriceLevel> unitPriceList = new ArrayList<UnitPriceLevel>();
    private Map<UnitPriceLevel, KioskMenuUnitPriceLevel> includedMap = new HashMap<UnitPriceLevel, KioskMenuUnitPriceLevel>();
    private KioskMenu currentMenu;

    UnitSelectionTableModel() {
    }

    public void setKioskMenu(KioskMenu yourMenu) {
        this.currentMenu = yourMenu;
    }

    void updateValues(List<UnitPriceLevel> levels) {
        this.unitPriceList.clear();
        this.includedMap.clear();
        if (levels != null) {
            this.unitPriceList.addAll(levels);
            for (KioskMenuUnitPriceLevel nextLink : this.currentMenu.getUnitPriceLevels()) {
                if (!levels.contains(nextLink.getUnitPriceLevel())) continue;
                this.includedMap.put(nextLink.getUnitPriceLevel(), nextLink);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.unitPriceList.size();
    }

    @Override
    public int getColumnCount() {
        return names.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object toReturn = this.unitPriceList.get(rowIndex);
        if (columnIndex == 0) {
            toReturn = toReturn.getUnit().getLabel();
        } else if (columnIndex == 1) {
            toReturn = toReturn.getUnit().getSize();
        } else if (columnIndex == 2) {
            toReturn = toReturn.getUnit().getPortion();
        } else if (columnIndex == 3) {
            toReturn = this.includedMap.containsKey(toReturn) && SystemState.ACTIVE_STATE.equals((Object)this.includedMap.get(toReturn).getSystemState());
        } else if (columnIndex == 4) {
            KioskMenuUnitPriceLevel kioskLevel = this.includedMap.get(toReturn);
            toReturn = kioskLevel != null ? kioskLevel.getItemAlias() : "";
        } else if (columnIndex == 5) {
            KioskMenuUnitPriceLevel kioskLevel = this.includedMap.get(toReturn);
            toReturn = kioskLevel != null ? kioskLevel.getIcon() : "";
        }
        return toReturn;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        UnitPriceLevel level = this.unitPriceList.get(rowIndex);
        KioskMenuUnitPriceLevel kioskLevel = this.includedMap.get(level);
        if (columnIndex == 3) {
            if (Boolean.TRUE.equals(value)) {
                this.includedMap.put(level, this.currentMenu.addUnitPriceLevel(level));
            } else {
                this.includedMap.put(level, this.currentMenu.removeUnitPriceLevel(level));
            }
            this.unitChanged.emit((Object)level);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 4) {
            if (kioskLevel == null) {
                kioskLevel = this.currentMenu.addUnitPriceLevel(level);
                this.includedMap.put(level, kioskLevel);
            }
            kioskLevel.setItemAlias(value == null ? null : String.valueOf(value));
            this.unitChanged.emit((Object)level);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 5) {
            if (kioskLevel == null) {
                kioskLevel = this.currentMenu.addUnitPriceLevel(level);
                this.includedMap.put(level, kioskLevel);
            }
            kioskLevel.setIcon(value == null ? null : String.valueOf(value));
            this.unitChanged.emit((Object)level);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Class getColumnClass(int col) {
        return col == 3 ? Boolean.class : Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 3 || col == 4 || col == 5;
    }

    @Override
    public String getColumnName(int column) {
        return names[column];
    }
}

