/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.pages;

import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.JTabbedPane;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.devices.kiosk.pages.item.KioskOrderableClickablesPanel;
import officemate.screens.setup.devices.kiosk.pages.item.KioskOrderableCombosPanel;
import officemate.screens.setup.devices.kiosk.pages.item.KioskOrderableItemsPanel;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.KioskItemGroupType;
import ordermate.database.misc.Course;
import ordermate.gui.FieldPanelBuilder;

abstract class AbstractOrderingKioskPageEditor<T extends AbstractOrderingKioskPage>
extends AbstractObjectEditor<T> {
    private KioskOrderableItemsPanel orderableItemsPanel;
    private KioskOrderableCombosPanel orderableCombosPanel;
    private KioskOrderableClickablesPanel orderableClickablesPanel;

    AbstractOrderingKioskPageEditor() {
        JTabbedPane tabs = new JTabbedPane();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Course", (Component)this.setupNullableComboBox(AbstractOrderingKioskPage.Properties.COURSE, GlazedLists.eventList((Collection)Course.getCourses()), "None"));
        builder.addRow("Item Type", (Component)this.setupComboBox(AbstractOrderingKioskPage.Properties.ITEM_GROUP_TYPE, GlazedLists.eventListOf((Object[])KioskItemGroupType.values())));
        this.addInExtraProperties(builder);
        tabs.add("General", builder.getPanel());
        this.orderableItemsPanel = KioskOrderableItemsPanel.makeNew();
        tabs.add("Orderable Items", this.orderableItemsPanel);
        this.orderableCombosPanel = new KioskOrderableCombosPanel();
        tabs.add("Orderable Combos", this.orderableCombosPanel);
        this.orderableClickablesPanel = KioskOrderableClickablesPanel.makeNew();
        tabs.add("Clickables", this.orderableClickablesPanel);
        this.orderableItemsPanel.setPreferredSize(new Dimension(600, 200));
        this.orderableCombosPanel.setPreferredSize(new Dimension(600, 200));
        this.orderableClickablesPanel.setPreferredSize(new Dimension(600, 200));
        this.add((Component)tabs, "South");
    }

    @Override
    public void setObject(T toEdit) {
        super.setObject(toEdit);
        this.orderableItemsPanel.setObject((AbstractOrderingKioskPage)toEdit);
        this.orderableCombosPanel.setObject(toEdit);
        this.orderableClickablesPanel.setObject((AbstractOrderingKioskPage)toEdit);
    }

    @Override
    public void saveObject() {
        this.orderableItemsPanel.saveObject();
        this.orderableCombosPanel.saveObject();
        this.orderableClickablesPanel.saveObject();
        super.saveObject();
    }

    protected abstract void addInExtraProperties(FieldPanelBuilder var1);
}

