/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.pages;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.devices.kiosk.pages.GridOrderingKioskPageEditor;
import officemate.screens.setup.devices.kiosk.pages.ImageAndTextKioskPageEditor;
import officemate.screens.setup.devices.kiosk.pages.TabbedOrderingKioskPageEditor;
import ordermate.database.kiosk.pages.KioskPage;
import ordermate.database.kiosk.pages.KioskPageType;
import ordermate.gui.FieldPanelBuilder;

class KioskPageEditor
extends AbstractObjectEditor<KioskPage> {
    private JLabel typeLabel;
    private JLabel pathLabel;
    private JPanel extraHolder;
    private AbstractObjectEditor extraEditor;
    private JComboBox fastFinishCombo;
    private String[] fastFinishOptions = new String[]{"Default", "Enforce On", "Enforce Off"};

    KioskPageEditor() {
        this.setLayout(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.pathLabel = new JLabel();
        builder.addRow("Path", (Component)this.pathLabel);
        this.typeLabel = new JLabel();
        builder.addRow("Type", (Component)this.typeLabel);
        builder.addRow("Label", (Component)this.setupTextField(KioskPage.Properties.LABEL, 20));
        builder.addRow("Sequence", (Component)this.setupIntSpinner(KioskPage.Properties.SEQUENCE, 1, 0, null, 1, 5));
        builder.addRow("Welcome Text", (Component)this.setupTextField(KioskPage.Properties.WELCOME_TEXT, 40));
        builder.addRow("Is Forced?", (Component)this.setupCheckBox(KioskPage.Properties.FORCED));
        builder.addRow("Background", (Component)this.setupTextField(KioskPage.Properties.BACKGROUND, 40));
        builder.addRow("One Touch Ordering", (Component)this.setupCheckBox(KioskPage.Properties.ONE_TOUCH_ORDERING));
        this.fastFinishCombo = new JComboBox<String>(this.fastFinishOptions);
        this.fastFinishCombo.setEditable(false);
        builder.addRow("Fast Finish", (Component)this.fastFinishCombo);
        this.add((Component)builder.getPanel(), "Center");
        this.extraHolder = new JPanel(new BorderLayout());
        this.add((Component)this.extraHolder, "South");
    }

    @Override
    public void setObject(KioskPage page) {
        if (page != null) {
            this.typeLabel.setText(page.getKioskPageType().name());
            this.pathLabel.setText(page.getPath().getKiosk().getLabel() + " - " + page.getPath().getLabel());
            Boolean fastFinish = page.getFastFinish();
            if (fastFinish == null) {
                this.fastFinishCombo.setSelectedItem(this.fastFinishOptions[0]);
            } else if (fastFinish.booleanValue()) {
                this.fastFinishCombo.setSelectedItem(this.fastFinishOptions[1]);
            } else {
                this.fastFinishCombo.setSelectedItem(this.fastFinishOptions[2]);
            }
        }
        super.setObject(page);
        this.swapOverPanel(page);
    }

    @Override
    public void saveObject() {
        String item = (String)this.fastFinishCombo.getSelectedItem();
        if (item == null) {
            item = this.fastFinishOptions[0];
        }
        if (item.equals(this.fastFinishOptions[0])) {
            ((KioskPage)this.getObject()).setFastFinish(null);
        } else if (item.equals(this.fastFinishOptions[1])) {
            ((KioskPage)this.getObject()).setFastFinish(Boolean.TRUE);
        } else {
            ((KioskPage)this.getObject()).setFastFinish(Boolean.FALSE);
        }
        if (this.extraEditor != null) {
            this.extraEditor.saveObject();
        }
        super.saveObject();
    }

    private void swapOverPanel(KioskPage thePage) {
        KioskPageType type = thePage.getKioskPageType();
        if (type.equals((Object)KioskPageType.ImageAndText)) {
            this.extraEditor = new ImageAndTextKioskPageEditor();
        } else if (type.equals((Object)KioskPageType.GridOrdering)) {
            this.extraEditor = new GridOrderingKioskPageEditor();
        } else if (type.equals((Object)KioskPageType.TabbedOrdering)) {
            this.extraEditor = new TabbedOrderingKioskPageEditor();
        } else {
            throw new IllegalArgumentException("Kiosk Page Editor not found for:" + type);
        }
        this.extraHolder.removeAll();
        this.extraEditor.setObject(thePage);
        this.extraHolder.add(this.extraEditor);
    }
}

