/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.pages;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JLabel;
import officemate.components.AbstractObjectEditor;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.KioskPathType;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

public class KioskPathEditor
extends AbstractObjectEditor<KioskPath> {
    private JLabel kioskLabel;
    private JLabel typeLabel;
    private EventList<KioskMenu> kioskMenus;
    private EventList<KioskPathType> pathTypes = GlazedLists.eventListOf((Object[])KioskPathType.values());

    public KioskPathEditor() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.kioskMenus = new BasicEventList();
        this.kioskMenus.addAll((Collection)PersistenceManager.getObjectList(KioskMenu.class, (String)Query.select(KioskMenu.class).toString()));
        this.kioskLabel = new JLabel();
        builder.addRow("Kiosk", (Component)this.kioskLabel);
        builder.addRow("Path Type", (Component)this.setupComboBox(KioskPath.Properties.PATH_TYPE, this.pathTypes));
        builder.addRow("Label", (Component)this.setupTextField(KioskPath.Properties.LABEL, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("Alias", (Component)this.setupTextField(KioskPath.Properties.ALIAS, 20), "The gui representation of the path");
        builder.addRow("Icon", (Component)this.setupTextField(KioskPath.Properties.PATH_ICON, 20), "The gui icon for this path");
        builder.addRow("Requires Login?", (Component)this.setupCheckBox(KioskPath.Properties.REQUIRE_LOGIN));
        builder.addRow("Show Login at start?", (Component)this.setupCheckBox(KioskPath.Properties.SHOW_LOGIN_AT_START));
        builder.addRow("Kiosk Menu", (Component)this.setupComboBox(KioskPath.Properties.MENU, this.kioskMenus));
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(KioskPath path) {
        this.kioskLabel.setText(path.getKiosk().getLabel());
        this.typeLabel.setText(path.getPathType().name());
        super.setObject(path);
    }
}

