/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.pages.item;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import java.util.Collection;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PropertyAccessorColumnFormat;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuCombo;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.item.KioskPageCombo;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;
import ordermate.reports.table.ColumnFormat;

public class KioskOrderableCombosPanel
extends TableListObjectEditor<AbstractOrderingKioskPage, KioskPageItem> {
    public KioskOrderableCombosPanel() {
        super(new PersistentObjectTable(new BasicEventList(), new KioskComboOrderingColumnFormat()));
    }

    @Override
    public KioskPageItem createNewObject() {
        KioskMenu menu = ((AbstractOrderingKioskPage)this.getObject()).getPath().getMenu();
        if (menu != null) {
            return this.selectItemToAdd(menu);
        }
        Dialogs.showErrorDialog("No Menu", "A KioskMenu on the Path is required");
        return null;
    }

    private KioskPageItem selectItemToAdd(KioskMenu menu) {
        List comboList = menu.getCombos();
        KioskMenuCombo selection = (KioskMenuCombo)Dialogs.showOptionDialog("Select Combo", "Please select a Combo to add", comboList);
        if (selection != null) {
            KioskPageCombo item = new KioskPageCombo((AbstractOrderingKioskPage)this.getObject(), selection);
            return item;
        }
        return null;
    }

    @Override
    public void addObjectToParent(KioskPageItem toAdd) {
        ((AbstractOrderingKioskPage)this.getObject()).addOrderableItem(toAdd);
    }

    @Override
    public void removeObjectFromParent(KioskPageItem toRemove) {
        ((AbstractOrderingKioskPage)this.getObject()).removeOrderableItem(toRemove);
    }

    @Override
    public Collection getParentList() {
        return ((AbstractOrderingKioskPage)this.getObject()).getPageItems(KioskPageItemType.Combo);
    }

    private static final class KioskComboOrderingColumnFormat
    extends ColumnTableFormat {
        public KioskComboOrderingColumnFormat() {
            super(new ColumnFormat[]{new PropertyAccessorColumnFormat("Item", new PropertiedObject.Property[]{KioskPageCombo.Properties.ORDERABLE_COMBO, KioskMenuCombo.Properties.COMBO, InventoryCombo.Properties.LABEL}, null), new EditablePropertyColumnFormat(KioskPageItem.Properties.SEQUENCE), new EditablePropertyColumnFormat(KioskPageItem.Properties.LABEL), new EditablePropertyColumnFormat(KioskPageItem.Properties.ICON)});
        }
    }
}

