/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kts;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import officemate.screens.setup.devices.kts.KTSPropertyPanel;
import ordermate.database.config.ConfigStyleSheet;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSModLines;
import ordermate.database.hardware.physical.kts.KTSShowTime;
import ordermate.database.hardware.physical.kts.KTSSummaryGroupingStrategyType;
import ordermate.database.hardware.physical.kts.KTSSummarySortingStrategyType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.FontAttributesEditor;
import ordermate.gui.LimitedColorSelector;
import ordermate.gui.binding.BindingHelper;
import ordermate.gui.binding.validators.InetAddressValidator;
import ordermate.gui.binding.validators.KTSDocketPrinterUserNameValidatior;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.model.NullableEventComboBoxModel;
import org.jdesktop.beansbinding.Validator;

class KTSDocketPrinterEditor
extends AbstractObjectEditor<KTSDocketPrinter> {
    private EventList<PhysicalPrintDevice> activePrintDevices;
    private JSpinner summaryColumnsSpinner;
    private JComboBox redemptionStyleSheetComboBox;
    private KTSPropertyPanel propertyPanel;
    private JTextField ipAddressField;
    private KTSDocketPrinterUserNameValidatior userNameValidator;

    public KTSDocketPrinterEditor(BindingHelper<KTSDocketPrinter> bindings, BindingGuiSupportPanel.ObjectEditedListener listener) {
        super(bindings, listener);
    }

    @Override
    protected void init() {
        super.init();
        super.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent component = this.setupTextField(KTSDocketPrinter.Properties.LABEL, 30, (Validator)new NotEmptyValidator());
        builder.addRow("Label", (Component)component);
        this.ipAddressField = this.setupTextField(KTSDocketPrinter.Properties.IP_ADDRESS, 15, (Validator)new InetAddressValidator(false, true));
        builder.addRow("IP Address", (Component)this.ipAddressField);
        this.userNameValidator = new KTSDocketPrinterUserNameValidatior(this.ipAddressField);
        component = this.setupTextField(KTSDocketPrinter.Properties.USER_NAME, 15, (Validator)this.userNameValidator);
        builder.addRow("User Name", (Component)component);
        this.activePrintDevices = new BasicEventList();
        component = this.setupNullableComboBox(KTSDocketPrinter.Properties.BACKUP_PRINTER, (EventList)this.activePrintDevices, "<No Backup>");
        builder.addRow("Backup Print Device", (Component)component);
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)builder.getPanel(), "North");
        JTabbedPane tab = new JTabbedPane();
        tab.add("General", this.createGeneralPanel());
        tab.add("Colour", this.createColourPanel());
        tab.add("Font", this.createFontPanel());
        tab.add("Timer", this.createTimerPanel());
        tab.add("Summary", this.createSummaryPanel());
        this.propertyPanel = new KTSPropertyPanel();
        tab.add("Properties", this.propertyPanel);
        holder.add((Component)tab, "Center");
        this.add((Component)holder, "Center");
    }

    private JPanel createGeneralPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent comp = this.setupIntSpinner(KTSDocketPrinter.Properties.NUM_ROWS, 1, 1, 20, 2, 4);
        builder.addRow("Number of Rows", (Component)comp);
        final JSpinner columnsSpinner = this.setupIntSpinner(KTSDocketPrinter.Properties.NUM_COLUMNS, 1, 1, 20, 2, 4);
        columnsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Integer maximum = Math.max((Integer)columnsSpinner.getValue() - 1, 1);
                KTSDocketPrinterEditor.this.constrainSummaryColumnValues(maximum);
            }
        });
        builder.addRow("Number of Columns", (Component)columnsSpinner);
        builder.addRow("Rushable?", (Component)this.setupCheckBox(KTSDocketPrinter.Properties.RUSHABLE));
        builder.addRow("Show Status Bar?", (Component)this.setupCheckBox(KTSDocketPrinter.Properties.SHOW_STATUS_BAR));
        comp = this.setupComboBox(KTSDocketPrinter.Properties.MOD_LINES, GlazedLists.eventListOf((Object[])KTSModLines.values()));
        comp.setToolTipText("A line per mod, line per Option Group or a line per Add/Remove/Option");
        builder.addRow("Modification Lines", (Component)comp);
        BasicEventList stylesheets = new BasicEventList();
        stylesheets.addAll((Collection)ConfigStyleSheet.getAllStyleSheets());
        this.redemptionStyleSheetComboBox = this.setupNullableComboBox(KTSDocketPrinter.Properties.REDEMPTION_STYLE_SHEET, (EventList)stylesheets, "None");
        builder.addRow("Account Redemption Style Sheet", (Component)this.redemptionStyleSheetComboBox);
        return builder.getPanel();
    }

    private JPanel createColourPanel() {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 0));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Completed Colour", (Component)this.makeColourControl(KTSDocketPrinter.Properties.COMPLETED_COLOUR, "completed lines"));
        builder.addRow("Deleted Colour", (Component)this.makeColourControl(KTSDocketPrinter.Properties.DELETED_COLOUR, "deleted items"));
        builder.addRow("Transfer Colour", (Component)this.makeColourControl(KTSDocketPrinter.Properties.TRANSFER_COLOUR, "transferred items"));
        builder.addRow("Alternate Colours on Dockets", (Component)this.setupCheckBox(KTSDocketPrinter.Properties.ALTERNATE_COLOURS), "If checked, colours of dockets will alternate between the two chosen colours.");
        builder.addRow("Alternating Colour 1", (Component)this.makeColourControl(KTSDocketPrinter.Properties.ALTERNATING_COLOUR_1, "alternating colour 1"));
        builder.addRow("Alternating Colour 2", (Component)this.makeColourControl(KTSDocketPrinter.Properties.ALTERNATING_COLOUR_2, "alternating colour 2"));
        holder.add(builder.getPanel());
        return holder;
    }

    private JComponent makeColourControl(PropertiedObject.Property colourProp, String tipSuffix) {
        LimitedColorSelector comp = this.setupAnyColorSelector(colourProp, true);
        comp.setToolTipText("Sets the colour for representing " + tipSuffix);
        return comp;
    }

    private JPanel createTimerPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JSpinner comp = this.setupIntSpinner(KTSDocketPrinter.Properties.AUTO_CLOSE_TIME, 1, 0, Integer.MAX_VALUE, 10, 5);
        comp.setToolTipText("Sets the time in seconds for automatically closing a docket once all items are marked as completed.");
        builder.addRow("Auto Close Time (sec)", (Component)comp);
        builder.addRow("Show Time", (Component)this.setupComboBox(KTSDocketPrinter.Properties.SHOW_TIME, GlazedLists.eventListOf((Object[])KTSShowTime.values())));
        return builder.getPanel();
    }

    private JPanel createFontPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Header", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.HEADER_ATTRIBUTES, " header panels"));
        builder.addRow("Course", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.COURSE_ATTRIBUTES, " courses"));
        builder.addRow("Items", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.ITEM_ATTRIBUTES, " line items"));
        builder.addRow("Plusses", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.PLUS_ATTRIBUTES, " item plusses"));
        builder.addRow("Minuses", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.MINUS_ATTRIBUTES, " item minuses"));
        builder.addRow("Options", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.OPTIONS_ATTRIBUTES, " item options"));
        builder.addRow("Notes", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.NOTES_ATTRIBUTES, " item notes"));
        builder.addRow("Notifier", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.NOTIFY_ATTRIBUTES, " notify printers"));
        builder.addRow("Notifier Items", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.NOTIFY_ITEMS_ATTRIBUTES, " notify printer items"));
        builder.addRow("Groups", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.GROUP_ATTRIBUTES, " group headers"));
        builder.addRow("Summary Groups", (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)KTSDocketPrinter.Properties.SUMMARY_GROUP_ATTRIBUTES, " summary groups"));
        return builder.getPanel();
    }

    private JComponent makeFontControl(PropertiedObject.Property<FontAttributes> prop, String tipSuffix) {
        FontAttributesEditor comp = new FontAttributesEditor();
        this.getBindings().createBinding(prop, (Object)comp, "attributes");
        comp.setToolTipText("Sets the font size, in points, for " + tipSuffix);
        comp.setSizeIconsAndText(null, "+", null, "-");
        return comp;
    }

    private JPanel createSummaryPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComponent comp = this.setupCheckBox(KTSDocketPrinter.Properties.ENABLE_SUMMARY_PANEL);
        builder.addRow("Enable Summary Panel", (Component)comp);
        this.summaryColumnsSpinner = this.setupIntSpinner(KTSDocketPrinter.Properties.SUMMARY_PANEL_COLUMNS, 1, 1, 19, 1, 4);
        builder.addRow("Summary Panel Columns", (Component)this.summaryColumnsSpinner);
        comp = this.setupComboBox(KTSDocketPrinter.Properties.SUMMARY_ITEM_SORT_STRATEGY, GlazedLists.eventListOf((Object[])KTSSummarySortingStrategyType.values()));
        builder.addRow("Sort Items By", (Component)comp);
        comp = this.setupComboBox(KTSDocketPrinter.Properties.SUMMARY_GROUP_STRATEGY, GlazedLists.eventListOf((Object[])KTSSummaryGroupingStrategyType.values()));
        builder.addRow("Categorise Items By", (Component)comp);
        comp = this.setupComboBox(KTSDocketPrinter.Properties.SUMMARY_ITEM_GROUP_STRATEGY, GlazedLists.eventListOf((Object[])VirtualPrinter.PrepDocketGrouping.getGroupingTypes().toArray()));
        builder.addRow("Group Items By", (Component)comp);
        return builder.getPanel();
    }

    private JPanel createPropertiesPanel() {
        return new KTSPropertyPanel();
    }

    @Override
    public void refresh() {
        this.userNameValidator.setCurrentEditPrinter((KTSDocketPrinter)this.getObject());
        this.activePrintDevices.getReadWriteLock().writeLock().lock();
        this.activePrintDevices.clear();
        this.activePrintDevices.add(null);
        this.activePrintDevices.addAll((Collection)PersistenceManager.getObjectList(PhysicalPrintDevice.class, (String)Query.select(PhysicalPrintDevice.class).active(PhysicalPrintDevice.class).orderBy(PhysicalPrintDevice.Properties.LABEL).toString()));
        this.activePrintDevices.getReadWriteLock().writeLock().unlock();
        BasicEventList stylesheets = new BasicEventList();
        stylesheets.addAll((Collection)ConfigStyleSheet.getAllStyleSheets());
        NullableEventComboBoxModel model = new NullableEventComboBoxModel((EventList)stylesheets, (Object)"None");
        if (this.getObject() != null) {
            model.setSelectedItem(((KTSDocketPrinter)this.getObject()).getRedemptionStyleSheet());
        }
        this.redemptionStyleSheetComboBox.setModel(model);
        super.refresh();
        this.validate();
        this.repaint();
    }

    @Override
    public void setObject(KTSDocketPrinter printer) {
        super.setObject(printer);
        this.userNameValidator.setCurrentEditPrinter((KTSDocketPrinter)this.getObject());
        this.propertyPanel.setPrinter(printer);
        this.refresh();
    }

    private void constrainSummaryColumnValues(Integer maxColumns) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.summaryColumnsSpinner.getModel();
        model.setMaximum(maxColumns);
        Integer summaryColumns = (Integer)this.summaryColumnsSpinner.getValue();
        if (summaryColumns.compareTo(maxColumns) > 0) {
            this.summaryColumnsSpinner.setValue(maxColumns);
        }
    }
}

