/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kts;

import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.CompositeObjectEditor;
import officemate.screens.setup.devices.kts.KTSDocketPrinterEditor;
import officemate.screens.setup.devices.kts.KTSKeyMapEditor;
import officemate.screens.setup.devices.kts.KTSMilestoneEditor;
import officemate.screens.setup.devices.kts.KTSWebFaceEditor;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.gui.binding.BindingHelper;

class KTSDocketPrinterSuperEditor
extends CompositeObjectEditor<KTSDocketPrinter> {
    private KTSDocketPrinterEditor printerEditor;
    private KTSMilestoneEditor milestonesEditor;
    private KTSKeyMapEditor keyMapEditor;
    private KTSWebFaceEditor webFaceEditor;

    KTSDocketPrinterSuperEditor(BasicOfficeMateState state) {
        this.setupComponents(state);
    }

    @Override
    public void setObject(KTSDocketPrinter printer) {
        super.setObject(printer);
        this.printerEditor.setObject(printer);
        this.milestonesEditor.setObject(printer);
        this.keyMapEditor.setObject(printer);
        this.webFaceEditor.setObject(printer);
    }

    @Override
    public void saveObject() {
        this.printerEditor.saveObject();
        this.milestonesEditor.saveObject();
        this.keyMapEditor.saveObject();
        this.webFaceEditor.saveObject();
        super.saveObject();
    }

    private void setupComponents(BasicOfficeMateState state) {
        this.printerEditor = new KTSDocketPrinterEditor((BindingHelper<KTSDocketPrinter>)this.getBindings(), this.getListener());
        this.milestonesEditor = new KTSMilestoneEditor((BindingHelper<KTSDocketPrinter>)this.getBindings(), this.getListener());
        this.keyMapEditor = new KTSKeyMapEditor(state);
        this.webFaceEditor = new KTSWebFaceEditor((BindingHelper<KTSDocketPrinter>)this.getBindings(), this.getListener());
        this.addObjectEditorTab("Printer", this.printerEditor);
        this.addObjectEditorTab("Milestones", this.milestonesEditor);
        this.addObjectEditorTabUnsafe("Key Map", this.keyMapEditor);
        this.addObjectEditorTab("Customer Order Display", this.webFaceEditor);
    }
}

