/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kts;

import au.com.ordermate.glazedlists.GlazedListUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSProperties;
import ordermate.database.hardware.physical.kts.KTSProperty;
import ordermate.database.hardware.physical.kts.KTSPropertyType;

class KTSPropertyPanel
extends JPanel
implements ActionListener {
    private PersistentObjectTable<KTSProperty> table;
    private EventList<KTSProperty> eventList;
    private JButton addButton;
    private JButton removeButton;
    private KTSDocketPrinter printer;

    KTSPropertyPanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.eventList = new BasicEventList();
        EventList types = GlazedLists.eventListOf((Object[])KTSPropertyType.values());
        EventList props = GlazedLists.eventList((Collection)KTSProperties.getAllProperties());
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn(new EditablePropertyColumnFormat(KTSProperty.Properties.KEY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(props))));
        format.addColumn(new EditablePropertyColumnFormat(KTSProperty.Properties.TYPE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(types))));
        format.addColumn(new EditablePropertyColumnFormat(KTSProperty.Properties.VALUE));
        this.table = new PersistentObjectTable<KTSProperty>(this.eventList, format);
        this.add(this.table, "Center");
        JPanel buttonPanel = new JPanel();
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        this.add((Component)buttonPanel, "North");
    }

    public void setPrinter(KTSDocketPrinter printer) {
        this.printer = printer;
        GlazedListUtils.setAsList(this.eventList, (Collection)printer.getKtsProperties());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.printer.createKtsProperty(KTSPropertyType.Show, "New Property");
        } else if (e.getSource() == this.removeButton && this.table.getSelectedObject() != null) {
            this.printer.removeKtsProperty(this.table.getSelectedObject());
        }
        this.setPrinter(this.printer);
    }
}

