/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.payoffprinter;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.devices.payoffprinter.PayoffPrinterEditor;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.PayoffPrinter;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.reports.table.ColumnFormat;

public class PayoffPrinterState
extends AbstractEditableTableState<PayoffPrinter> {
    private EventList<String> unitTypes;
    private static final String TYPE_NAME = "Payoff Printers";

    public PayoffPrinterState() {
        super(TYPE_NAME, null, "View, add and configure payoff printers.");
        DeferredSaveStrategy strategy = new DeferredSaveStrategy((Refreshable)this);
        this.setSaveStrategy(strategy);
        this.buildFinanceUnitTypes();
    }

    @Override
    protected ObjectEditor<PayoffPrinter> createObjectEditor() {
        return new PayoffPrinterEditor(this.unitTypes);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
    }

    @Override
    protected TableStateCentralArea<PayoffPrinter> createCentralArea() {
        PersistentObjectTable<PayoffPrinter> table = new PersistentObjectTable<PayoffPrinter>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(PayoffPrinter.Properties.TERMINAL).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)Terminal.getAllTerminals()), false))), new EditablePropertyColumnFormat(PayoffPrinter.Properties.VIRTUAL_PRINTER).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters()), false))), new EditablePropertyColumnFormat(PayoffPrinter.Properties.UNIT_TYPE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.unitTypes, false))).setFormatter(new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                String temp = (String)obj;
                temp = StringUtils.underscoreToDisplayable((String)temp);
                temp = StringUtils.eachWordToUpperCase((String)temp);
                toAppendTo.append(temp);
                return toAppendTo;
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        }), new EditablePropertyColumnFormat(PayoffPrinter.Properties.DOCKET_LOCATION).setCustomEditor(new DefaultCellEditor(new JTextField()))}));
        table.setPropertiesToBulkExclude(new PropertiedObject.Property[0]);
        return table;
    }

    @Override
    protected Class<PayoffPrinter> getDisplayingType() {
        return PayoffPrinter.class;
    }

    private void buildFinanceUnitTypes() {
        this.unitTypes = new BasicEventList();
        this.unitTypes.add((Object)"ALL");
        for (Object unitType : FinanceUnit.getAllUnitTypes()) {
            String temp = (String)unitType;
            temp = StringUtils.underscoreToDisplayable((String)temp);
            this.unitTypes.add((Object)temp);
        }
    }
}

