/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.printerlocations;

import au.com.ordermate.glazedlists.GlazedListUtils;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.PrinterLocation;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

class PrinterLocationEditor
extends AbstractObjectEditor<PrinterLocation> {
    private JComboBox printerGroup;
    private JComboBox virtualPrinter;
    private JComboBox accType;
    private JComboBox location;
    private EventList<VirtualPrinter> virtualPrinters;
    private EventList<PrinterGroup> printerGroups;
    private EventList<TerminalLocation> locations;

    public PrinterLocationEditor(EventList<String> accountTypesList) {
        this.setupComponents(accountTypesList);
    }

    private void setupComponents(EventList<String> accountTypesList) {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.printerGroups = GlazedLists.eventList((Collection)PrinterGroup.getPrinterGroups());
        EventComboBoxModel groupModel = new EventComboBoxModel(this.printerGroups);
        this.printerGroup = this.setupComboBox(PrinterLocation.Properties.PRINTER_GROUP, (ComboBoxModel)groupModel, (Validator)new NotEmptyValidator());
        builder.addRow("Printer Group", (Component)this.printerGroup);
        this.virtualPrinters = GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters());
        EventComboBoxModel model = new EventComboBoxModel(this.virtualPrinters);
        this.virtualPrinter = this.setupComboBox(PrinterLocation.Properties.VIRTUAL_PRINTER, (ComboBoxModel)model, (Validator)new NotEmptyValidator());
        builder.addRow("Virtual Printer", (Component)this.virtualPrinter);
        this.accType = this.setupComboBox(PrinterLocation.Properties.ACCOUNT_TYPE, (ComboBoxModel)new ListComboBoxModel(accountTypesList), (Validator)new NotEmptyValidator());
        builder.addRow("Account Type", (Component)this.accType);
        this.locations = GlazedLists.eventList((Collection)TerminalLocation.getTerminalLocations());
        this.location = this.setupComboBox(PrinterLocation.Properties.TERMINAL_LOCATION, (ComboBoxModel)new EventComboBoxModel(this.locations), (Validator)new NotEmptyValidator());
        builder.addRow("Location", (Component)this.location);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void setObject(PrinterLocation toEdit) {
        GlazedListUtils.setAsList(this.virtualPrinters, (Collection)VirtualPrinter.getAllPrinters());
        GlazedListUtils.setAsList(this.printerGroups, (Collection)PrinterGroup.getPrinterGroups());
        GlazedListUtils.setAsList(this.locations, (Collection)TerminalLocation.getTerminalLocations());
        super.setObject(toEdit);
        this.setDefaultOptionIfNull(this.printerGroup);
        this.setDefaultOptionIfNull(this.virtualPrinter);
        this.setDefaultOptionIfNull(this.accType);
        this.setDefaultOptionIfNull(this.location);
    }

    private void setDefaultOptionIfNull(JComboBox combo) {
        if (combo.getSelectedIndex() == -1 && combo.getModel().getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }
}

