/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.scales;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PortParity;
import ordermate.database.hardware.physical.scales.Scales;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.ObjectValidator;
import org.jdesktop.beansbinding.Validator;

class ScalesEditor
extends AbstractObjectEditor<Scales>
implements ActionListener {
    private static final String[] PRESETS = new String[]{"Custom", "CAS - ECR2", "Wedderburn - Hugin ECR"};
    private EventList<Terminal> terminals;
    private JComboBox autoFillCombo;
    private JSpinner querySpin;
    private JSpinner startSpin;
    private JSpinner endSpin;
    private JSpinner statusSpin;
    private JTextField portSpeedField;

    ScalesEditor() {
    }

    @Override
    protected void init() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Label", (Component)this.setupTextField(Scales.Properties.LABEL, 20, (Validator)new NotEmptyValidator()));
        builder.addRow("Port", (Component)this.setupTextField(Scales.Properties.PORT, 10, (Validator)new NotEmptyValidator()));
        builder.addRow("Port Type", (Component)this.setupComboBox(Scales.Properties.PORT_TYPE, new DefaultComboBoxModel<String>(new String[]{"Serial", "Parallel", "None"}), (Validator)new NotEmptyValidator()));
        this.portSpeedField = this.setupTextField(Scales.Properties.PORT_SPEED, 10, (Validator)new NotEmptyValidator());
        builder.addRow("Port Speed", (Component)this.portSpeedField);
        builder.addRow("Flow Control", (Component)this.setupComboBox(Scales.Properties.FLOW_CONTROL, new DefaultComboBoxModel<String>(new String[]{"None", "XonXoff", "DtrDsr", "Delay"}), (Validator)new NotEmptyValidator()));
        builder.addRow("Parity", (Component)this.setupComboBox(Scales.Properties.PARITY, new DefaultComboBoxModel<PortParity>(PortParity.values()), (Validator)new ObjectValidator(PortParity.class, false)));
        builder.addRow("Data Bits", (Component)this.setupComboBox(Scales.Properties.DATA_BITS, new DefaultComboBoxModel<Integer>(new Integer[]{6, 7, 8}), (Validator)new ObjectValidator(Integer.class, false)));
        builder.addRow("Stop Bits", (Component)this.setupComboBox(Scales.Properties.STOP_BITS, new DefaultComboBoxModel<Integer>(new Integer[]{0, 1, 2}), (Validator)new ObjectValidator(Integer.class, false)));
        this.terminals = new BasicEventList();
        builder.addRow("Terminal", (Component)this.setupComboBox(Scales.Properties.HOST, this.terminals));
        builder.addRow("Retail Mode", (Component)this.setupCheckBox(Scales.Properties.RETAIL_MODE), "Uncheck this box to require confirmation for each weight measured.");
        this.autoFillCombo = new JComboBox<String>(PRESETS);
        this.autoFillCombo.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.autoFillCombo);
        builder.addRow("Auto-Fill", (Component)this.autoFillCombo, "Prefill values from known scales.");
        this.querySpin = this.setupIntSpinner(Scales.Properties.QUERY_BYTE, -1, -1, 255, 57, 5);
        builder.addRow("Query Char", (Component)this.querySpin);
        this.startSpin = this.setupIntSpinner(Scales.Properties.START_BYTE, -1, -1, 255, 57, 5);
        builder.addRow("Start Char", (Component)this.startSpin);
        this.endSpin = this.setupIntSpinner(Scales.Properties.END_BYTE, -1, -1, 255, 57, 5);
        builder.addRow("End Char", (Component)this.endSpin);
        this.statusSpin = this.setupIntSpinner(Scales.Properties.STATUS_BYTE, -1, -1, 255, 57, 5);
        builder.addRow("Status Char", (Component)this.statusSpin);
        this.add(builder.getPanel());
    }

    @Override
    public void refresh() {
        if (this.terminals != null) {
            this.terminals.clear();
            this.terminals.addAll((Collection)Terminal.getAllTerminals());
        }
        super.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.autoFillCombo) {
            this.doAutoFill(String.valueOf(this.autoFillCombo.getSelectedItem()));
        }
    }

    private void doAutoFill(String value) {
        if (PRESETS[1].equals(value)) {
            this.querySpin.setValue(87);
            this.startSpin.setValue(2);
            this.endSpin.setValue(13);
            this.statusSpin.setValue(63);
            this.portSpeedField.setText("9600");
        } else if (PRESETS[2].equals(value)) {
            this.querySpin.setValue(5);
            this.startSpin.setValue(-1);
            this.endSpin.setValue(13);
            this.statusSpin.setValue(-1);
            this.portSpeedField.setText("2400");
        }
    }
}

