/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.virtualprinter;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.DocketSorting;
import ordermate.database.hardware.PrinterSummary;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.FileExistsValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class VirtualPrinterEditor
extends AbstractObjectEditor<VirtualPrinter> {
    private FieldPanelBuilder builder;
    private JComboBox printersField;
    private List<PhysicalPrintDevice> printerList;
    private PrinterSelector notifyField;
    private JCheckBox autoPrint;
    private JCheckBox itemiseNotifiersCheck;
    private JTextField prepDocketFileLocation;
    private JComboBox prepGroupField;
    private JComboBox prepSortField;
    private JComboBox prepGroupingSelector;
    private JComboBox prepSortingSelector;
    private JComboBox recGroupingSelector;
    private JComboBox recSortingSelector;
    private EventList<DocketGrouping> groupings;
    private EventList<DocketSorting> sortings;
    private PrinterSummaryManager printerSumMgr;

    public VirtualPrinterEditor() {
        this.setLayout(new BorderLayout());
        this.builder = new FieldPanelBuilder();
        JTextField nameField = new JTextField(20);
        Binding nameBinding = this.getBindings().createBinding(VirtualPrinter.Properties.LABEL, (Object)nameField, "text");
        nameBinding.setValidator((Validator)new NotEmptyValidator());
        this.builder.addRow("Name", (Component)nameField);
        this.printersField = new JComboBox();
        this.printerList = new ArrayList<PhysicalPrintDevice>();
        this.getBindings().createJComboBoxBinding(VirtualPrinter.Properties.PRINT_DEVICE, this.printersField, this.printerList);
        this.builder.addRow("Physical Printer", (Component)this.printersField);
        ComponentUtils.setupComboBox((JComboBox)this.printersField);
        Set sorts = SortingStrategyVendor.getSortingStrategiesIDSet();
        this.prepSortField = new JComboBox();
        this.getBindings().createJComboBoxBinding(VirtualPrinter.Properties.DOCKET_SORTING_STRATEGY, this.prepSortField, new ArrayList(sorts));
        this.builder.addRow("Sorting Strategy", (Component)this.prepSortField);
        ComponentUtils.setupComboBox((JComboBox)this.prepSortField);
        this.prepGroupField = new JComboBox();
        this.getBindings().createJComboBoxBinding(VirtualPrinter.Properties.PREP_DOCKET_GROUPING, this.prepGroupField, VirtualPrinter.PrepDocketGrouping.getGroupingTypes());
        this.builder.addRow("Prep Docket Grouping", (Component)this.prepGroupField);
        ComponentUtils.setupComboBox((JComboBox)this.prepGroupField);
        this.autoPrint = new JCheckBox();
        this.autoPrint.setToolTipText("Auto print the pay off docket; if not set, ask to choose one.");
        this.getBindings().createBinding(VirtualPrinter.Properties.AUTO_PRINT_PAYOFF, (Object)this.autoPrint, "selected");
        this.builder.addRow("Auto print pay off", (Component)this.autoPrint);
        this.prepDocketFileLocation = this.setupTextField(VirtualPrinter.Properties.PREP_DOCKET_FILE, 50, (Validator)new FileExistsValidator().setAllowEmpty(true));
        this.builder.addRow("Prep docket file", (Component)this.prepDocketFileLocation);
        this.printerSumMgr = new PrinterSummaryManager();
        this.builder.addRow("Printer Summary", (Component)this.printerSumMgr.getPrinterSummaryCombo());
        this.itemiseNotifiersCheck = new JCheckBox();
        this.itemiseNotifiersCheck.setToolTipText("Print out items from the notified printer.");
        this.getBindings().createBinding(VirtualPrinter.Properties.ITEMISED_NOTIFIERS, (Object)this.itemiseNotifiersCheck, "selected");
        this.builder.addRow("Itemise Notifiers", (Component)this.itemiseNotifiersCheck);
        this.notifyField = new PrinterSelector();
        this.builder.addSeparator("Notify Printers");
        this.builder.addRow("  ", (Component)this.notifyField);
        this.builder.addSeparator("Custom Prep Grouping : will override old Prep Grouping if set");
        this.groupings = new BasicEventList();
        this.prepGroupingSelector = this.setupComboBox(VirtualPrinter.Properties.DOCKET_GROUPING_PREP, this.groupings);
        this.builder.addRow("Prep Docket Grouping", (Component)this.prepGroupingSelector);
        this.sortings = new BasicEventList();
        this.prepSortingSelector = this.setupComboBox(VirtualPrinter.Properties.DOCKET_SORTING_PREP, this.sortings);
        this.builder.addRow("Prep Docket Sorting", (Component)this.prepSortingSelector);
        this.recGroupingSelector = this.setupComboBox(VirtualPrinter.Properties.DOCKET_GROUPING_REC, this.groupings);
        this.builder.addRow("Receipt Docket Grouping", (Component)this.recGroupingSelector);
        this.recSortingSelector = this.setupComboBox(VirtualPrinter.Properties.DOCKET_SORTING_REC, this.sortings);
        this.builder.addRow("Receipt Docket Sorting", (Component)this.recSortingSelector);
        this.add((Component)this.builder.getPanel(), "Center");
    }

    protected PrinterSummaryManager getPrinterSummaryManager() {
        return this.printerSumMgr;
    }

    @Override
    public void saveObject() {
        VirtualPrinter vPrinter = (VirtualPrinter)this.getBindings().getObject();
        PhysicalPrintDevice printer = (PhysicalPrintDevice)this.printersField.getSelectedItem();
        vPrinter.setPrintDevice(printer);
        vPrinter.setNotifyPrinters(this.notifyField.getSelectedPrinters());
        this.printerSumMgr.save();
        super.saveObject();
    }

    @Override
    public void setObject(VirtualPrinter toEdit) {
        GlazedListUtils.setAsList(this.groupings, (Collection)PersistenceManager.getObjectList(DocketGrouping.class, (String)Query.select(DocketGrouping.class).toString()));
        GlazedListUtils.setAsList(this.sortings, (Collection)PersistenceManager.getObjectList(DocketSorting.class, (String)Query.select(DocketSorting.class).toString()));
        this.groupings.add(0, null);
        this.sortings.add(0, null);
        this.printerList.clear();
        this.printerList.addAll(PhysicalPrintDevice.getAllActivePrintDevices());
        this.notifyField.setPrinters(toEdit.getNotifyPrinters());
        this.printerSumMgr.setUp(toEdit);
        this.getBindings().setObject((Object)toEdit);
        if (toEdit.getPrintDevice() == null && !this.printerList.isEmpty()) {
            this.printersField.setSelectedIndex(0);
        }
    }

    class PrinterSummaryManager {
        private JComboBox printerSummaryCombo = new JComboBox();
        private EventComboBoxModel printerSummaryModel;
        private JCheckBoxCellRenderer printerSummaryJCheckBoxCellRenderer;
        private List<String> allAccountTypes;
        private List<PrinterSummary> allPrinterSummaries;
        private List<PrinterSummary> oldPrinterSummaries;
        private VirtualPrinter virtualPrinter;

        public PrinterSummaryManager() {
            this.printerSummaryCombo.setName("Printer Summary");
            OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.printerSummaryCombo);
            this.printerSummaryJCheckBoxCellRenderer = JCheckBoxCellRenderer.install((JComboBox)this.printerSummaryCombo, (String)"");
            ComponentUtils.setupComboBox((JComboBox)this.printerSummaryCombo);
            this.allAccountTypes = new ArrayList<String>();
            for (AccountType at : AccountType.getTypes()) {
                this.allAccountTypes.add(StringUtils.underscoreToDisplayable((String)at.toString()));
            }
            this.printerSummaryModel = new EventComboBoxModel(GlazedLists.eventList(this.allAccountTypes));
            this.printerSummaryCombo.setModel(this.printerSummaryModel);
        }

        private void setUp() {
            this.setUp(this.virtualPrinter);
        }

        public void setUp(Object toEdit) {
            VirtualPrinter vPrinter = (VirtualPrinter)toEdit;
            this.allPrinterSummaries = PrinterSummary.getAllPrinterSummaries();
            ArrayList<String> selected = new ArrayList<String>();
            this.oldPrinterSummaries = new ArrayList<PrinterSummary>();
            for (PrinterSummary ps : this.allPrinterSummaries) {
                if (vPrinter == null || !vPrinter.equals((Object)ps.getVirtualPrinter())) continue;
                String temp = ps.getAccountType();
                temp = StringUtils.underscoreToDisplayable((String)temp);
                selected.add(temp);
                this.oldPrinterSummaries.add(ps);
            }
            this.printerSummaryJCheckBoxCellRenderer.setSelectedElements(selected);
            this.virtualPrinter = vPrinter;
        }

        protected LinkedHashSet getChecked() {
            return this.printerSummaryJCheckBoxCellRenderer.getSelectedElements();
        }

        protected List<PrinterSummary> getOldPrinterSummaries() {
            return this.oldPrinterSummaries;
        }

        public void save() {
            this.saveAddedPrinterSummaries();
            this.deleteRemovedPrinterSummaries();
            this.setUp();
        }

        private void saveAddedPrinterSummaries() {
            for (Object s : this.getChecked()) {
                String element = (String)s;
                boolean wasFound = false;
                for (PrinterSummary ps : this.getOldPrinterSummaries()) {
                    String temp = ps.getAccountType();
                    if (element.compareToIgnoreCase(temp = StringUtils.underscoreToDisplayable((String)temp)) != 0) continue;
                    wasFound = true;
                }
                if (wasFound) continue;
                PrinterSummary newPS = new PrinterSummary();
                newPS.setVirtualPrinter(this.virtualPrinter);
                element = element.toUpperCase();
                element = element.replace(' ', '_');
                newPS.setAccountType(element);
                newPS.save();
            }
        }

        private void deleteRemovedPrinterSummaries() {
            for (PrinterSummary ps : this.getOldPrinterSummaries()) {
                String temp = ps.getAccountType();
                temp = StringUtils.underscoreToDisplayable((String)temp);
                boolean wasFound = false;
                for (Object s : this.getChecked()) {
                    String element = (String)s;
                    if (temp.compareToIgnoreCase(element) != 0) continue;
                    wasFound = true;
                }
                if (wasFound) continue;
                ps.delete();
            }
        }

        public JComboBox getPrinterSummaryCombo() {
            return this.printerSummaryCombo;
        }

        public EventComboBoxModel getPrinterSummaryModel() {
            return this.printerSummaryModel;
        }

        public JCheckBoxCellRenderer getPrinterSummaryJCheckBoxCellRenderer() {
            return this.printerSummaryJCheckBoxCellRenderer;
        }

        public List<String> getAllAccountTypes() {
            return this.allAccountTypes;
        }

        public List<PrinterSummary> getAllPrinterSummaries() {
            return this.allPrinterSummaries;
        }
    }

    protected static class PrinterSelector
    extends Box {
        private Map<VirtualPrinter, JCheckBox> printerMap = new HashMap<VirtualPrinter, JCheckBox>();

        public PrinterSelector() {
            super(1);
        }

        public void setPrinters(List selectedPrinters) {
            this.removeAll();
            this.printerMap = new HashMap<VirtualPrinter, JCheckBox>();
            ArrayList allPrinters = new ArrayList();
            VirtualPrinter.clearAllPrinterCacheList();
            allPrinters.addAll(VirtualPrinter.getAllPrinters());
            for (VirtualPrinter p : allPrinters) {
                JCheckBox checkBox = new JCheckBox(p.getLabel(), selectedPrinters.contains(p));
                this.add(checkBox);
                this.printerMap.put(p, checkBox);
            }
        }

        public List<VirtualPrinter> getSelectedPrinters() {
            ArrayList<VirtualPrinter> selected = new ArrayList<VirtualPrinter>();
            Set<VirtualPrinter> keySet = this.printerMap.keySet();
            for (VirtualPrinter p : keySet) {
                JCheckBox checkBox = this.printerMap.get(p);
                if (!checkBox.isSelected()) continue;
                selected.add(p);
            }
            return selected;
        }
    }
}

