/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.combosetup;

import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryGroupSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.menu.combosetup.BuyXGetYFreeComboEditor;
import officemate.screens.setup.menu.combosetup.ComboEditorGroupPanel;
import officemate.screens.setup.menu.combosetup.ComboOptionalPropertyEditor;
import officemate.screens.setup.menu.combosetup.ComboState;
import officemate.screens.setup.menu.combosetup.FlatPriceComboEditor;
import officemate.screens.setup.menu.combosetup.FreeItemComboEditor;
import officemate.screens.setup.menu.combosetup.PlainComboEditor;
import officemate.screens.setup.menu.combosetup.PriceAdjustmentComboEditor;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryAdjustmentCombo;
import ordermate.database.inventory.combos.InventoryBuyXGetYFreeCombo;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryFlatPriceCombo;
import ordermate.database.inventory.combos.InventoryFreeItemCombo;
import ordermate.database.inventory.combos.InventorySimpleCombo;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.beansbinding.Validator;

class ComboEditor
extends AbstractObjectEditor<InventoryCombo> {
    private FieldPanelBuilder builder = new FieldPanelBuilder();
    private JComboBox comboType;
    private JCheckBox showInMenuCheck;
    private JTextField comboName;
    private JTextField comboShortName;
    private JCheckBox autoCreate;
    private MenuGroupEditor menuGroupEditor;
    private JPanel optionalPropsEditorPanel;
    private ComboOptionalPropertyEditor optionalPropsEditor;
    private ComboEditorGroupPanel comboGroupPanel;
    private EventList<InventoryComboGroup> comboGroupEvent = GlazedLists.eventList(new ArrayList());
    private JPanel mainPanel;
    public Signal<InventoryCombo, InventoryCombo, ?, ?, ?> replaceComboSignal = Signals.createSignal(InventoryCombo.class, (String)"toBeReplace", InventoryCombo.class, (String)"toReplace");
    private boolean comboTypeActionEnabled = false;

    public ComboEditor(BasicOfficeMateState state) {
        this.setupComponents(state);
    }

    private void setupComponents(BasicOfficeMateState state) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.builder.addSeparator("Combo Settings");
        this.comboType = new JComboBox<ComboType>(ComboType.values());
        this.comboType.setName("ComboType");
        this.builder.addRow("Type", (Component)this.comboType);
        this.comboName = this.setupTextField(InventoryCombo.Properties.LABEL, 20, (Validator)new NotEmptyValidator());
        this.comboName.setName("comboName");
        this.builder.addRow("Name", (Component)this.comboName, "The name of the combo");
        this.comboShortName = this.setupTextField(InventoryCombo.Properties.SHORT_NAME, 20);
        this.comboShortName.setName("comboShortName");
        this.builder.addRow("Short Name", (Component)this.comboShortName, "Abbreviated name");
        this.showInMenuCheck = new JCheckBox();
        JPanel menuGroupPanel = new JPanel(new BorderLayout());
        menuGroupPanel.add((Component)this.showInMenuCheck, "West");
        this.menuGroupEditor = new MenuGroupEditor();
        menuGroupPanel.add((Component)this.menuGroupEditor, "Center");
        this.showInMenuCheck.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboEditor.this.updateMenuGroupPanel();
            }
        });
        this.builder.addRow("Show in menu", (Component)menuGroupPanel, "The menu group this combo belongs to");
        this.autoCreate = this.setupCheckBox(InventoryCombo.Properties.AUTO_CREATE);
        this.builder.addRow("Auto Create", (Component)this.autoCreate, "Should this combo be automatically created when its items are ordered");
        JCheckBox upgradable = this.setupCheckBox(InventoryCombo.Properties.UPGRADEABLE);
        this.builder.addRow("Upgradeable", (Component)upgradable, "Is the use prompted to upgrade an item in this combo?");
        this.builder.addSeparator("Combo Groups");
        this.comboGroupPanel = new ComboEditorGroupPanel(state, this.comboGroupEvent);
        this.builder.addRow("Combo Groups", (Component)this.comboGroupPanel);
        this.builder.addSeparator("Combo Price Settings");
        this.mainPanel.add(this.builder.getPanel());
        this.add(this.mainPanel);
        this.comboType.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboEditor.this.comboTypeActionEnabled) {
                    if (ComboEditor.this.comboType.getSelectedItem().equals(ComboType.FLAT_PRICE)) {
                        ComboEditor.this.changeObjectTo(InventoryFlatPriceCombo.class);
                    } else if (ComboEditor.this.comboType.getSelectedItem().equals(ComboType.ADJUST_PRICE)) {
                        ComboEditor.this.changeObjectTo(InventoryAdjustmentCombo.class);
                    } else if (ComboEditor.this.comboType.getSelectedItem().equals(ComboType.FREE_ITEM)) {
                        ComboEditor.this.changeObjectTo(InventoryFreeItemCombo.class);
                    } else if (ComboEditor.this.comboType.getSelectedItem().equals(ComboType.X_GET_Y_FREE)) {
                        ComboEditor.this.changeObjectTo(InventoryBuyXGetYFreeCombo.class);
                    } else if (ComboEditor.this.comboType.getSelectedItem().equals(ComboType.SIMPLE)) {
                        ComboEditor.this.changeObjectTo(InventorySimpleCombo.class);
                    }
                }
            }
        });
    }

    private void changeObjectTo(Class toChangeTo) {
        if (this.getObject() == null || ((InventoryCombo)this.getObject()).getClass().equals(toChangeTo) || ((InventoryCombo)this.getObject()).isPersistent()) {
            return;
        }
        try {
            InventoryCombo newCombo = (InventoryCombo)toChangeTo.newInstance();
            InventoryCombo currentCombo = (InventoryCombo)this.getObject();
            boolean labelNotSet = this.comboName.getText().isEmpty() || this.comboName.getText().equals("No Label Set");
            try {
                if (labelNotSet) {
                    this.comboName.setText("Unknown");
                }
                this.saveObject();
            }
            catch (Exception e) {
                OfficeMate.LOG.warn("Error saving combo type before change", (Throwable)e);
            }
            if (!labelNotSet) {
                newCombo.setLabel(currentCombo.getLabel());
            }
            newCombo.setShortName(currentCombo.getShortName());
            newCombo.setMenuGroup(currentCombo.getMenuGroup());
            newCombo.setAutoCreate(currentCombo.getAutoCreate());
            newCombo.setProfile(currentCombo.getProfile());
            newCombo.setMenuGroup(currentCombo.getMenuGroup());
            newCombo.setGroups(currentCombo.getGroups());
            newCombo.setUpgradeable(currentCombo.isUpgradeable());
            newCombo.setGroups(this.comboGroupEvent);
            this.setObject(newCombo);
            this.replaceComboSignal.emit((Object)currentCombo, (Object)newCombo);
            this.revalidate();
            this.repaint();
            this.gotSubObjectEdited();
        }
        catch (Exception e) {
            OfficeMate.LOG.warn("Error changing combo type", (Throwable)e);
        }
    }

    private void setupInventorySimpleCombo() {
        this.optionalPropsEditor = new PlainComboEditor();
        this.comboType.setSelectedItem(ComboType.SIMPLE);
        this.optionalPropsEditorPanel = new JPanel();
    }

    private void setupInventoryBuyXGetYFreeCombo() {
        this.optionalPropsEditor = new BuyXGetYFreeComboEditor();
        FieldPanelBuilder buyXGetYFreeBuilder = new FieldPanelBuilder();
        buyXGetYFreeBuilder.addRow("Combo Strategy", (Component)this.optionalPropsEditor);
        this.optionalPropsEditorPanel = buyXGetYFreeBuilder.getPanel();
        this.mainPanel.add(this.optionalPropsEditorPanel);
        this.comboType.setSelectedItem(ComboType.X_GET_Y_FREE);
    }

    private void setupInventoryFlatPriceCombo() {
        this.optionalPropsEditor = new FlatPriceComboEditor();
        FieldPanelBuilder flatPriceBuilder = new FieldPanelBuilder();
        flatPriceBuilder.addRow("Flat Price", (Component)this.optionalPropsEditor);
        this.optionalPropsEditorPanel = flatPriceBuilder.getPanel();
        this.mainPanel.add(this.optionalPropsEditorPanel);
        this.comboType.setSelectedItem(ComboType.FLAT_PRICE);
    }

    private void setupInventoryAdjustmentCombo() {
        this.optionalPropsEditor = new PriceAdjustmentComboEditor();
        FieldPanelBuilder adjComboBuilder = new FieldPanelBuilder();
        adjComboBuilder.addRow("Price Adjustment", (Component)this.optionalPropsEditor);
        this.optionalPropsEditorPanel = adjComboBuilder.getPanel();
        this.mainPanel.add(this.optionalPropsEditorPanel);
        this.comboType.setSelectedItem(ComboType.ADJUST_PRICE);
    }

    private void setupInventoryFreeItemCombo() {
        this.optionalPropsEditor = new FreeItemComboEditor(this.comboGroupEvent);
        FieldPanelBuilder freeItemBuilder = new FieldPanelBuilder();
        freeItemBuilder.addRow("Free Item Group", (Component)this.optionalPropsEditor);
        this.optionalPropsEditorPanel = freeItemBuilder.getPanel();
        this.mainPanel.add(this.optionalPropsEditorPanel);
        this.comboType.setSelectedItem(ComboType.FREE_ITEM);
    }

    private void updateMenuGroupPanel() {
        if (this.showInMenuCheck.isSelected()) {
            this.menuGroupEditor.setVisible(true);
        } else {
            this.menuGroupEditor.setVisible(false);
            this.menuGroupEditor.setObject(null);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setObject(InventoryCombo toEdit) {
        this.showInMenuCheck.setSelected(toEdit.getMenuGroup() != null);
        this.updateMenuGroupPanel();
        this.menuGroupEditor.setObject(toEdit.getMenuGroup());
        if (this.optionalPropsEditor != null) {
            this.optionalPropsEditor.objectEdited.disconnect((Object)this);
            this.optionalPropsEditor = null;
        }
        if (this.optionalPropsEditorPanel != null) {
            this.mainPanel.remove(this.optionalPropsEditorPanel);
        }
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.comboGroupEvent, toEdit.getGroups());
        this.comboTypeActionEnabled = false;
        try {
            switch (3.$SwitchMap$ordermate$database$inventory$combos$ComboType[toEdit.getType().ordinal()]) {
                case 1: {
                    this.setupInventoryFlatPriceCombo();
                    this.optionalPropsEditor.setObject(toEdit);
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.setupInventoryFreeItemCombo();
                    this.optionalPropsEditor.setObject(toEdit);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.setupInventoryAdjustmentCombo();
                    this.optionalPropsEditor.setObject(((InventoryAdjustmentCombo)toEdit).getPriceAdjustment());
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.setupInventoryBuyXGetYFreeCombo();
                    this.optionalPropsEditor.setObject(toEdit);
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.setupInventorySimpleCombo();
                    break;
                }
                ** default:
lbl37:
                // 1 sources

                break;
            }
        }
        finally {
            this.comboTypeActionEnabled = true;
        }
        this.optionalPropsEditor.objectEdited.connect((Object)this, "gotSubObjectEdited");
        this.comboType.setEnabled(toEdit.isPersistent() == false);
        this.comboGroupPanel.setObject(toEdit);
        super.setObject(toEdit);
    }

    public void gotSubObjectEdited() {
        this.firePropertyChange("guiValid", true, false);
    }

    @Override
    public void saveObject() {
        ((InventoryCombo)this.getObject()).setMenuGroup((InventoryGroup)this.menuGroupEditor.getObject());
        if (this.optionalPropsEditor != null) {
            switch (((InventoryCombo)this.getObject()).getType()) {
                case FLAT_PRICE: 
                case FREE_ITEM: 
                case X_GET_Y_FREE: {
                    this.optionalPropsEditor.saveObject();
                    break;
                }
                case ADJUST_PRICE: {
                    ((InventoryAdjustmentCombo)this.getObject()).setPriceAdjustment((InventoryPriceAdjustment)this.optionalPropsEditor.getObject());
                    break;
                }
            }
        }
        super.saveObject();
    }

    public void save() {
        this.comboGroupPanel.save();
    }

    public void cancel() {
        this.comboGroupPanel.cancel();
    }

    public void mainEditorCancel() {
        this.comboGroupPanel.mainEditorCancel();
    }

    public void mainEditorOk() {
        this.comboGroupPanel.mainEditorOk();
    }

    @Override
    public boolean isGuiValid() {
        return super.isGuiValid() & (this.optionalPropsEditor == null || this.optionalPropsEditor.isSubGuiValid());
    }

    private class MenuGroupEditor
    extends AbstractObjectEditor<InventoryGroup>
    implements ActionListener {
        private JButton searchBtn;
        private JTextField groupName;

        private MenuGroupEditor() {
        }

        @Override
        protected void init() {
            this.groupName = this.setupTextField(InventoryGroup.Properties.LABEL, 20);
            this.groupName.setEditable(false);
            this.groupName.setToolTipText("The menu group this combo belongs to");
            this.add(this.groupName);
            this.searchBtn = new JButton(IconLoader.get((String)"/ordermate/images/search22.png"));
            this.searchBtn.addActionListener(this);
            this.add(this.searchBtn);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.searchBtn) {
                InventoryGroupSearchPanel searchPanel = new InventoryGroupSearchPanel(ComboState.getCurrentProfile());
                SearchDialog searchDialog = new SearchDialog(OfficeMate.getApplicationFrame(), searchPanel, "Find Menu Section...");
                searchDialog.setVisible(true);
                if (!searchDialog.wasCancelled()) {
                    InventoryGroup groupFound = (InventoryGroup)searchDialog.getFoundObject();
                    this.setObject(groupFound);
                }
            }
        }

        @Override
        public void setObject(InventoryGroup toEdit) {
            if (toEdit == null) {
                this.groupName.setText("");
            }
            super.setObject(toEdit);
        }
    }
}

