/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.coupon;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import officemate.components.AbstractObjectEditor;
import officemate.components.ListEditor;
import officemate.screens.setup.menu.menusection.TriggerPropertyEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.coupon.ComboCoupon;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.coupon.PeriodUnit;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.gui.FieldPanelBuilder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.swingx.JXDatePicker;

public class InventoryCouponEditor
extends AbstractObjectEditor<InventoryCoupon> {
    private JLabel localLabel;
    private JLabel stateLabel;
    private JLabel createdLabel;
    private Binding useExistingItemsBinding;
    private JCheckBox comboUseExistingItems;
    private ListEditor<AbstractTrigger> triggerEditor;
    private ListEditor<AbstractTrigger> autoTriggerEditor;

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder builder = new FieldPanelBuilder(5);
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        builder.addRow("Label", (Component)this.setupTextField(InventoryCoupon.Properties.LABEL, 30), "The label of the coupon");
        JScrollPane scrolly = new JScrollPane(this.setupTextArea(InventoryCoupon.Properties.DESCRIPTION, 30, 3, null));
        builder.addRow("Description", (Component)scrolly, "A html compatible description of the coupon");
        this.localLabel = new JLabel();
        builder.addRow("Is local?", (Component)this.localLabel, "Local if this coupon was made at this store.");
        this.stateLabel = new JLabel();
        builder.addRow("Active/Deleted", (Component)this.stateLabel, "Active or Deleted if revoked");
        this.createdLabel = new JLabel();
        builder.addRow("Created", (Component)this.createdLabel, "The date when this coupon was created");
        builder.addSeparator("Rules");
        builder.addRow("Sequence", (Component)this.setupIntSpinner(InventoryCoupon.Properties.SEQUENCE, 1, 0, Integer.MAX_VALUE, 1, 10), "A lower sequence will make a coupon appear before a higher sequence.");
        builder.addRow("Maximum Uses", (Component)this.setupIntSpinner(InventoryCoupon.Properties.MAX_USES, 1, -1, null, 1, 10), "The maximum number of times a coupon may be used, -1 implies no maximum.");
        builder.addRow("Maximum Uses Per Period", (Component)this.setupIntSpinner(InventoryCoupon.Properties.MAX_USES_PER_PERIOD, 1, -1, null, 1, 10), "The maximum number of times in a period a coupon may be used, -1 implies no maximum.");
        EventList units = GlazedLists.eventListOf((Object[])PeriodUnit.values());
        builder.addRow("Period Unit", (Component)this.setupComboBox(InventoryCoupon.Properties.PERIOD_UNIT, units), "If Max Per Period is set, defines the period in which the limitation will be assessed");
        builder.addRow("Mutually Exclusive", (Component)this.setupCheckBox(InventoryCoupon.Properties.MUT_EX), "If checked, cannot be used on an account with other coupons.");
        builder.addRow("Auto Assign to customers?", (Component)this.setupCheckBox(InventoryCoupon.Properties.AUTO_ASSIGN), "If checked and local, will automatically assign this coupon to new customers.");
        this.comboUseExistingItems = this.setupCheckBox(ComboCoupon.Properties.USE_EXISTING_ITEMS);
        builder.addRow("Use Existing Items", (Component)this.comboUseExistingItems);
        this.useExistingItemsBinding = this.getBindings().findBinding(ComboCoupon.Properties.USE_EXISTING_ITEMS);
        builder.addSeparator("Dates");
        JXDatePicker picker = this.setupDatePicker(InventoryCoupon.Properties.COMMENCES);
        picker.setFormats(new String[]{"dd/MM/yyyy HH:mm"});
        builder.addRow("Commences", (Component)picker, "The date when this coupon becomes active.");
        picker = this.setupDatePicker(InventoryCoupon.Properties.EXPIRES);
        picker.setFormats(new String[]{"dd/MM/yyyy HH:mm"});
        builder.addRow("Expires", (Component)picker, "The date when this coupon becomes inactive");
        builder.addSeparator("Triggers");
        builder.addRow("Trigger Activation", (Component)this.setupComboBox(InventoryCoupon.Properties.TRIGGER_ACTIVATION_STRATEGY, GlazedLists.eventListOf((Object[])new TriggerActivationStrategy[]{TriggerActivationStrategy.ALL_TRIGGERS, TriggerActivationStrategy.ANY_TRIGGERS})));
        this.triggerEditor = this.createTriggerEditor();
        builder.addRow("Triggers", this.triggerEditor);
        builder.addRow("Auto Gen Trigger Activation", (Component)this.setupComboBox(InventoryCoupon.Properties.AUTO_TRIGGER_ACTIVATION_STRATEGY, GlazedLists.eventListOf((Object[])new TriggerActivationStrategy[]{TriggerActivationStrategy.ALL_TRIGGERS, TriggerActivationStrategy.ANY_TRIGGERS})));
        this.autoTriggerEditor = this.createTriggerEditor();
        builder.addRow("Auto Gen Triggers", this.autoTriggerEditor);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void setObject(InventoryCoupon coupon) {
        boolean showUseExistingItems = coupon instanceof ComboCoupon;
        this.getBindings().setBindEnabled(showUseExistingItems, this.useExistingItemsBinding, ComboCoupon.Properties.USE_EXISTING_ITEMS);
        this.comboUseExistingItems.setEnabled(showUseExistingItems);
        if (!showUseExistingItems) {
            this.comboUseExistingItems.setSelected(false);
        }
        super.setObject(coupon);
        this.localLabel.setText(coupon.isLocal() ? "Local" : "Head Office");
        this.stateLabel.setText(SystemState.ACTIVE_STATE.equals((Object)coupon.getSystemState()) ? "Active" : "DELETED");
        this.createdLabel.setText(String.valueOf(coupon.getCreated()));
        this.triggerEditor.setList(coupon.getTriggers());
        this.autoTriggerEditor.setList(coupon.getAutoGenTriggers());
    }

    @Override
    public void saveObject() {
        this.removeDuplicateTriggers(this.triggerEditor.getList(), ((InventoryCoupon)this.getObject()).getTriggers());
        this.removeDuplicateAutoTriggers(this.autoTriggerEditor.getList(), ((InventoryCoupon)this.getObject()).getAutoGenTriggers());
        super.saveObject();
        ((InventoryCoupon)this.getObject()).updateTerms();
    }

    private void removeDuplicateTriggers(List<AbstractTrigger> newTriggers, List<AbstractTrigger> existingTriggers) {
        for (AbstractTrigger trigger : newTriggers) {
            ((InventoryCoupon)this.getObject()).addTrigger(trigger);
            existingTriggers.remove(trigger);
        }
        for (AbstractTrigger trigger : existingTriggers) {
            ((InventoryCoupon)this.getObject()).removeTrigger(trigger);
        }
    }

    private void removeDuplicateAutoTriggers(List<AbstractTrigger> newTriggers, List<AbstractTrigger> existingTriggers) {
        for (AbstractTrigger trigger : newTriggers) {
            ((InventoryCoupon)this.getObject()).addAutoGenTrigger(trigger);
            existingTriggers.remove(trigger);
        }
        for (AbstractTrigger trigger : existingTriggers) {
            ((InventoryCoupon)this.getObject()).removeAutoGenTrigger(trigger);
        }
    }

    public void setEditable(boolean value) {
        this.triggerEditor.setEnabled(value);
        for (Binding ding : this.getBindings().getAllBindings()) {
            ((JComponent)ding.getTargetObject()).setEnabled(value);
        }
    }

    protected TriggerPropertyEditor createTriggerEditor() {
        return new TriggerPropertyEditor();
    }
}

