/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.ordermate.util.image.IconLoader;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.swingx.JXHeader;

public abstract class AbstractMenuImportExportScreen
extends JPanel
implements ActionListener {
    protected static final String INTERLINE = "10px";
    protected final JTextField fileName;
    protected final JButton selectFileButton;
    protected final JButton importButton;
    protected final JProgressBar progress;
    protected final JTextArea progressInfo;
    protected final JButton exportButton;

    protected abstract int layoutImportComponents(PanelBuilder var1, FormLayout var2, CellConstraints var3, int var4);

    protected abstract int layoutExportComponents(PanelBuilder var1, FormLayout var2, CellConstraints var3, int var4);

    protected abstract String getFileExtension();

    protected abstract String getFileDescription();

    public AbstractMenuImportExportScreen(Action runImportAction, Action runExportAction) {
        this.setLayout(new BorderLayout());
        JXHeader instructionsHeading = new JXHeader("", "Use this screen to create and update your menu from an external CSV file. Select the Menu Profile, Price Level and Stock Area that imported items will affect. Select 'Check barcodes' to ensure that item barcodes are valid.", (Icon)IconLoader.get((String)"/officemate/images/xferFileToProfile.png"));
        Box box = new Box(1);
        box.add((Component)instructionsHeading);
        box.add(new JSeparator());
        this.add((Component)box, "North");
        FormLayout layout = new FormLayout("right:pref, 4px, left:pref, 10px,right:pref, 4px, left:pref, 10px,right:pref, 4px, left:pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        CellConstraints cc = new CellConstraints();
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        int row = 1;
        JLabel fileLabel = new JLabel("File:");
        this.fileName = new JTextField(50);
        this.fileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractMenuImportExportScreen.this.checkButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractMenuImportExportScreen.this.checkButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractMenuImportExportScreen.this.checkButtons();
            }
        });
        this.selectFileButton = new JButton("...");
        this.selectFileButton.addActionListener(this);
        builder.add((Component)fileLabel, cc.xy(1, row));
        builder.add((Component)this.fileName, cc.xyw(3, row, 7));
        builder.add((Component)this.selectFileButton, cc.xy(11, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        builder.addSeparator("Import", cc.xyw(1, row += 2, 11));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        row += 2;
        row = this.layoutImportComponents(builder, layout, cc, row);
        this.importButton = new JButton();
        this.importButton.setHorizontalTextPosition(0);
        this.importButton.setVerticalTextPosition(3);
        this.importButton.setAction(runImportAction);
        builder.add((Component)this.importButton, cc.xy(5, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        builder.addSeparator("Export", cc.xyw(1, row += 2, 11));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        row += 2;
        row = this.layoutExportComponents(builder, layout, cc, row);
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.exportButton = new JButton();
        this.exportButton.setHorizontalTextPosition(0);
        this.exportButton.setVerticalTextPosition(3);
        this.exportButton.setAction(runExportAction);
        builder.add((Component)this.exportButton, cc.xy(5, row += 2));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.progressInfo = new JTextArea(2, 150);
        this.progressInfo.setEditable(false);
        this.progressInfo.setWrapStyleWord(true);
        this.progressInfo.setLineWrap(true);
        builder.add((Component)this.progressInfo, cc.xyw(1, row += 2, 11));
        JPanel wrapper = new JPanel();
        wrapper.add(builder.getPanel());
        this.add((Component)wrapper, "Center");
        this.progress = new JProgressBar();
        this.add((Component)this.progress, "South");
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.fileName.getText().isEmpty()) {
            this.importButton.setEnabled(false);
            this.exportButton.setEnabled(false);
        } else {
            this.importButton.setEnabled(true);
            this.exportButton.setEnabled(true);
        }
    }

    public void progressIndeterminate(final boolean indeterminate) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractMenuImportExportScreen.this.progress.setIndeterminate(indeterminate);
                }
            });
        } else {
            this.progress.setIndeterminate(indeterminate);
        }
    }

    public JProgressBar getProgress() {
        return this.progress;
    }

    public void setImportEnabled(boolean isEnabled) {
        this.importButton.setEnabled(isEnabled);
    }

    public void setExportEnabled(boolean isEnabled) {
        this.exportButton.setEnabled(isEnabled);
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectFileButton) {
            JFileChooser chooser = new JFileChooser(this.fileName.getText());
            chooser.addChoosableFileFilter(new FileNameExtensionFilter(this.getFileDescription(), this.getFileExtension()));
            int returnValue = chooser.showOpenDialog(this);
            if (returnValue == 0) {
                this.fileName.setText(chooser.getSelectedFile().toString());
                this.setImportEnabled(true);
                this.setExportEnabled(true);
            }
        }
    }
}

