/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.bytecode.opencsv.CSVReader;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.ProgressBarConnector;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.integration.jaxb.exceptions.NoContentException;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import officemate.OfficeMate;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.setup.menu.menuimport.ImportExportMenuScreen;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.stock.StockArea;
import ordermate.database.users.AllPermissions;
import ordermate.integration.csv.CsvMenuExportTask;
import ordermate.integration.csv.CsvMenuImportTask;
import ordermate.jaxb.exporter.handlers.online.InventoryProfilerExporter;

public class ImportExportMenuState
extends BasicOfficeMateState {
    private ImportExportMenuScreen screen = new ImportExportMenuScreen((Action)((Object)new RunMenuImport()), (Action)((Object)new RunMenuExportCSV()));

    public ImportExportMenuState() {
        super("CSV Menu Import/Export", AllPermissions.IMPORT_MENU, "Import/Export the menu from/to external files");
        this.setScreenPanel(this.screen);
    }

    @Override
    public void onStart() {
        this.screen.refresh();
    }

    private void displayProgressMessage(final String message) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImportExportMenuState.this.screen.setMessage(message);
            }
        });
    }

    private boolean checkFileName(String fileName) {
        if (fileName.isEmpty()) {
            JOptionPane errorPane = new JOptionPane("You must choose a file to export.", 0);
            JDialog dialog = errorPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Invalid export file");
            dialog.setVisible(true);
            return false;
        }
        return true;
    }

    private void handleException(final String message, Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportExportMenuState.this.screen.setMessage(message);
            }
        });
        this.screen.progressIndeterminate(false);
        OfficeMate.LOG.error(message, (Throwable)e);
    }

    protected class RunMenuExportXML
    extends BasicAction {
        protected RunMenuExportXML() {
            super("XML Export", (Icon)IconLoader.get((String)"/ordermate/images/left_arrow.png"), "Starts the menu export process");
        }

        public void actionPerformed(ActionEvent event) {
            final String fileName = ImportExportMenuState.this.screen.getFileName();
            final InventoryProfile profile = ImportExportMenuState.this.screen.getProfile();
            final PriceLevel priceLevel = ImportExportMenuState.this.screen.getPriceLevel();
            if (!ImportExportMenuState.this.checkFileName(fileName)) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImportExportMenuState.this.displayProgressMessage("Exporting " + fileName);
                        InventoryProfilerExporter exporter = new InventoryProfilerExporter(profile, Collections.singletonList(priceLevel));
                        ImportExportMenuState.this.screen.progressIndeterminate(true);
                        exporter.export(new File(fileName));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImportExportMenuState.this.screen.progressIndeterminate(false);
                                ImportExportMenuState.this.screen.getProgress().setValue(ImportExportMenuState.this.screen.getProgress().getMaximum());
                            }
                        });
                    }
                    catch (NoContentException ex) {
                        ImportExportMenuState.this.handleException("No items in " + profile + " for the pricelevel " + priceLevel, (Exception)((Object)ex));
                    }
                    catch (Exception e) {
                        ImportExportMenuState.this.handleException("Error export menu", e);
                    }
                }
            }).start();
        }
    }

    public class RunMenuExportCSV
    extends BasicAction {
        public RunMenuExportCSV() {
            super("Start Export", (Icon)IconLoader.get((String)"/ordermate/images/left_arrow.png"), "Starts the menu export process");
        }

        public void actionPerformed(ActionEvent arg0) {
            final String fileName = ImportExportMenuState.this.screen.getFileName();
            final InventoryProfile profile = ImportExportMenuState.this.screen.getProfile();
            final PriceLevel priceLevel = ImportExportMenuState.this.screen.getPriceLevel();
            final StockArea stockArea = ImportExportMenuState.this.screen.getStockArea();
            final InventoryGroup group = ImportExportMenuState.this.screen.getInventoryGroup();
            final boolean generate = ImportExportMenuState.this.screen.isIdentifierGenerationSelected();
            final String target = ImportExportMenuState.this.screen.getVersion();
            final boolean meta = ImportExportMenuState.this.screen.isMetadataSelected();
            if (!ImportExportMenuState.this.checkFileName(fileName)) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImportExportMenuState.this.displayProgressMessage("Exporting " + fileName);
                        CsvMenuExportTask task = new CsvMenuExportTask(profile, priceLevel, group, stockArea, fileName, generate, target, meta);
                        ProgressBarConnector.connect((JProgressBar)ImportExportMenuState.this.screen.getProgress(), (Task)task);
                        task.runLocal();
                        ImportExportMenuState.this.displayProgressMessage("Done Exporting " + fileName);
                        ImportExportMenuState.this.setUpdateRequired();
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        ImportExportMenuState.this.handleException("Error export to file:" + message, e);
                    }
                }
            });
            t.start();
        }
    }

    public class RunMenuImport
    extends BasicAction {
        public RunMenuImport() {
            super("Start Import", (Icon)IconLoader.get((String)"/ordermate/images/right_arrow.png"), "Starts the menu import process");
        }

        public void actionPerformed(ActionEvent arg0) {
            final String fileName = ImportExportMenuState.this.screen.getFileName();
            final InventoryProfile profile = ImportExportMenuState.this.screen.getProfile();
            final PriceLevel priceLevel = ImportExportMenuState.this.screen.getPriceLevel();
            final boolean checkBarcodes = ImportExportMenuState.this.screen.getCheckBarcodes();
            final StockArea stockArea = ImportExportMenuState.this.screen.getStockArea();
            if (fileName.isEmpty() || !fileName.endsWith(".csv")) {
                JOptionPane errorPane = new JOptionPane("You must choose a CSV file to import.", 0);
                JDialog dialog = errorPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Invalid import file");
                dialog.setVisible(true);
                return;
            }
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ImportExportMenuState.this.screen.setMessage("Importing " + fileName);
                            }
                        });
                        FileInputStream fin = new FileInputStream(fileName);
                        InputStreamReader inReader = new InputStreamReader((InputStream)fin, "UTF-8");
                        List csvData = null;
                        try (CSVReader reader = new CSVReader((Reader)inReader);){
                            csvData = reader.readAll();
                        }
                        CsvMenuImportTask task = new CsvMenuImportTask(csvData, profile, priceLevel, stockArea, checkBarcodes);
                        ProgressBarConnector.connect((JProgressBar)ImportExportMenuState.this.screen.getProgress(), (Task)task);
                        task.runLocal();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ImportExportMenuState.this.screen.setMessage("Done Importing " + fileName);
                                ImportExportMenuState.this.setUpdateRequired();
                            }
                        });
                    }
                    catch (Exception e) {
                        final String message = e.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImportExportMenuState.this.screen.setMessage("ERROR IMPORTING FILE:" + message);
                            }
                        });
                        OfficeMate.LOG.error("Error exporting", (Throwable)e);
                    }
                }
            });
            t.start();
        }
    }
}

