/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.sql.queries.SelectQuery;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import officemate.adminkit.dialogs.AdminDialog;
import officemate.adminkit.search.SearchPanelList;
import ordermate.database.inventory.InventoryItem;

public class MenuItemSelector
extends AdminDialog {
    private InventoryItemSearchPanelList mainPanel;
    private List<InventoryItem> selectedInventoryItems = new ArrayList<InventoryItem>();

    public MenuItemSelector(Frame owner) {
        super(owner, "Please select the menu items you like to export...", true);
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.mainPanel = new InventoryItemSearchPanelList();
        super.setMainComponent(this.mainPanel);
        this.setMinimumSize(new Dimension(300, 400));
        this.pack();
    }

    @Override
    public boolean start() {
        boolean result = super.start();
        this.selectedInventoryItems = result ? this.mainPanel.getSelectedObjects() : this.mainPanel.getSelectedObjects();
        return result;
    }

    public List<InventoryItem> getSelectedInventoryItems() {
        return this.selectedInventoryItems;
    }

    public void refreshComponentsWithData() {
        if (this.selectedInventoryItems != null) {
            this.selectedInventoryItems.clear();
        }
        if (this.mainPanel != null) {
            this.mainPanel.clearSelection();
        }
    }

    private class InventoryItemSearchPanelList
    extends SearchPanelList<InventoryItem> {
        private PropertiedObject.Property[] searchFields;

        private InventoryItemSearchPanelList() {
            this.searchFields = new PropertiedObject.Property[]{InventoryItem.Properties.LABEL};
        }

        @Override
        public InventoryItem getSelectedObject(Long id) {
            return (InventoryItem)PersistenceManager.getByID((long)id, this.getSearchClass());
        }

        @Override
        public Class<InventoryItem> getSearchClass() {
            return InventoryItem.class;
        }

        @Override
        protected SelectQuery createQuery() {
            String[] fields = new String[]{"inventory_item"};
            SelectQuery query = new SelectQuery(fields);
            return query;
        }

        @Override
        public List<PropertiedObject.Property> getAllPropertiesForSearchFilter() {
            return Arrays.asList(this.searchFields);
        }
    }
}

