/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuimport;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.setup.menu.menuimport.XMLImportExportScreen;
import ordermate.OrderMate;
import ordermate.database.users.AllPermissions;
import ordermate.jaxb.exporter.handlers.posdatabase.PosMenuExportTask;
import ordermate.jaxb.exporter.handlers.posdatabase.PosMenuImportTask;

public class XMLImportExportState
extends BasicOfficeMateState {
    private XMLImportExportScreen screen;

    public XMLImportExportState() {
        super("XML Menu Import / Export", AllPermissions.IMPORT_MENU, "Import/Export the menu from/to external files");
    }

    @Override
    protected void init() {
        super.init();
        this.screen = new XMLImportExportScreen((Action)((Object)new XMLImportAction()), (Action)((Object)new XMLExportAction()));
        this.setScreenPanel(this.screen);
    }

    private void doExport() {
        final PosMenuExportTask exportTask = new PosMenuExportTask();
        exportTask.setExportMode(this.screen.getSelectedExportMode());
        exportTask.setStockAreas(this.screen.getSelectedStockAreas());
        exportTask.setStockSuppliers(this.screen.getSelectedSuppliers());
        exportTask.setMenuGroups(this.screen.getSelectedInventoryGroups());
        exportTask.setProfiles(this.screen.getSelectedInventoryProfiles());
        exportTask.setPriceLevels(this.screen.getSelectedPriceLevels());
        exportTask.setDiscounts(this.screen.getSelectedMenuDiscounts());
        exportTask.setCombos(this.screen.getSelectedMenuCombos());
        if (this.screen.getSelectedMenuItems() != null) {
            exportTask.setItems(this.screen.getSelectedMenuItemsAsSet());
        }
        exportTask.setFileName(this.screen.getFileName());
        this.screen.progress.setIndeterminate(true);
        this.screen.setExportEnabled(false);
        new SwingWorker<Exception, Object>(){

            @Override
            protected Exception doInBackground() throws Exception {
                try {
                    exportTask.runLocal();
                }
                catch (Exception ex) {
                    return ex;
                }
                return null;
            }

            @Override
            protected void done() {
                ((XMLImportExportState)XMLImportExportState.this).screen.progress.setIndeterminate(false);
                XMLImportExportState.this.screen.setExportEnabled(true);
                super.done();
                try {
                    Exception ex = (Exception)super.get();
                    if (ex == null) {
                        Dialogs.showInfoDialog("Exported Successfully", "Successfully exported to :" + XMLImportExportState.this.screen.getFileName());
                    } else {
                        Dialogs.showErrorDialog("An error occurred exporting", "Something unexpected occurred when exporting the file,\nthe file has not been successfully exported.  Check the logs for more information.");
                        OrderMate.LOG.error("Exception performing xml export", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    Dialogs.showErrorDialog("Error", "Could not perform export");
                    OrderMate.LOG.error("Error getting result from export task", (Throwable)ex);
                }
            }
        }.execute();
    }

    private void doImport() {
        final PosMenuImportTask task = new PosMenuImportTask();
        task.setFilename(this.screen.getFileName());
        this.screen.progress.setIndeterminate(true);
        this.screen.setImportEnabled(false);
        new SwingWorker<Exception, Object>(){

            @Override
            protected Exception doInBackground() throws Exception {
                try {
                    task.run();
                }
                catch (Exception ex) {
                    return ex;
                }
                return null;
            }

            @Override
            protected void done() {
                ((XMLImportExportState)XMLImportExportState.this).screen.progress.setIndeterminate(false);
                XMLImportExportState.this.screen.setImportEnabled(true);
                super.done();
                try {
                    Exception ex = (Exception)super.get();
                    if (ex == null) {
                        File resultsFile = new File("C:\\temp\\menuImportResult.csv");
                        if (resultsFile.exists()) {
                            boolean showResults = Dialogs.showChoiceDialog("Imported Successfully", "Successfully imported from :" + XMLImportExportState.this.screen.getFileName() + "\r\nWould you like to see the results?");
                            if (showResults) {
                                Desktop.getDesktop().edit(resultsFile);
                            }
                        } else {
                            Dialogs.showInfoDialog("Imported Successfully", "Successfully imported from :" + XMLImportExportState.this.screen.getFileName());
                        }
                    } else {
                        Dialogs.showErrorDialog("An error occurred importing", "Something unexpected occurred when importing the file,\nthe file has not been successfully imported.  Check the logs for more information.");
                        OrderMate.LOG.error("Exception performing xml import", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    Dialogs.showErrorDialog("Error", "Could not perform import");
                    OrderMate.LOG.error("Error getting result from import task", (Throwable)ex);
                }
            }
        }.execute();
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.screen.refresh();
    }

    private class XMLExportAction
    extends BasicAction {
        public XMLExportAction() {
            super("Export", (Icon)IconLoader.get((String)"/ordermate/images/left_arrow.png"), "Starts the menu export process");
        }

        public void actionPerformed(ActionEvent e) {
            XMLImportExportState.this.screen.setExportEnabled(false);
            XMLImportExportState.this.doExport();
        }
    }

    private class XMLImportAction
    extends BasicAction {
        public XMLImportAction() {
            super("Import", (Icon)IconLoader.get((String)"/ordermate/images/right_arrow.png"), "Starts the menu import process");
        }

        public void actionPerformed(ActionEvent e) {
            XMLImportExportState.this.screen.setImportEnabled(false);
            XMLImportExportState.this.doImport();
            XMLImportExportState.this.screen.setImportEnabled(true);
        }
    }
}

