/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.renderers.TreeNodeListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.ItemSummaryQueries;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.users.PermissionGroup;

public class MenuItemSetupSearcher
extends ObjectPropertySearch<ItemSummary> {
    private static final int MAX_GROUPS_TO_DISPLAY = 20;
    protected final EventList<InventoryGroup> allGroups = new BasicEventList();
    protected final EventList allProfiles = new BasicEventList();
    protected final EventList<PriceLevel> allPriceLevels = new BasicEventList();
    protected final EventList allCategories = new BasicEventList();
    protected final EventList allPrinterGroups = new BasicEventList();
    protected final EventList allSizes = new BasicEventList();
    private final ComboSearchField profileSearchField;
    private final ComboSearchField priceLevelsField;
    private final ComboSearchField groupSearchField;
    private ItemSummaryQueries.ItemSummarySearcher searcher = (ItemSummaryQueries.ItemSummarySearcher)super.getPropertySearcher();

    public MenuItemSetupSearcher() {
        super(ItemSummary.class);
        this.reaquireSearchOptions();
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        refresh.setEnabled(false);
        this.profileSearchField = new ComboSearchField("Profile", this.searcher.getProfileFilter(), false, (Action)new BasicAction(){

            public void actionPerformed(ActionEvent e) {
                MenuItemSetupSearcher.this.refresh();
                MenuItemSetupSearcher.this.reloadInventoryGroups();
            }
        }, this.allProfiles);
        this.groupSearchField = new ComboSearchField("Menu Section", this.searcher.getMenuSectionFilter(), true, (Action)refresh, this.allGroups);
        this.groupSearchField.setRenderer((ListCellRenderer)new TreeNodeListCellRenderer());
        this.groupSearchField.getGuiComponent().setMaximumRowCount(20);
        this.addSearchField((SearchGuiField)this.groupSearchField);
        if (this.getCurrentProfile().getProfileGroups(true).size() > 0) {
            this.groupSearchField.setSelectedObject(this.getCurrentProfile().getProfileGroups(true).get(0));
        }
        this.addSearchField((SearchGuiField)new StringSearchField("Item name", this.searcher.getItemNameFilter(), null));
        this.addSearchField((SearchGuiField)this.profileSearchField);
        this.priceLevelsField = new ComboSearchField("Price Level", this.searcher.getPriceLevelFilter(), false, (Action)refresh, this.allPriceLevels);
        this.addSearchField((SearchGuiField)this.priceLevelsField);
        this.addSearchField((SearchGuiField)new ComboSearchField("Category", this.searcher.getCategoryFilter(), true, (Action)refresh, this.allCategories));
        this.addSearchField((SearchGuiField)new ComboSearchField("Printer", this.searcher.getPrinterGroupFilter(), true, (Action)refresh, this.allPrinterGroups));
        this.addSearchField((SearchGuiField)new ComboSearchField("Size", this.searcher.getSizeFilter(), true, (Action)refresh, this.allSizes));
        refresh.setEnabled(true);
    }

    public ComboSearchField getPriceLevelsField() {
        return this.priceLevelsField;
    }

    @Override
    protected ObjectQuerySearcher<ItemSummary> constructPropertySearcher() {
        return this.createQueries().createSearcher();
    }

    protected ItemSummaryQueries createQueries() {
        return new ItemSummaryQueries();
    }

    public InventoryProfile getCurrentProfile() {
        InventoryProfile currentProfile = null;
        if (this.profileSearchField != null) {
            currentProfile = (InventoryProfile)this.profileSearchField.getSelectedObject();
        }
        if (currentProfile == null) {
            Vector inventoryProfiles = InventoryProfile.getAllProfiles();
            if (inventoryProfiles.size() != 0) {
                currentProfile = (InventoryProfile)inventoryProfiles.get(0);
            }
            if (this.profileSearchField != null) {
                this.profileSearchField.setSelectedObject((Object)currentProfile);
            }
        }
        return currentProfile;
    }

    public PriceLevel getSelectedPriceLevel() {
        PriceLevel level = (PriceLevel)this.priceLevelsField.getSelectedObject();
        if (level == null && this.allPriceLevels.size() > 0) {
            level = (PriceLevel)this.allPriceLevels.get(0);
            this.priceLevelsField.setSelectedObject((Object)level);
        }
        return level;
    }

    @Override
    public void reaquireSearchOptions() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allProfiles, InventoryProfile.getAllProfiles());
        ArrayList priceLevels = new ArrayList(PriceLevel.getAllPriceLevels());
        Collections.reverse(priceLevels);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPriceLevels, priceLevels);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allCategories, InventoryCategory.getAllCategories());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPrinterGroups, PrinterGroup.getPrinterGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allSizes, InventoryItemSize.getAllSizes());
        this.reloadInventoryGroups();
    }

    public InventoryGroup getSelectedGroup() {
        Object selectedGroup;
        Object object = selectedGroup = this.groupSearchField != null ? this.groupSearchField.getSelectedObject() : null;
        if (selectedGroup instanceof InventoryGroup) {
            return (InventoryGroup)selectedGroup;
        }
        return null;
    }

    protected void reloadInventoryGroups() {
        if (this.groupSearchField == null) {
            return;
        }
        PermissionGroup permission = GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup();
        this.searcher.getPermissionFilter().setSearchValue((Object)permission);
        List profileGroups = new ArrayList();
        if (this.getCurrentProfile() != null) {
            profileGroups = this.getCurrentProfile().getModifiableProfileGroups(permission);
        }
        this.allGroups.clear();
        for (InventoryGroup group : profileGroups) {
            this.allGroups.add((Object)group);
        }
        InventoryGroup selectedGroup = this.getSelectedGroup();
        this.groupSearchField.setListData(this.allGroups);
        if (this.getCurrentProfile() != null && selectedGroup != null && !this.getCurrentProfile().equals((Object)selectedGroup.getProfile()) && !profileGroups.isEmpty()) {
            this.groupSearchField.setSelectedObject(profileGroups.get(0));
        } else {
            this.groupSearchField.setSelectedObject((Object)"Any");
        }
    }
}

