/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.OfficeMate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.renderers.TreeNodeListCellRenderer;
import officemate.components.strategy.AuditableDeferredSaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.strategy.StrategySaveCancelListener;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.EditMultiple;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditableColourColumnFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AbstractDialogCellEditor;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.ColorCellEditor;
import officemate.components.tableformat.renderers.ColorCellRenderer;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.renderers.TextDialogCellEditor;
import officemate.components.tableformat.textformat.DisplayableListFormat;
import officemate.screens.setup.menu.menuitemsetup.BarcodeObjectEditor;
import officemate.screens.setup.menu.menuitemsetup.HTMLPreviewEditor;
import officemate.screens.setup.menu.menuitemsetup.MenuItemSetupSearcher;
import officemate.screens.setup.menu.menuitemsetup.MenuSetup;
import officemate.screens.setup.menu.menuitemsetup.MinusObjectEditor;
import officemate.screens.setup.menu.menuitemsetup.OptionGroupLinkEditor;
import officemate.screens.setup.menu.menuitemsetup.TaxCodeSelectionEditor;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.option.DefaultOptionEditor;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.plus.DefaultPlusEditor;
import officemate.screens.setup.menu.menuitemsetup.multi.ItemSummaryEditMultiple;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.labels.ShelfLabelsReport;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.table.TableColumnExt;

public class MenuItemSetupState
extends AbstractEditableTableState<ItemSummary>
implements StrategySaveCancelListener {
    private static final List<PropertiedObject.Property> PROPS_TO_EXCLUDE_MULTI_EDIT = new ArrayList<PropertiedObject.Property>(){
        {
            this.add(ItemSummary.Properties.MINUSES);
            if (SystemProperty.getInstance().isStockControlEnabled()) {
                this.add(ItemSummary.Properties.INGREDIENTS);
            }
            this.add(ItemSummary.Properties.BARCODES);
        }
    };
    private final EventList<InventoryProfile> allProfiles = GlazedLists.eventList((Collection)InventoryProfile.getAllProfiles());
    private final EventList<PriceLevel> allPriceLevels = GlazedLists.eventList((Collection)PriceLevel.getAllPriceLevels());
    private final EventList<InventoryGroup> allGroups = new BasicEventList();
    private final EventList<InventoryItemSize> allSizes = GlazedLists.eventList((Collection)InventoryItemSize.getAllSizes());
    private final EventList<InventoryItemPortion> allPortions = GlazedLists.eventList((Collection)InventoryItemPortion.getAllPortions());
    private final EventList<InventoryCategory> allCategories = GlazedLists.eventList((Collection)InventoryCategory.getAllCategories());
    private final EventList<PrinterGroup> allPrinterGroups = GlazedLists.eventList((Collection)PrinterGroup.getPrinterGroups());
    private final EventList<InventoryAddGroup> allPlusGroups = GlazedLists.eventList((Collection)InventoryAddGroup.getAllAddGroups());
    private final EventList<InventoryOptionGroup> allOptionGroups = GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups());
    private final EventList allSystemStates = GlazedLists.readOnlyList((EventList)GlazedLists.eventList(Arrays.asList("ACTIVE", "INACTIVE")));
    private MenuItemSetupSearcher searcher;
    private JPanel controlPanel;
    private MinusObjectEditor minusEditor;
    private JCheckBox loyaltyPointsCheckBox;

    public MenuItemSetupState() {
        super("Items", AllPermissions.EDIT_PRICES, "Edit menu item sequence and color");
        AuditableDeferredSaveStrategy saveStrategy = SaveStrategyFactory.getAuditableDeferredSaveStrategy((Refreshable)this, 17L);
        this.setSaveStrategy(saveStrategy);
        this.setUsePrintAction(true);
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.minusEditor.initialize();
        this.initLists();
        if (this.allProfiles.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "A profile must be created before using the item editor.");
            return;
        }
        if (this.allPriceLevels.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "A price level must be created before using the item editor.");
            return;
        }
        if (this.allSizes.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "At least one size must be created before using the item editor.");
            return;
        }
        if (this.allPrinterGroups.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "At least one PrinterGroup must be created before using the item editor.");
            return;
        }
        this.reloadGroup();
        this.addSelectionDependentAction((Action)((Object)new PrintShelfLabelReportAction()));
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getCopyAction());
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
        this.addSelectionDependentAction((Action)((Object)new DuplicateSelectedAction()));
        this.applyPriceLevelRestrictions();
    }

    @Override
    public ObjectEditor<ItemSummary> createObjectEditor() {
        return null;
    }

    @Override
    protected String getObjectLabel(ItemSummary toGet) {
        return toGet.getName();
    }

    @Override
    protected ItemSummary createNewObject() {
        ItemSummary summary = new ItemSummary();
        summary.setSystemState("ACTIVE");
        summary.setName("No Label");
        if (this.searcher.getSelectedGroup() != null) {
            summary.setInventoryGroup(this.searcher.getSelectedGroup());
        } else {
            List groups = InventoryProfile.getProfileGroups((InventoryProfile)this.searcher.getCurrentProfile());
            if (groups.size() == 0) {
                InventoryGroup group = new InventoryGroup();
                group.setProfile(this.searcher.getCurrentProfile());
                group.setLabel("New Group");
                group.save();
                groups.add(group);
            }
            summary.setInventoryGroup((InventoryGroup)groups.get(0));
        }
        summary.setPriceLevel(this.searcher.getSelectedPriceLevel());
        if (summary.getPriceLevel() != null) {
            summary.setPrice(new Price(0.0, 0.01));
        }
        summary.setProfile(this.searcher.getCurrentProfile());
        summary.setSize((InventoryItemSize)InventoryItemSize.getAllSizes().get(0));
        summary.setCategory(InventoryCategory.getDefaultCategory());
        summary.setPortion(InventoryItemPortion.getPortion((String)"Whole"));
        summary.setPrinterGroup((PrinterGroup)PrinterGroup.getPrinterGroups().get(0));
        summary.setTaxCodes(TaxCode.getDefaultTaxCodes());
        return summary;
    }

    @Override
    public String getTypeName() {
        return "Menu Item";
    }

    @Override
    public TableStateCentralArea<ItemSummary> createCentralArea() {
        this.minusEditor = new MinusObjectEditor(this);
        PersistentObjectTable<ItemSummary> table = new PersistentObjectTable<ItemSummary>(this.getObjectList(), (ColumnTableFormat)new ItemSummaryColumnFormat(this, this.minusEditor)){

            @Override
            protected EditMultiple createEditMultiple() {
                return new ItemSummaryEditMultiple();
            }
        };
        table.getTable().setHorizontalScrollEnabled(true);
        table.getTable().setName("menuItemSetupTable");
        Box filterBox = Box.createVerticalBox();
        ColumnVisibilityHelper colorsCheckHelper = new ColumnVisibilityHelper((Object[])ItemSummary.getColorProperties(), new JCheckBox("Show Colors, Sequence"), table.getTable());
        filterBox.add(colorsCheckHelper.getCheckBox());
        ColumnVisibilityHelper portionCheckHelper = new ColumnVisibilityHelper((Object[])ItemSummary.getPortionProperties(), new JCheckBox("Show Portion"), table.getTable());
        filterBox.add(portionCheckHelper.getCheckBox());
        ArrayList extendedProperties = new ArrayList();
        Collections.addAll(extendedProperties, ItemSummary.getExtendedProperties());
        if (!DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            table.getTable().getColumnExt((Object)ItemSummary.Properties.NUM_PATRONS).setVisible(false);
            extendedProperties.remove(ItemSummary.Properties.NUM_PATRONS);
        }
        ColumnVisibilityHelper extendedPropsCheckHelper = new ColumnVisibilityHelper((Object[])extendedProperties.toArray(new PropertiedObject.Property[extendedProperties.size()]), new JCheckBox("Show Extended View"), table.getTable());
        filterBox.add(extendedPropsCheckHelper.getCheckBox());
        ((TableColumnExt)table.getTable().getColumn(1)).setVisible(false);
        ((TableColumnExt)table.getTable().getColumn(0)).setVisible(ExperimentalFeatureHelper.isShowItemIds());
        ColumnVisibilityHelper loyaltyCheckHelper = new ColumnVisibilityHelper((Object[])ItemSummary.getLoyaltyProperties(), new JCheckBox("Show Loyalty Points"), table.getTable());
        this.loyaltyPointsCheckBox = loyaltyCheckHelper.getCheckBox();
        filterBox.add(this.loyaltyPointsCheckBox);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.add((Component)this.getSearchFactory().getSearchPanel(), "Center");
        this.controlPanel.add((Component)filterBox, "East");
        table.add((Component)this.controlPanel, "North");
        return table;
    }

    @Override
    protected JPanel getControlPanel() {
        return this.controlPanel;
    }

    @Override
    public Class<ItemSummary> getDisplayingType() {
        return ItemSummary.class;
    }

    @Override
    public void refresh() {
        this.promptForSave();
        this.initLists();
        PersistenceManager.getInstance().clearLocalCaches();
        this.reloadGroup();
        this.applyPriceLevelRestrictions();
        super.refresh();
    }

    private void applyPriceLevelRestrictions() {
        ArrayList<PropertiedObject.Property> propList = new ArrayList<PropertiedObject.Property>(PROPS_TO_EXCLUDE_MULTI_EDIT);
        boolean forcedloyalty = this.searcher.getSelectedPriceLevel().isForceLoyaltyFactor();
        if (forcedloyalty) {
            propList.add(ItemSummary.Properties.LOYALTY_ADD);
            propList.add(ItemSummary.Properties.LOYALTY_REDEEM);
            this.loyaltyPointsCheckBox.setSelected(false);
        }
        ((PersistentObjectTable)this.getCentralArea()).setPropertiesToBulkExclude(propList.toArray(new PropertiedObject.Property[propList.size()]));
        ((PersistentObjectTable)this.getCentralArea()).getTable().getColumnExt((Object)ItemSummary.Properties.LOYALTY_ADD).setEditable(!forcedloyalty);
        ((PersistentObjectTable)this.getCentralArea()).getTable().getColumnExt((Object)ItemSummary.Properties.LOYALTY_REDEEM).setEditable(!forcedloyalty);
        this.loyaltyPointsCheckBox.setEnabled(!forcedloyalty);
    }

    @Override
    protected void onEnd() {
        this.promptForSave();
        super.onEnd();
    }

    private void initLists() {
        MenuSetup setup = this.createMenuSetup();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allProfiles, setup.getAvailableProfiles());
        List<PriceLevel> reverseAllPriceLevels = setup.getAvailablePriceLevels();
        Collections.reverse(reverseAllPriceLevels);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPriceLevels, reverseAllPriceLevels);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allSizes, setup.getAvailableSizes());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPortions, setup.getAvailablePortions());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allCategories, setup.getAvailableCategories());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPrinterGroups, setup.getAvailablePrinterGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPlusGroups, setup.getAvailableAddGroups());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allOptionGroups, setup.getAvailableOptionGroups());
    }

    protected MenuSetup createMenuSetup() {
        return new MenuSetup();
    }

    private void reloadGroup() {
        if (this.searcher != null && this.searcher.getCurrentProfile() != null) {
            List groupList = this.searcher.getCurrentProfile().getModifiableProfileGroups(GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup());
            try {
                this.allGroups.getReadWriteLock().writeLock().lock();
                this.allGroups.clear();
                this.allGroups.addAll((Collection)groupList);
            }
            finally {
                this.allGroups.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @Override
    public OfficeMateObjectSearch<ItemSummary> createSearchPanelFactory() {
        if (this.searcher == null) {
            this.initLists();
            this.searcher = this.createSearcher();
            this.searcher.getPriceLevelsField().addAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuItemSetupState.this.applyPriceLevelRestrictions();
                }
            });
        }
        return this.searcher;
    }

    protected MenuItemSetupSearcher createSearcher() {
        return new MenuItemSetupSearcher();
    }

    @Override
    public void preSave() {
    }

    @Override
    public void preCancel() {
    }

    @Override
    public void postSave() {
        SystemCurrentInfo.setMenuUpdate((String)"Item State has Changed");
    }

    private class DuplicateSelectedAction
    extends BasicAction {
        public DuplicateSelectedAction() {
            super("Duplicate", (Icon)IconLoader.get((String)"/officemate/images/new.png"), "Duplicates the selected items.");
        }

        public void actionPerformed(ActionEvent e) {
            List itemsToDuplicate = MenuItemSetupState.this.getCentralArea().getAllSelectedObjects();
            for (ItemSummary toDuplicate : itemsToDuplicate) {
                ItemSummary newItem = new ItemSummary(toDuplicate);
                newItem.setCreateNewItemOnNameChange(true);
                newItem.setName(toDuplicate.getName() + " (duplicate)");
                MenuItemSetupState.this.getObjectList().add(MenuItemSetupState.this.getObjectList().indexOf((Object)toDuplicate) + 1, (Object)newItem);
                MenuItemSetupState.this.gotObjectEdited(newItem);
            }
        }
    }

    private class PrintShelfLabelReportAction
    extends BasicAction {
        public PrintShelfLabelReportAction() {
            super("Print Shelf Labels", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            List itemsToPrint = MenuItemSetupState.this.getCentralArea().getAllSelectedObjects();
            BusinessInfo info = BusinessInfo.getInstance();
            ShelfLabelsReport report = new ShelfLabelsReport(itemsToPrint, info.getLabelReport());
            try {
                report.generate();
                JDialog reportDisplay = new JDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error Printing Shelf Labels", (Throwable)e1);
            }
        }
    }

    private class ItemSummaryColumnFormat
    extends ColumnTableFormat {
        private AutoCompleteComboCellEditor sectionCombo;

        public ItemSummaryColumnFormat(AbstractEditableTableState<ItemSummary> menuItemSetupState2, MinusObjectEditor minusEditor) {
            this.sectionCombo = new AutoCompleteComboCellEditor(MenuItemSetupState.this.allGroups).setComboRenderer(new TreeNodeListCellRenderer());
            this.addColumn((ColumnFormat)new PropertyColumnFormat("Unit ID", ItemSummary.Properties.ID));
            this.addColumn((ColumnFormat)new PropertyColumnFormat("Master ID", ItemSummary.Properties.MASTER_ID));
            this.addColumn(new EditablePropertyColumnFormat("Menu Section", ItemSummary.Properties.INVENTORY_GROUP).setCustomEditor((TableCellEditor)((Object)this.sectionCombo)));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.NAME));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.SHORT_NAME));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.DESCRIPTION).setCustomEditor(new TextDialogCellEditor("Decription")));
            this.addColumn((ColumnFormat)new PopupEditableColumnFormat(ItemSummary.Properties.MINUSES, minusEditor, menuItemSetupState2).setFormatter(new DisplayableListFormat(){

                @Override
                protected String getDisplayableLabel(Displayable toDisplay) {
                    InventoryRemove remove = (InventoryRemove)toDisplay;
                    String stringVal = super.getDisplayableLabel((Displayable)remove);
                    if (!remove.getModificationPrice().equals((Object)Price.ZERO)) {
                        stringVal = stringVal + " (" + remove.getModificationPrice() + ")";
                    }
                    return stringVal;
                }
            }));
            if (SystemProperty.getInstance().isStockControlEnabled()) {
                this.addColumn((ColumnFormat)new PopupEditableColumnFormat((PropertiedObject.Property)ItemSummary.Properties.INGREDIENTS, minusEditor, menuItemSetupState2).setFormatter(new DisplayableListFormat(3)));
            }
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.CATEGORY).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allCategories))));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.PRINTER_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allPrinterGroups))));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.ICON));
            this.addColumn((ColumnFormat)new EditableColourColumnFormat(ItemSummary.Properties.FOREGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()));
            this.addColumn((ColumnFormat)new EditableColourColumnFormat(ItemSummary.Properties.BACKGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.SEQUENCE));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allSystemStates))));
            this.addColumn(new EditablePropertyColumnFormat(!SystemProperty.getInstance().isExTax() ? ItemSummary.Properties.PRICE : ItemSummary.Properties.PRICE_EX_TAX).setCustomEditor(new PriceCellEditor(true)));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.LOYALTY_ADD));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.LOYALTY_REDEEM));
            this.addColumn(new PopupEditableColumnFormat(ItemSummary.Properties.TAX_CODES, new TaxCodeSelectionEditor(), menuItemSetupState2));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.SIZE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allSizes))));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.PORTION).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allPortions))));
            final HTMLPreviewEditor htmlEditor = new HTMLPreviewEditor(ItemSummary.Properties.RECIPE);
            this.addColumn(new PopupEditableColumnFormat(ItemSummary.Properties.RECIPE, htmlEditor, menuItemSetupState2).setCustomEditor(new AbstractDialogCellEditor(){

                @Override
                public Object doDialog() {
                    EditorDialog dialog = new EditorDialog(htmlEditor);
                    htmlEditor.setObject((ItemSummary)this.getCurrentValue());
                    dialog.doModal();
                    if (dialog.getOkClicked()) {
                        htmlEditor.saveObject();
                    } else {
                        htmlEditor.revertObject();
                        htmlEditor.setObject((ItemSummary)this.getCurrentValue());
                    }
                    return htmlEditor.getObject();
                }
            }));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.INGREDIENT_ICON));
            this.addColumn(new EditablePropertyColumnFormat(ItemSummary.Properties.PLUS_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(MenuItemSetupState.this.allPlusGroups, true))));
            this.addColumn((ColumnFormat)new PopupEditableColumnFormat((PropertiedObject.Property)ItemSummary.Properties.DEFAULT_ADDS, new DefaultPlusEditor(), menuItemSetupState2).setName("Default Pluses"));
            this.addColumn((ColumnFormat)new PopupEditableColumnFormat(ItemSummary.Properties.OPTION_GROUPS, new OptionGroupLinkEditor((EventList<InventoryOptionGroup>)MenuItemSetupState.this.allOptionGroups), menuItemSetupState2).setFormatter(new DisplayableListFormat(true)));
            this.addColumn(new PopupEditableColumnFormat((PropertiedObject.Property)ItemSummary.Properties.DEFAULT_OPTIONS, new DefaultOptionEditor(), menuItemSetupState2));
            this.addColumn((ColumnFormat)new PopupEditableColumnFormat(ItemSummary.Properties.BARCODES, new BarcodeObjectEditor(), menuItemSetupState2).setFormatter(new DisplayableListFormat()));
            this.addColumn(new EditablePropertyColumnFormat((PropertiedObject.Property)ItemSummary.Properties.OPEN_PRICE));
            this.addColumn(new EditablePropertyColumnFormat((PropertiedObject.Property)ItemSummary.Properties.AUTO_ITEM_NOTE));
            EditablePropertyColumnFormat weightUnitFormat = new EditablePropertyColumnFormat(ItemSummary.Properties.INVENTORY_WEIGHT_UNIT);
            weightUnitFormat.setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])InventoryWeightUnit.values()))));
            this.addColumn(weightUnitFormat);
            EditablePropertyColumnFormat numPatronsFormat = new EditablePropertyColumnFormat(ItemSummary.Properties.NUM_PATRONS);
            this.addColumn(numPatronsFormat);
        }
    }
}

