/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.defaultmod;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;

public class DefaultModHelper {
    private final InventoryItemUnit unit;
    private final Map<InventoryOptionGroup, InventoryOptionGroupLink> linkMap;

    public DefaultModHelper(InventoryItemUnit inventoryItemUnit) {
        this.unit = inventoryItemUnit;
        this.linkMap = new HashMap<InventoryOptionGroup, InventoryOptionGroupLink>();
        for (InventoryOptionGroupLink link : this.unit.getOptionGroupLinks()) {
            this.linkMap.put(link.getOptionGroup(), link);
        }
    }

    public Price getOptionsPrice(List<InventoryOption> options) {
        int count = 0;
        Price optionTally = Price.ZERO_DOLLAR;
        for (InventoryOption option : options) {
            if (++count > this.linkMap.get(option.getOptionGroup()).getReducedZone()) {
                optionTally = optionTally.add(option.getPrice());
                continue;
            }
            optionTally = optionTally.add(option.getPrice().multiply(1.0 - option.getReducedFactor()));
        }
        return optionTally;
    }

    public Price getDefaultAddsPrice() {
        Price addTally = Price.ZERO_DOLLAR;
        for (InventoryDefaultMod mod : this.unit.getDefaultMods()) {
            if (!(mod instanceof InventoryDefaultAdd)) continue;
            addTally = addTally.add(((InventoryDefaultAdd)mod).getAdd().getPrice());
        }
        return addTally;
    }

    public Price getDefaultOptionPrice() {
        if (this.unit.getDefaultMods().size() == 0 || this.unit.getOptionGroupLinks().size() == 0) {
            return Price.ZERO_DOLLAR;
        }
        ArrayList<InventoryDefaultOption> defaultOptions = new ArrayList<InventoryDefaultOption>();
        for (InventoryDefaultMod mod : this.unit.getDefaultMods()) {
            if (!(mod instanceof InventoryDefaultOption)) continue;
            defaultOptions.add((InventoryDefaultOption)mod);
        }
        Price optionTally = Price.ZERO_DOLLAR;
        boolean count = false;
        return optionTally;
    }

    public Price getPriceOfOption(InventoryOption option, List<InventoryOption> currentOptions) {
        int index = this.getIndex(option, currentOptions);
        if (this.linkMap.get(option.getOptionGroup()).getReducedZone() > index) {
            return option.getPrice().multiply(1.0 - option.getReducedFactor());
        }
        return option.getPrice();
    }

    public boolean isValidOption(InventoryOption option, List<InventoryOption> currentOptions) {
        int index = this.getIndex(option, currentOptions);
        InventoryOptionGroupLink link = this.linkMap.get(option.getOptionGroup());
        return !link.hasRealMaximum() || link.getMaxQty() > index;
    }

    public int getIndex(InventoryOption option, List<InventoryOption> currentOptions) {
        int index = -1;
        for (InventoryOption nextOption : currentOptions) {
            if (option.equals((Object)nextOption)) {
                ++index;
                break;
            }
            if (!option.getOptionGroup().equals((Object)nextOption.getOptionGroup())) continue;
            ++index;
        }
        return index;
    }
}

