/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.defaultmod;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import officemate.components.AddRemovePanel;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildRenderer;

public abstract class ParentChildAddRemovePanel<E, P extends PropertiedObject, C extends PropertiedObject>
extends JPanel {
    private AddRemovePanel<C> addRemove;
    private JLabel unitLabel;
    private JLabel summaryLabel;
    private final PropertyAccessor<P> parentProperty;
    private E editedObject;

    public ParentChildAddRemovePanel(PropertyAccessor<P> toParentProperty) {
        super(new BorderLayout());
        this.parentProperty = toParentProperty;
        this.setupComponents();
    }

    public void setEditedObject(E newObject) {
        this.editedObject = newObject;
        this.updateText();
    }

    public E getEditedObject() {
        return this.editedObject;
    }

    private void setupComponents() {
        this.addRemove = new AddRemovePanel();
        this.addRemove.setDuplicatePolicy(AddRemovePanel.DuplicatePolicy.Deny);
        this.addRemove.setPoolComparator(this.createPoolComparator());
        this.addRemove.setPoolRenderer(this.createPoolRenderer());
        this.addRemove.setAddedComparator(this.createAddedComparator());
        this.addRemove.setAddedRenderer(this.createAddedRenderer());
        this.addRemove.changed.connect((Object)this, "gotChanged");
        this.unitLabel = new JLabel("*** Units ***");
        this.summaryLabel = new JLabel("*** Summary ***");
        this.add(this.addRemove, "Center");
        this.add((Component)this.unitLabel, "North");
        this.add((Component)this.summaryLabel, "South");
    }

    protected ListCellRenderer createPoolRenderer() {
        return new ParentChildRenderer(this.parentProperty);
    }

    protected ListCellRenderer createAddedRenderer() {
        return new ParentChildRenderer(this.parentProperty);
    }

    protected Comparator createPoolComparator() {
        return new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                int dif = ((PropertiedObject)ParentChildAddRemovePanel.this.parentProperty.resolveValue(o1)).toString().compareTo(((PropertiedObject)ParentChildAddRemovePanel.this.parentProperty.resolveValue(o2)).toString());
                if (dif == 0) {
                    dif = ((Comparable)o1).compareTo(o2);
                }
                return dif;
            }
        };
    }

    protected Comparator createAddedComparator() {
        return new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                int dif = ((PropertiedObject)ParentChildAddRemovePanel.this.parentProperty.resolveValue(o1)).toString().compareTo(((PropertiedObject)ParentChildAddRemovePanel.this.parentProperty.resolveValue(o2)).toString());
                if (dif == 0) {
                    dif = ParentChildAddRemovePanel.this.addRemove.getRawIndex(o1) - ParentChildAddRemovePanel.this.addRemove.getRawIndex(o2);
                }
                return dif;
            }
        };
    }

    public void gotChanged(Object whatChanged, Boolean added) {
        this.updateText();
    }

    private void updateText() {
        this.unitLabel.setText(this.getUnitText());
        this.summaryLabel.setText(this.getSummaryText());
    }

    protected abstract String getSummaryText();

    protected abstract String getUnitText();

    protected AddRemovePanel<C> getAddRemovePanel() {
        return this.addRemove;
    }

    public List<C> getCurrentAdds() {
        return this.addRemove.getAddedList();
    }

    public void setCurrentAdds(List<C> adds) {
        this.addRemove.setAddedList(adds);
    }

    public void setPool(List<? extends C> pool) {
        this.addRemove.setPoolList(pool);
    }
}

