/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.defaultmod.option;

import au.com.ordermate.util.Price;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.DefaultModHelper;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildAddRemovePanel;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildRenderer;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.ItemSummary;

class OptionAddRemovePanel
extends ParentChildAddRemovePanel<ItemSummary, InventoryOptionGroup, InventoryOption> {
    private AddedOptionRenderer renderer;
    private DefaultModHelper helper;

    public OptionAddRemovePanel() {
        super(InventoryOption.Properties.OPTION_GROUP);
    }

    @Override
    protected String getSummaryText() {
        Price optionTally = this.helper.getOptionsPrice(this.getCurrentAdds());
        Price addTally = this.helper.getDefaultAddsPrice();
        StringBuilder SB = new StringBuilder("<html>");
        SB.append(((ItemSummary)this.getEditedObject()).getPrice());
        SB.append(" + <b>(Options) ").append(optionTally);
        SB.append("</b> + (Plusses) ").append(addTally);
        SB.append(" = " + optionTally.add(addTally.add(((ItemSummary)this.getEditedObject()).getPrice())));
        SB.append("</html>");
        return SB.toString();
    }

    @Override
    public void setEditedObject(ItemSummary newObject) {
        this.helper = new DefaultModHelper(newObject.getInventoryItemUnitObject());
        super.setEditedObject(newObject);
    }

    @Override
    protected String getUnitText() {
        return "You can add Options ordered by default for " + ((ItemSummary)this.getEditedObject()).getName();
    }

    @Override
    protected ListCellRenderer createAddedRenderer() {
        this.renderer = new AddedOptionRenderer();
        return this.renderer;
    }

    class AddedOptionRenderer
    extends ParentChildRenderer<InventoryOptionGroup, InventoryOption> {
        public AddedOptionRenderer() {
            super(InventoryOption.Properties.OPTION_GROUP);
        }

        @Override
        protected void styleChild(JLabel label, InventoryOptionGroup group, InventoryOption option, int childIndex) {
            StringBuilder SB = new StringBuilder(option.toString());
            Price value = OptionAddRemovePanel.this.helper.getPriceOfOption(option, OptionAddRemovePanel.this.getCurrentAdds());
            if (!Price.ZERO_DOLLAR.equals((Object)value)) {
                SB.append(" ").append(value);
            }
            label.setText(SB.toString());
            if (!OptionAddRemovePanel.this.helper.isValidOption(option, OptionAddRemovePanel.this.getCurrentAdds())) {
                label.setBackground(Color.orange);
                label.setOpaque(true);
            } else {
                label.setBackground(null);
                label.setOpaque(false);
            }
        }
    }
}

