/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi.defadds;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildAddRemovePanel;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildRenderer;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryDefaultAdd;
import ordermate.database.inventory.ItemSummary;

class MultiAddPanel
extends ParentChildAddRemovePanel<List<ItemSummary>, InventoryAddGroup, InventoryAdd> {
    private Map<InventoryAdd, Boolean> addRemoveMap;

    MultiAddPanel() {
        super(InventoryAdd.Properties.ADD_GROUP);
    }

    @Override
    protected String getSummaryText() {
        return "";
    }

    @Override
    protected String getUnitText() {
        return "Please select a remove to be removed by default";
    }

    @Override
    protected ListCellRenderer createAddedRenderer() {
        return new AddRemoveRenderer();
    }

    @Override
    protected ListCellRenderer createPoolRenderer() {
        return new AddRemoveRenderer();
    }

    @Override
    public void gotChanged(Object whatChanged, Boolean added) {
        super.gotChanged(whatChanged, added);
        this.addRemoveMap.put((InventoryAdd)whatChanged, added);
    }

    @Override
    public void setEditedObject(List<ItemSummary> newObject) {
        this.addRemoveMap = new LinkedHashMap<InventoryAdd, Boolean>();
        for (ItemSummary summary : newObject) {
            for (InventoryDefaultAdd add : summary.getDefaultAdds()) {
                this.addRemoveMap.put(add.getAdd(), null);
            }
        }
        super.setEditedObject(newObject);
        this.setPool(newObject.get(0).getPlusGroup().getModifications());
        this.setCurrentAdds(new ArrayList<InventoryAdd>(this.addRemoveMap.keySet()));
    }

    Map<InventoryAdd, Boolean> getAddRemoveMap() {
        return this.addRemoveMap;
    }

    class AddRemoveRenderer
    extends ParentChildRenderer<InventoryAddGroup, InventoryAdd> {
        public AddRemoveRenderer() {
            super(InventoryAdd.Properties.ADD_GROUP);
        }

        @Override
        protected void styleChild(JLabel label, InventoryAddGroup parent, InventoryAdd child, int childIndex) {
            label.setText(child.toString());
            if (Boolean.TRUE.equals(MultiAddPanel.this.addRemoveMap.get(child))) {
                label.setBackground(Color.green);
                label.setOpaque(true);
            } else if (Boolean.FALSE.equals(MultiAddPanel.this.addRemoveMap.get(child))) {
                label.setBackground(Color.red);
                label.setOpaque(true);
            } else {
                label.setOpaque(false);
            }
        }
    }
}

