/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi.defoption;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildAddRemovePanel;
import officemate.screens.setup.menu.menuitemsetup.defaultmod.ParentChildRenderer;
import ordermate.database.inventory.InventoryDefaultOption;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.ItemSummary;

class MultiOptionPanel
extends ParentChildAddRemovePanel<List<ItemSummary>, InventoryOptionGroup, InventoryOption> {
    private Map<InventoryOption, Integer> addRemoveMap;

    MultiOptionPanel() {
        super(InventoryOption.Properties.OPTION_GROUP);
    }

    @Override
    protected String getSummaryText() {
        StringBuilder SB = new StringBuilder();
        ArrayList<InventoryOption> adds = new ArrayList<InventoryOption>();
        ArrayList<InventoryOption> removes = new ArrayList<InventoryOption>();
        for (InventoryOption nextKey : this.addRemoveMap.keySet()) {
            Integer value = this.addRemoveMap.get(nextKey);
            if (value == null) continue;
            if (value < 0) {
                removes.add(nextKey);
                continue;
            }
            adds.add(nextKey);
        }
        if (!adds.isEmpty()) {
            SB.append("Added by default: ");
            SB.append(StringUtils.mergeToStringWithSeparator(adds, (String)", ", (Stringifier)new ToStringifier()));
            if (!removes.isEmpty()) {
                SB.append("<br>");
            }
        }
        if (removes.isEmpty()) {
            SB.append("No longer added by default: ").append(StringUtils.mergeToStringWithSeparator(removes, (String)", ", (Stringifier)new ToStringifier()));
        }
        return SB.toString();
    }

    @Override
    protected String getUnitText() {
        return "Select options to be added by default";
    }

    @Override
    protected ListCellRenderer createAddedRenderer() {
        return new AddRemoveRenderer();
    }

    @Override
    protected ListCellRenderer createPoolRenderer() {
        return new AddRemoveRenderer();
    }

    @Override
    public void gotChanged(Object whatChanged, Boolean added) {
        super.gotChanged(whatChanged, added);
        if (Boolean.TRUE.equals(added)) {
            this.addRemoveMap.put((InventoryOption)whatChanged, 1);
        } else {
            this.addRemoveMap.put((InventoryOption)whatChanged, -1);
        }
    }

    @Override
    public void setEditedObject(List<ItemSummary> summaries) {
        List<InventoryOptionGroup> filteredGroups = this.getMatchingOptionGroups(summaries);
        this.addRemoveMap = new LinkedHashMap<InventoryOption, Integer>();
        for (ItemSummary summary : summaries) {
            for (InventoryDefaultOption add : summary.getDefaultOptions()) {
                if (!filteredGroups.contains(add.getOption().getOptionGroup())) continue;
                this.addRemoveMap.put(add.getOption(), null);
            }
        }
        super.setEditedObject(summaries);
        ArrayList allOptions = new ArrayList();
        for (InventoryOptionGroup group : filteredGroups) {
            allOptions.addAll(group.getModifications());
        }
        this.setPool(allOptions);
        this.setCurrentAdds(new ArrayList<InventoryOption>(this.addRemoveMap.keySet()));
    }

    List<InventoryOptionGroup> getMatchingOptionGroups(List<ItemSummary> summaries) {
        List protoGroups = summaries.get(0).getOptionGroups();
        ArrayList<InventoryOptionGroup> matchingGroups = new ArrayList<InventoryOptionGroup>();
        for (InventoryOptionGroup nextGroup : protoGroups) {
            boolean matches = false;
            for (ItemSummary summary : summaries) {
                matches = false;
                for (InventoryOptionGroupLink link : summary.getOptionGroupLinks()) {
                    if (!link.getOptionGroup().equals((Object)nextGroup)) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                break;
            }
            if (!matches) continue;
            matchingGroups.add(nextGroup);
        }
        return matchingGroups;
    }

    Map<InventoryOption, Integer> getAddRemoveMap() {
        return this.addRemoveMap;
    }

    class AddRemoveRenderer
    extends ParentChildRenderer<InventoryOptionGroup, InventoryOption> {
        public AddRemoveRenderer() {
            super(InventoryOption.Properties.OPTION_GROUP);
        }

        @Override
        protected void styleChild(JLabel label, InventoryOptionGroup parent, InventoryOption child, int childIndex) {
            label.setText(child.toString());
            Integer value = (Integer)MultiOptionPanel.this.addRemoveMap.get(child);
            if (value == null) {
                label.setOpaque(false);
            } else if (value < 0) {
                label.setBackground(Color.red);
                label.setOpaque(true);
            } else {
                label.setBackground(Color.green);
                label.setOpaque(true);
            }
        }
    }
}

