/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi.optiongroup;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.MultiOptionGroupLinkEditor;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.OptionGroupAction;
import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.OptionGroupActionType;
import ordermate.database.inventory.InventoryOptionGroup;

class MultiOptionTableModel
extends AbstractTableModel {
    private final MultiOptionGroupLinkEditor multiOptionGroupLinkEditor;
    List<OptionGroupAction> actions;

    MultiOptionTableModel(MultiOptionGroupLinkEditor multiOptionGroupLinkEditor) {
        this.multiOptionGroupLinkEditor = multiOptionGroupLinkEditor;
        this.actions = new ArrayList<OptionGroupAction>();
    }

    void reset() {
        this.actions.clear();
        for (InventoryOptionGroup group : InventoryOptionGroup.getOptionGroups()) {
            OptionGroupAction action = new OptionGroupAction(group);
            this.actions.add(action);
        }
    }

    @Override
    public int getRowCount() {
        return this.actions.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Action";
        }
        if (columnIndex == 1) {
            return "Option Group";
        }
        if (columnIndex == 2) {
            return "Sequence";
        }
        if (columnIndex == 3) {
            return "Min";
        }
        if (columnIndex == 4) {
            return "Max";
        }
        if (columnIndex == 5) {
            return "Reduced Zone";
        }
        return "Summary";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return OptionGroupActionType.class;
        }
        if (columnIndex == 1) {
            return InventoryOptionGroup.class;
        }
        if (columnIndex == 6) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        OptionGroupAction action = this.actions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                value = action.getType();
                break;
            }
            case 1: {
                value = action.getGroup();
                break;
            }
            case 2: {
                value = action.getSequence();
                break;
            }
            case 3: {
                value = action.getMin();
                break;
            }
            case 4: {
                value = action.getMax();
                break;
            }
            case 5: {
                value = action.getReduced();
                break;
            }
            case 6: {
                value = "Summary...";
                break;
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || columnIndex == 6) {
            return true;
        }
        if (columnIndex == 1) {
            return false;
        }
        return this.actions.get(rowIndex).getType().equals((Object)OptionGroupActionType.Update) || this.actions.get(rowIndex).getType().equals((Object)OptionGroupActionType.Add);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        OptionGroupAction action = this.actions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                action.setType(value == null ? OptionGroupActionType.None : (OptionGroupActionType)((Object)value));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                action.setSequence(this.toInteger(value, action.getSequence()));
                break;
            }
            case 3: {
                action.setMin(this.toInteger(value, action.getMin()));
                break;
            }
            case 4: {
                action.setMax(this.toInteger(value, action.getMax()));
                break;
            }
            case 5: {
                action.setReduced(this.toInteger(value, action.getReduced()));
                break;
            }
        }
    }

    Integer toInteger(Object value, Integer defValue) {
        Integer toReturn = defValue;
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            toReturn = ((Number)value).intValue();
        } else {
            String strValue = value.toString().trim();
            if (strValue.length() == 0) {
                return null;
            }
            try {
                toReturn = Integer.getInteger(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return toReturn;
    }
}

