/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menuitemsetup.multi.optiongroup;

import officemate.screens.setup.menu.menuitemsetup.multi.optiongroup.OptionGroupActionType;
import ordermate.database.inventory.InventoryOptionGroup;

class OptionGroupAction {
    private OptionGroupActionType type = OptionGroupActionType.None;
    private final InventoryOptionGroup group;
    private Integer sequence;
    private Integer min;
    private Integer max;
    private Integer reduced;

    OptionGroupAction(InventoryOptionGroup group) {
        this.group = group;
    }

    public OptionGroupActionType getType() {
        return this.type;
    }

    public void setType(OptionGroupActionType type) {
        this.type = type;
    }

    public InventoryOptionGroup getGroup() {
        return this.group;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getReduced() {
        return this.reduced;
    }

    public void setReduced(Integer reduced) {
        this.reduced = reduced;
    }

    public String createMessageForAction() {
        if (this.type == null || OptionGroupActionType.None.equals((Object)this.type)) {
            return "No Action";
        }
        StringBuilder SB = new StringBuilder();
        if (OptionGroupActionType.Add.equals((Object)this.type)) {
            SB.append("For selected item units that are not linked to Option Group <b>").append(this.group).append("</b>:<br>").append("add it with ").append(" sequence as ").append(this.sequence == null ? "default" : this.sequence.toString()).append(", minimum as ").append(this.min == null ? "0" : this.min.toString()).append(", maximum as ").append(this.max == null ? "unlimited" : this.max.toString()).append(" and Reduced Zone as ").append(this.reduced == null ? "0" : this.reduced.toString());
        } else if (OptionGroupActionType.Remove.equals((Object)this.type)) {
            SB.append("For selected item units that are linked to Option Group <b>").append(this.group).append("</b>:<br>").append("remove that link.");
        } else if (OptionGroupActionType.Update.equals((Object)this.type)) {
            if (this.sequence != null || this.min != null || this.max != null || this.reduced != null) {
                SB.append("For selected item units that are already linked to Option Group <b>").append(this.group).append("</b>:<br>");
                boolean mod = false;
                if (this.sequence != null) {
                    SB.append("set the sequence to ").append(this.sequence);
                    mod = true;
                }
                if (this.min != null) {
                    if (mod) {
                        SB.append(", ");
                    }
                    SB.append("set the minimum to ").append(this.min);
                    mod = true;
                }
                if (this.max != null) {
                    if (mod) {
                        SB.append(", ");
                    }
                    SB.append("set the maximum to ").append(this.max);
                    mod = true;
                }
                if (this.reduced != null) {
                    if (mod) {
                        SB.append(" and ");
                    }
                    SB.append("set the reduced zone to ").append(this.reduced);
                }
            } else {
                SB.append("No action will be taken, as nothing is modified.");
            }
        }
        return SB.toString();
    }
}

