/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.menusection;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.image.IconLoader;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.tree.AbstractTreeEditorState;
import officemate.screens.setup.menu.menusection.MenuSectionPanel;
import officemate.screens.setup.menu.menusection.MenuSectionTreeCellRenderer;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.Permission;

public class MenuSectionsState
extends AbstractTreeEditorState<InventoryGroup> {
    private MenuSectionPanel objectEditor;
    private final JComboBox profilesCombobox = new JComboBox();
    private final JPanel searchPanel;
    private InventoryProfile currentProfile;
    private DefaultMutableTreeNode root;

    public MenuSectionsState(Permission permission) {
        super("Sections", permission, "Edit the menu sections.");
        Vector allProfiles = InventoryProfile.getAllProfiles();
        this.profilesCombobox.setModel(new DefaultComboBoxModel());
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.profilesCombobox);
        this.searchPanel = new JPanel(new FlowLayout(0));
        this.profilesCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSectionsState.this.setProfile((InventoryProfile)MenuSectionsState.this.profilesCombobox.getSelectedItem());
            }
        });
        JLabel label = new JLabel("Profile");
        label.setLabelFor(this.profilesCombobox);
        this.searchPanel.add(label);
        this.searchPanel.add(this.profilesCombobox);
        if (allProfiles.size() > 0) {
            this.currentProfile = (InventoryProfile)allProfiles.get(0);
        }
    }

    @Override
    protected AbstractObjectEditor getObjectEditor() {
        if (this.objectEditor == null) {
            throw new IllegalStateException("Object editor has not been initialized");
        }
        return this.objectEditor;
    }

    @Override
    protected JPanel getSearchPanel() {
        return this.searchPanel;
    }

    @Override
    protected DefaultMutableTreeNode getRootNode() {
        if (!SwingUtilities.isEventDispatchThread() && Config.isDebuging()) {
            throw new IllegalStateException("Not running the EDT");
        }
        List profileGroups = this.currentProfile.getAvailableGroups();
        this.root = new DefaultMutableTreeNode(this.currentProfile);
        this.addChildren(this.root, profileGroups);
        return this.root;
    }

    @Override
    protected DefaultTreeCellRenderer getCellRenderer() {
        MenuSectionTreeCellRenderer renderer = new MenuSectionTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/group_blue.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/blue_folder.png"));
        renderer.setClosedIcon(IconLoader.get((String)"/ordermate/images/blue_folder.png"));
        return renderer;
    }

    @Override
    protected boolean isEditable(Object object) {
        return object instanceof InventoryGroup;
    }

    @Override
    protected void init() {
        this.objectEditor = new MenuSectionPanel();
        super.init();
    }

    private void setProfile(InventoryProfile inventoryProfile) {
        this.currentProfile = inventoryProfile;
        super.refresh();
    }

    @Override
    protected void refreshSearchPanel() {
        this.profilesCombobox.setModel(new DefaultComboBoxModel(InventoryProfile.getAllProfiles()));
        this.profilesCombobox.setSelectedItem(this.currentProfile);
    }

    @Override
    protected void setSearchPanelEnabled(boolean enabled) {
        this.profilesCombobox.setEnabled(enabled);
    }

    @Override
    protected Class getDisplayingType() {
        return InventoryGroup.class;
    }

    @Override
    protected boolean canDelete(DefaultMutableTreeNode currentNode) {
        Object userObject = currentNode.getUserObject();
        if (userObject != null && this.getDisplayingType().isAssignableFrom(userObject.getClass())) {
            InventoryGroup group = (InventoryGroup)currentNode.getUserObject();
            if (!this.canModify(group)) {
                Dialogs.showMessageDialog("Cannot Delete", "You do not have permission to delete this section");
                return false;
            }
            int nbItems = group.getRecursiveItems().size();
            if (nbItems > 0 && !Dialogs.showWarningDialog("Really Delete?", "Are you sure you want to delete " + currentNode + " containing " + nbItems + " items?")) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void doSave(DefaultMutableTreeNode node) {
        SystemCurrentInfo.setMenuUpdate((String)("Menu section " + this + "modified."));
        InventoryGroup parent = node.getParent() == null ? null : (InventoryGroup)node.getUserObject();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            InventoryGroup group = (InventoryGroup)child.getUserObject();
            if (!this.canModify(group)) continue;
            group.setParentGroup(parent);
            group.setProfile(this.currentProfile);
            group.save();
            this.doSave(child);
        }
    }

    @Override
    protected List<InventoryGroup> getChildren(InventoryGroup parent) {
        return parent.getAvailableSubGroups();
    }

    @Override
    protected void onEnd() {
        this.refresh();
        super.onEnd();
    }

    @Override
    public void doNewAction() {
        Object thing = this.getSelectedObject();
        if (thing instanceof InventoryGroup && !this.canModify((InventoryGroup)thing)) {
            Dialogs.showMessageDialog("Cannot Modify", "You do not have permission to add a sub-section");
            return;
        }
        super.doNewAction();
    }

    private boolean canModify(InventoryGroup group) {
        return group.canModify(GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionGroup());
    }
}

