/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pluses;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.ColorCellEditor;
import officemate.components.tableformat.renderers.ColorCellRenderer;
import officemate.components.tableformat.renderers.PriceCellEditor;
import officemate.components.tableformat.renderers.ToStringCellRenderer;
import officemate.screens.setup.menu.pluses.InventoryAddGroupEditor;
import officemate.screens.setup.menu.pluses.InventoryAddSearch;
import officemate.screens.setup.stock.ingredients.IngredientsPanel;
import officemate.screens.setup.stock.ingredients.UsageCostProfitPanel;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.usagelink.StockUsageAddLink;
import ordermate.database.users.AllPermissions;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.table.TableColumnExt;

public class InventoryAddGroupState
extends AbstractEditableTableState {
    private EventList allPlusGroups = GlazedLists.eventList((Collection)InventoryAddGroup.getAllAddGroups());
    private ComboSearchField groupSearchField;
    private NewAddAction newAddAction;
    private EditGroupAction editGroupAction;
    private RemoveGroupAction removeGroupAction;
    private NewGroupAction newGroupAction;

    public InventoryAddGroupState() {
        super("Pluses", AllPermissions.INVENTORY_ADDS, "Add, modify and remove Plus items and groups");
        this.setSaveStrategy(SaveStrategyFactory.getDeferredSaveStrategy((Refreshable)this, 1L));
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.newAddAction = new NewAddAction();
        this.addAction((Action)((Object)this.newAddAction));
        this.newGroupAction = new NewGroupAction();
        this.addAction((Action)((Object)this.newGroupAction));
        this.editGroupAction = new EditGroupAction();
        this.addAction((Action)((Object)this.editGroupAction));
        this.removeGroupAction = new RemoveGroupAction();
        this.addAction((Action)((Object)this.removeGroupAction));
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
        this.getEditAction().setEnabled(false);
        this.groupSearchField = ((InventoryAddSearch)this.getSearchFactory()).getGroupSearchField();
        JCheckBox colorCheckBox = new JCheckBox();
        colorCheckBox.setSelected(true);
        colorCheckBox.setText("Show Colours");
        final ColumnVisibilityHelper colVisHelper = new ColumnVisibilityHelper(new Object[]{InventoryAdd.Properties.BACKGROUND_COLOR, InventoryAdd.Properties.FOREGROUND_COLOR}, colorCheckBox, this.getCentralArea().getTable());
        JCheckBox groupByPlusGroup = new JCheckBox("Group results");
        groupByPlusGroup.setSelected(true);
        JPanel checkBoxPanel = new JPanel((LayoutManager)new VerticalLayout());
        checkBoxPanel.add(colorCheckBox);
        checkBoxPanel.add(groupByPlusGroup);
        this.getControlPanel().add((Component)checkBoxPanel, "East");
        JCheckBox showIngredients = this.optionallyInitializeIngredientsPanel();
        ColumnVisibilityHelper tempHelper = null;
        if (showIngredients != null) {
            checkBoxPanel.add(showIngredients);
            tempHelper = new ColumnVisibilityHelper(new Object[]{InventoryAdd.Properties.STOCK_USAGE_LINKS}, showIngredients, this.getCentralArea().getTable());
        }
        final ColumnVisibilityHelper ingredHelper = tempHelper;
        groupByPlusGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupOn = ((JCheckBox)e.getSource()).isSelected() ? InventoryAdd.Properties.ADD_GROUP.getUserVisibleLabel() : null;
                ((PersistentObjectTable)InventoryAddGroupState.this.getCentralArea()).groupOn(groupOn, null);
                JXTable table = ((PersistentObjectTable)InventoryAddGroupState.this.getCentralArea()).getTable();
                colVisHelper.addTable(table);
                if (ingredHelper != null) {
                    ingredHelper.addTable(table);
                }
            }
        });
    }

    private JCheckBox optionallyInitializeIngredientsPanel() {
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            UsageCostProfitPanel stockCostPanel = new UsageCostProfitPanel();
            IngredientsPanel ingredientsPanel = new IngredientsPanel(this, StockUsageAddLink.class, stockCostPanel);
            JCheckBox showIngredientsBox = new JCheckBox();
            this.getScreenPanel().add((Component)ingredientsPanel.getCollapsiblePanel(showIngredientsBox), "South");
            return showIngredientsBox;
        }
        return null;
    }

    protected ObjectEditor createObjectEditor() {
        return new InventoryAddGroupEditor();
    }

    @Override
    public String getTypeName() {
        return "Plus Group";
    }

    protected PersistentObjectTable createCentralArea() {
        this.setFilterActive(true);
        ArrayList<AbstractColumnFormat> columns = new ArrayList<AbstractColumnFormat>(){
            {
                this.add(new PropertyColumnFormat("Plus ID", InventoryAdd.Properties.ID));
                this.add(new PropertyColumnFormat("Master ID", InventoryAdd.Properties.MASTER_ID));
                this.add(new EditablePropertyColumnFormat("Name", InventoryAdd.Properties.LABEL));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.PRICE).setCustomEditor(new PriceCellEditor(true)));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.SEQUENCE));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.BACKGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.FOREGROUND_COLOR).setCustomEditor(new ColorCellEditor()).setCustomRenderer(new ColorCellRenderer()));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.ADD_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(InventoryAddGroupState.this.allPlusGroups))).setCustomRenderer(new ToStringCellRenderer()));
                this.add(new EditablePropertyColumnFormat(InventoryAdd.Properties.AVAILABLE_ONLINE));
            }
        };
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            columns.add((AbstractColumnFormat)new PropertyColumnFormat("Ingredients", InventoryAdd.Properties.STOCK_USAGE_LINKS));
        }
        PersistentObjectTable centralArea = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])columns.toArray(new AbstractColumnFormat[columns.size()])));
        centralArea.setPropertiesToBulkExclude(new PropertiedObject.Property[]{InventoryAdd.Properties.ID, InventoryAdd.Properties.MASTER_ID});
        centralArea.groupOn("Add Group", null);
        ((TableColumnExt)centralArea.getTable().getColumn(1)).setVisible(false);
        ((TableColumnExt)centralArea.getTable().getColumn(0)).setVisible(ExperimentalFeatureHelper.isShowItemIds());
        return centralArea;
    }

    @Override
    public void gotObjectDoubleClicked(Object toEdit) {
    }

    @Override
    protected Class getDisplayingType() {
        return InventoryAddGroup.class;
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        return new InventoryAddSearch(new RefreshAction((Refreshable)this));
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.editGroupAction != null) {
            boolean notOnAny = this.groupSearchField.getSelectedObject() != null && !this.groupSearchField.getSelectedObject().toString().equalsIgnoreCase("Any");
            this.editGroupAction.setEnabled(notOnAny);
            this.removeGroupAction.setEnabled(notOnAny);
            this.newAddAction.setEnabled(notOnAny);
        }
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPlusGroups, InventoryAddGroup.getAllAddGroups());
    }

    private void copyInventoryAddGroup(InventoryAddGroup newGroup, InventoryAddGroup toCopyGroup) {
        for (InventoryAdd inventoryAdd : toCopyGroup.getModifications()) {
            newGroup.addInventoryAdd(new InventoryAdd(inventoryAdd));
        }
    }

    @Override
    protected String getTypeFromObject(Object value) {
        if (value instanceof InventoryAdd) {
            return "Plus";
        }
        return super.getTypeFromObject(value);
    }

    private class NewAddAction
    extends BasicAction {
        NewAddAction() {
            super("New", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!InventoryAddGroupState.this.canCreateOrDelete()) {
                return;
            }
            InventoryAdd toAdd = new InventoryAdd();
            InventoryAddGroup group = (InventoryAddGroup)InventoryAddGroupState.this.groupSearchField.getSelectedObject();
            toAdd.setAddGroup(group);
            InventoryAddGroupState.this.gotObjectEdited(toAdd);
            EventList objectList = InventoryAddGroupState.this.getObjectList();
            objectList.getReadWriteLock().writeLock().lock();
            try {
                objectList.add((Object)toAdd);
            }
            finally {
                objectList.getReadWriteLock().writeLock().unlock();
            }
            JXTable table = InventoryAddGroupState.this.getCentralArea().getTable();
            int lastAddedRow = table.getFilters().convertRowIndexToView(table.getRowCount() - 1);
            table.clearSelection();
            table.addRowSelectionInterval(lastAddedRow, lastAddedRow);
            table.scrollRowToVisible(lastAddedRow);
        }
    }

    private class EditGroupAction
    extends BasicAction {
        EditGroupAction() {
            super("Edit Group", (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            InventoryAddGroup selection = (InventoryAddGroup)InventoryAddGroupState.this.groupSearchField.getSelectedObject();
            if (selection != null && !selection.getLabel().equalsIgnoreCase("Any")) {
                String oldName = selection.getLabel();
                InventoryAddGroupState.this.doDialog(selection);
                if (selection.getLabel().trim().isEmpty() || selection.getLabel().trim().equalsIgnoreCase("any")) {
                    selection.setLabel(oldName);
                }
                selection.save();
                InventoryAddGroupState.this.getSearchFactory().reaquireSearchOptions();
            }
        }
    }

    private class RemoveGroupAction
    extends BasicAction {
        RemoveGroupAction() {
            super("Remove Group", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            Object selection = InventoryAddGroupState.this.groupSearchField.getSelectedObject();
            ArrayList<Object> toDelete = new ArrayList<Object>();
            toDelete.add(selection);
            if (InventoryAddGroupState.this.isDeleteAllowed(toDelete)) {
                ((InventoryAddGroup)selection).delete();
                InventoryAddGroupState.this.getSearchFactory().reaquireSearchOptions();
                InventoryAddGroupState.this.getSearchFactory().resetSearch();
                InventoryAddGroupState.this.getSearchFactory().refresh();
            }
        }
    }

    private class NewGroupAction
    extends BasicAction {
        NewGroupAction() {
            super("New Group", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!InventoryAddGroupState.this.canCreateOrDelete()) {
                return;
            }
            InventoryAddGroup newGroup = new InventoryAddGroup();
            newGroup.setSize((InventoryItemSize)InventoryItemSize.getAllSizes().get(0));
            if (InventoryAddGroupState.this.doDialog(newGroup)) {
                String label = newGroup.getLabel();
                if (!label.isEmpty() && !label.equalsIgnoreCase("Any")) {
                    if (InventoryAddGroupState.this.getObjectEditor() instanceof InventoryAddGroupEditor && ((InventoryAddGroupEditor)InventoryAddGroupState.this.getObjectEditor()).isCopyFromInventoryAddGroupSelected()) {
                        InventoryAddGroupState.this.copyInventoryAddGroup(newGroup, ((InventoryAddGroupEditor)InventoryAddGroupState.this.getObjectEditor()).getCopyFromInventoryAddGroup());
                    }
                    newGroup.save();
                    InventoryAddGroupState.this.getSearchFactory().reaquireSearchOptions();
                    ((DeferredSaveStrategy)InventoryAddGroupState.this.getSaveStrategy()).clear();
                    InventoryAddGroupState.this.groupSearchField.setSelectedObject((Object)newGroup);
                } else {
                    newGroup.delete();
                }
            }
        }
    }
}

