/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pluses;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.Action;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.searchers.inventoryitem.InventoryAddSearcher;

class InventoryAddSearch
extends ObjectPropertySearch<InventoryAdd> {
    private ComboSearchField groupSearchField;
    private EventList allPlusGroups = GlazedLists.eventList((Collection)InventoryAddGroup.getAllAddGroups());
    private InventoryAddSearcher searcher = (InventoryAddSearcher)super.getPropertySearcher();

    public InventoryAddSearch(RefreshAction action) {
        super(InventoryAdd.class);
        this.groupSearchField = new ComboSearchField("Plus Group", this.searcher.getPlusGroupFilter(), true, (Action)action, this.allPlusGroups);
        this.addSearchField((SearchGuiField)this.groupSearchField);
        this.addSearchField((SearchGuiField)new StringSearchField("Name", this.searcher.getPlusNameFilter(), (Action)action));
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            StringSearchField guiFilterBinding = new StringSearchField("Stock Item", this.searcher.getStockItemFilter(), (Action)action);
            this.addSearchField((SearchGuiField)guiFilterBinding);
        }
    }

    @Override
    public void reaquireSearchOptions() {
        super.reaquireSearchOptions();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.allPlusGroups, InventoryAddGroup.getAllAddGroups());
    }

    public ComboSearchField getGroupSearchField() {
        return this.groupSearchField;
    }

    @Override
    protected final ObjectQuerySearcher<InventoryAdd> constructPropertySearcher() {
        return new InventoryAddSearcher();
    }
}

