/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.pricelevels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import officemate.adminkit.AddRemoveButtonPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.table.DefaultObjectTable;
import officemate.adminkit.table.ObjectTableModel;
import officemate.adminkit.templates.Templates;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.PriceLevelRule;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PriceLevelsPanel
extends JPanel {
    private String[] displayColumns;
    public final Signal spinUpPressed;
    public final Signal spinDownPressed;
    public final Signal objectChosen;
    public final Signal objectSelected;
    public final Signal objectDeselected;
    private AddRemoveButtonPanel buttonPanel;
    private DefaultObjectTable table;
    private boolean overrideAllowed;

    public PriceLevelsPanel() {
        super(new BorderLayout());
        this.displayColumns = new String[]{"Name", PriceLevel.Properties.SEQUENCE.getUserVisibleLabel(), PriceLevel.Properties.TRIGGER_ACTIVATION_STRATEGY.getUserVisibleLabel(), PriceLevel.Properties.SHOW_ON_RECEIPT.getUserVisibleLabel(), PriceLevel.Properties.DEFAULT_LEVEL.getUserVisibleLabel()};
        this.spinUpPressed = Signals.createSignal();
        this.spinDownPressed = Signals.createSignal();
        this.objectChosen = Signals.createSignal(PriceLevel.class, (String)"priceLevel");
        this.objectSelected = Signals.createSignal(PriceLevel.class, (String)"priceLevel");
        this.objectDeselected = Signals.createSignal(PriceLevel.class, (String)"priceLevel");
        this.overrideAllowed = false;
        Permission editPermission = AllPermissions.EDIT_PRICE_LEVELS;
        this.setupButtonPanel(editPermission);
        this.setupTable();
        JPanel sidePanel = new JPanel(new BorderLayout());
        sidePanel.add((Component)this.buttonPanel, "North");
        this.add((Component)sidePanel, "East");
        this.add((Component)this.table.getScroller(), "Center");
        this.updateEnabledStates();
    }

    private void setupButtonPanel(Permission editPermission) {
        this.buttonPanel = new AddRemoveButtonPanel.AddRemovePanelBuilder().setAllowAdd(false).setAllowEdit(false).setAllowRemove(false).setAllowSpinning(true).setCrudPermissions(editPermission).build();
        this.buttonPanel.spinDownPressed.connect(this.spinDownPressed);
        this.buttonPanel.spinUpPressed.connect(this.spinUpPressed);
    }

    protected final void updateEnabledStates() {
        boolean itemSelected = this.table.getSelectedObject() != null;
        this.buttonPanel.enableSpinButtons(itemSelected);
    }

    public boolean isAutoFillOutValid() {
        boolean isValid = false;
        PriceLevel level = (PriceLevel)this.table.getSelectedObject();
        if (level != null && level.canAutoFillOut() && (!level.getRuleToApply().equals((Object)PriceLevelRule.OVERRIDE_RULE) || this.overrideAllowed)) {
            isValid = true;
        }
        return isValid;
    }

    public void addObject(PriceLevel priceLevel) {
        this.table.addObject(priceLevel);
        this.table.setObjects(this.table.getObjects());
        this.table.setSelectedObject(priceLevel);
        this.updateEnabledStates();
        this.repaint();
    }

    public void removeObject(Object object) {
        int selRow = this.table.getSelectedRow();
        this.table.removeObject(object);
        OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, selRow);
        this.updateEnabledStates();
        this.repaint();
    }

    public PriceLevel getSelectedObject() {
        return (PriceLevel)this.table.getSelectedObject();
    }

    public void setObjects(List list) {
        this.table.setObjects(list);
    }

    public void setSelection(PriceLevel priceLevelToSelect) {
        this.table.setSelectedObject(priceLevelToSelect);
        this.updateEnabledStates();
    }

    public List getObjects() {
        return this.table.getObjects();
    }

    public void setOverrideAllowed(boolean checkOverrideAllowed) {
        this.overrideAllowed = checkOverrideAllowed;
    }

    private void setupTable() {
        this.table = new DefaultObjectTable(Templates.PRICE_LEVEL, this.displayColumns, null);
        this.table.objectChosen.connect((Object)this, "gotObjectChosen");
        this.table.objectSelected.connect((Object)this, "gotObjectSelected");
        this.table.objectDeselected.connect((Object)this, "gotObjectDeselected");
        ObjectTableModel model = this.table.getObjectModel();
        model.setColumnEditable(model.findColumn("Name"), false);
        model.setColumnEditable(model.findColumn(PriceLevel.Properties.TRIGGER_ACTIVATION_STRATEGY.getUserVisibleLabel()), false);
        model.setColumnEditable(model.findColumn(PriceLevel.Properties.SHOW_ON_RECEIPT.getUserVisibleLabel()), false);
    }

    void gotObjectChosen(Object obj) {
        this.objectChosen.emit(obj);
    }

    void gotObjectSelected(Object obj) {
        this.objectSelected.emit(obj);
        this.updateEnabledStates();
    }

    void gotObjectDeselected(Object obj) {
        PriceLevel level = (PriceLevel)obj;
        if (level.hasChanged()) {
            level.save();
        }
        this.objectDeselected.emit(obj);
        this.updateEnabledStates();
    }
}

