/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.profiles;

import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.ConfigDisplayProfile;
import ordermate.database.inventory.InventoryProfile;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class ProfileLinkingEditPanel
extends AbstractObjectEditor<ConfigDisplayProfile> {
    private JComboBox cmbProfile;
    private JComboBox cmbLocation;
    private JComboBox cmbAccountType;

    public ProfileLinkingEditPanel(EventList<String> accountTypesList) {
        this.initEditorUI(accountTypesList);
    }

    private void initEditorUI(EventList<String> accountTypesList) {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.cmbProfile = this.setupComboBox(ConfigDisplayProfile.Properties.INVENTORY_PROFILE, (ComboBoxModel)new ListComboBoxModel((List)InventoryProfile.getAllProfiles()), (Validator)new NotEmptyValidator());
        builder.addRow("Inventory Profile", (Component)this.cmbProfile);
        this.cmbLocation = this.setupComboBox(ConfigDisplayProfile.Properties.TERMINAL_LOCATION, (ComboBoxModel)new ListComboBoxModel(TerminalLocation.getTerminalLocations()), (Validator)new NotEmptyValidator());
        builder.addRow("Location", (Component)this.cmbLocation);
        this.cmbAccountType = this.setupComboBox(ConfigDisplayProfile.Properties.ACCOUNT_TYPE, (ComboBoxModel)new ListComboBoxModel(accountTypesList), (Validator)new NotEmptyValidator());
        builder.addRow("Account Type", (Component)this.cmbAccountType);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void setObject(ConfigDisplayProfile toEdit) {
        if (this.cmbProfile != null) {
            this.cmbProfile.setModel(new ListComboBoxModel((List)InventoryProfile.getAllProfiles()));
        }
        super.setObject(toEdit);
        this.setDefaultOptionIfNull(this.cmbProfile);
        this.setDefaultOptionIfNull(this.cmbLocation);
        this.setDefaultOptionIfNull(this.cmbAccountType);
    }

    private void setDefaultOptionIfNull(JComboBox combo) {
        if (combo.getSelectedIndex() == -1 && combo.getModel().getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }
}

