/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.menu.profiles;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.strategy.DeferredSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.menu.profiles.ProfileLinkingEditPanel;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.ConfigDisplayProfile;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.sales.AccountType;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class ProfileLinkingState
extends AbstractEditableTableState<ConfigDisplayProfile> {
    private EventList<String> accountTypes;

    public ProfileLinkingState() {
        super("Profile Linking", AllPermissions.ACCESS_MENU_PROFILES, "Link the menu profiles to terminals.");
        DeferredSaveStrategy strategy = new DeferredSaveStrategy((Refreshable)this, 1L);
        this.setSaveStrategy(strategy);
        this.buildAccountTypesList();
    }

    @Override
    protected ObjectEditor<ConfigDisplayProfile> createObjectEditor() {
        return new ProfileLinkingEditPanel(this.accountTypes);
    }

    @Override
    public String getTypeName() {
        return "Profile Linking";
    }

    @Override
    protected TableStateCentralArea<ConfigDisplayProfile> createCentralArea() {
        return new PersistentObjectTable<ConfigDisplayProfile>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(ConfigDisplayProfile.Properties.INVENTORY_PROFILE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)InventoryProfile.getAllProfiles()), false))), new EditablePropertyColumnFormat(ConfigDisplayProfile.Properties.TERMINAL_LOCATION).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)TerminalLocation.getTerminalLocations()), false))), new EditablePropertyColumnFormat(ConfigDisplayProfile.Properties.ACCOUNT_TYPE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.accountTypes, false)))}));
    }

    @Override
    protected Class<ConfigDisplayProfile> getDisplayingType() {
        return ConfigDisplayProfile.class;
    }

    private void buildAccountTypesList() {
        this.accountTypes = new BasicEventList();
        this.accountTypes.add((Object)AccountType.allType.getLabel());
        for (AccountType accType : AccountType.getTypes()) {
            this.accountTypes.add((Object)accType.getLabel());
        }
    }
}

